/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.network.tcp;

import java.nio.channels.SocketChannel;
import org.voovan.network.IoSession;
import org.voovan.network.MessageSplitter;
import org.voovan.network.tcp.TcpSocket;
import org.voovan.tools.log.Logger;

public class TcpSession
extends IoSession<TcpSocket> {
    private SocketChannel socketChannel;

    TcpSession(TcpSocket tcpSocket) {
        super(tcpSocket);
        if (tcpSocket != null) {
            this.socketChannel = tcpSocket.socketChannel();
        } else {
            Logger.error("Socket is null, please check it.");
        }
    }

    @Override
    public String localAddress() {
        if (this.socketChannel.isOpen()) {
            return this.socketChannel.socket().getLocalAddress().getHostAddress();
        }
        return null;
    }

    @Override
    public int loaclPort() {
        if (this.socketChannel.isOpen()) {
            return this.socketChannel.socket().getLocalPort();
        }
        return -1;
    }

    @Override
    public String remoteAddress() {
        if (this.socketChannel.isOpen()) {
            return this.socketChannel.socket().getInetAddress().getHostAddress();
        }
        return null;
    }

    @Override
    public int remotePort() {
        if (this.socketChannel.isOpen()) {
            return this.socketChannel.socket().getPort();
        }
        return -1;
    }

    protected SocketChannel socketChannel() {
        if (this.socketChannel.isOpen()) {
            return this.socketChannel;
        }
        return null;
    }

    @Override
    protected MessageSplitter getMessagePartition() {
        return ((TcpSocket)this.socketContext()).messageSplitter();
    }

    @Override
    public boolean isConnected() {
        return ((TcpSocket)this.socketContext()).isConnected();
    }

    @Override
    public boolean isOpen() {
        return ((TcpSocket)this.socketContext()).isOpen();
    }

    @Override
    public boolean close() {
        return ((TcpSocket)this.socketContext()).close();
    }

    @Override
    public String toString() {
        return "[" + this.localAddress() + ":" + this.loaclPort() + "] -> [" + this.remoteAddress() + ":" + this.remotePort() + "]";
    }
}

