/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.network.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.spi.SelectorProvider;
import org.voovan.network.ConnectModel;
import org.voovan.network.SocketContext;
import org.voovan.network.tcp.TcpSession;
import org.voovan.tools.log.Logger;

public class TcpServerSocket
extends SocketContext<ServerSocketChannel, TcpSession> {
    private SelectorProvider provider;
    private ServerSocketChannel serverSocketChannel;
    private Object waitObj = new Object();

    public TcpServerSocket(String host, int port, int readTimeout) throws IOException {
        super(host, port, readTimeout);
        this.init();
    }

    public TcpServerSocket(String host, int port, int readTimeout, int idleInterval) throws IOException {
        super(host, port, readTimeout, idleInterval);
        this.init();
    }

    public TcpServerSocket(String host, int port, int readTimeout, int sendTimeout, int idleInterval) throws IOException {
        super(host, port, readTimeout, sendTimeout, idleInterval);
        this.init();
    }

    private void init() throws IOException {
        this.provider = SelectorProvider.provider();
        this.serverSocketChannel = this.provider.openServerSocketChannel();
        this.serverSocketChannel.socket().setSoTimeout(this.readTimeout);
        this.serverSocketChannel.configureBlocking(false);
        this.connectModel = ConnectModel.LISTENER;
    }

    @Override
    public void setIdleInterval(int idleInterval) {
        this.idleInterval = idleInterval;
    }

    @Override
    public <T> void setOption(SocketOption<T> name, T value) throws IOException {
        this.serverSocketChannel.setOption((SocketOption)name, (Object)value);
    }

    @Override
    public ServerSocketChannel socketChannel() {
        return this.serverSocketChannel;
    }

    @Override
    public TcpSession getSession() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        this.syncStart();
        Object object = this.waitObj;
        synchronized (object) {
            try {
                this.waitObj.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void syncStart() throws IOException {
        this.serverSocketChannel.bind(new InetSocketAddress(this.host, this.port), 1000);
        this.bindToSocketSelector(16);
    }

    @Override
    protected void acceptStart() throws IOException {
        throw new RuntimeException("Unsupport method");
    }

    @Override
    public boolean isOpen() {
        if (this.serverSocketChannel != null) {
            return this.serverSocketChannel.isOpen();
        }
        return false;
    }

    @Override
    public boolean isConnected() {
        if (this.serverSocketChannel != null) {
            return this.serverSocketChannel.isOpen();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean close() {
        if (this.serverSocketChannel != null && this.serverSocketChannel.isOpen()) {
            try {
                this.serverSocketChannel.close();
                Object object = this.waitObj;
                synchronized (object) {
                    this.waitObj.notify();
                }
                return true;
            }
            catch (IOException e) {
                Logger.error("SocketChannel close failed", e);
                return false;
            }
        }
        Object object = this.waitObj;
        synchronized (object) {
            this.waitObj.notify();
        }
        return true;
    }
}

