/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.network.messagesplitter;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.voovan.http.HttpRequestType;
import org.voovan.http.HttpSessionParam;
import org.voovan.network.IoSession;
import org.voovan.network.MessageSplitter;

public class HttpMessageSplitter
implements MessageSplitter {
    @Override
    public int canSplite(IoSession session, ByteBuffer byteBuffer) {
        int result = -1;
        if (byteBuffer.limit() == 0) {
            return -1;
        }
        if (!HttpRequestType.WEBSOCKET.equals(session.getAttribute(HttpSessionParam.TYPE))) {
            if (!session.containAttribute(HttpSessionParam.TYPE)) {
                session.setAttribute(HttpSessionParam.TYPE, (Object)HttpRequestType.HTTP);
            }
            return 0;
        }
        result = HttpMessageSplitter.isWebSocketFrame(byteBuffer);
        return result;
    }

    public static int isWebSocketFrame(ByteBuffer buffer) {
        int expectPackagesize;
        int maxpacketsize = buffer.remaining();
        if (maxpacketsize < (expectPackagesize = 2)) {
            return -2;
        }
        byte finByte = buffer.get();
        boolean fin = finByte >> 8 != 0;
        byte rsv = (byte)((finByte & 0x7F) >> 4);
        if (rsv != 0) {
            return -2;
        }
        byte maskByte = buffer.get();
        boolean mask = (maskByte & 0xFFFFFF80) != 0;
        int payloadlength = maskByte & 0x7F;
        byte optcode = (byte)(finByte & 0xF);
        if (optcode < 0 && optcode > 10) {
            return -2;
        }
        if (!(fin || optcode != 9 && optcode != 10 && optcode != 8)) {
            return -2;
        }
        if (payloadlength < 0 || payloadlength > 125) {
            if (optcode == 9 || optcode == 10 || optcode == 8) {
                return -2;
            }
            if (payloadlength == 126) {
                expectPackagesize += 2;
                byte[] sizebytes = new byte[3];
                sizebytes[1] = buffer.get();
                sizebytes[2] = buffer.get();
                payloadlength = new BigInteger(sizebytes).intValue();
            } else {
                expectPackagesize += 8;
                byte[] bytes = new byte[8];
                for (int i = 0; i < 8; ++i) {
                    bytes[i] = buffer.get();
                }
                long length = new BigInteger(bytes).longValue();
                if (length <= Integer.MAX_VALUE) {
                    payloadlength = (int)length;
                }
            }
        }
        expectPackagesize += mask ? 4 : 0;
        if (maxpacketsize < (expectPackagesize += payloadlength)) {
            buffer.position(0);
            return -2;
        }
        buffer.position(0);
        return expectPackagesize;
    }
}

