/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.network.filter;

import java.io.IOException;
import org.voovan.network.IoFilter;
import org.voovan.network.IoSession;
import org.voovan.network.exception.IoFilterException;
import org.voovan.network.filter.ByteFilter;
import org.voovan.tools.TZip;
import org.voovan.tools.log.Logger;

public class ZipFilter
implements IoFilter {
    @Override
    public Object decode(IoSession session, Object object) throws IoFilterException {
        if (object.getClass() == ByteFilter.BYTE_ARRAY_CLASS) {
            try {
                return TZip.decodeGZip((byte[])object);
            }
            catch (IOException e) {
                Logger.error("ZipFilter decode error, socket will be close");
                session.close();
            }
        }
        return null;
    }

    @Override
    public Object encode(IoSession session, Object object) throws IoFilterException {
        if (object.getClass() == ByteFilter.BYTE_ARRAY_CLASS) {
            try {
                return TZip.encodeGZip((byte[])object);
            }
            catch (IOException e) {
                Logger.error("ZipFilter encode error, socket will be close");
                session.close();
            }
        }
        return null;
    }
}

