/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.network.filter;

import java.nio.ByteBuffer;
import org.voovan.network.IoFilter;
import org.voovan.network.IoSession;
import org.voovan.network.filter.ByteFilter;
import org.voovan.tools.buffer.TByteBuffer;

public class StringFilter
implements IoFilter {
    private boolean isByteBuffer;

    public StringFilter(boolean isByteBuffer) {
        this.isByteBuffer = isByteBuffer;
    }

    public StringFilter() {
        this.isByteBuffer = true;
    }

    @Override
    public Object encode(IoSession session, Object object) {
        if (object instanceof String) {
            String sourceString = object.toString();
            if (this.isByteBuffer) {
                return ByteBuffer.wrap(sourceString.getBytes());
            }
            return sourceString.getBytes();
        }
        return object;
    }

    @Override
    public Object decode(IoSession session, Object object) {
        if (object instanceof ByteBuffer && this.isByteBuffer) {
            return TByteBuffer.toString((ByteBuffer)object);
        }
        if (object.getClass() == ByteFilter.BYTE_ARRAY_CLASS && !this.isByteBuffer) {
            return new String((byte[])object);
        }
        return object;
    }
}

