/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.network.filter;

import org.voovan.network.IoFilter;
import org.voovan.network.IoSession;
import org.voovan.network.exception.IoFilterException;
import org.voovan.network.filter.ByteFilter;
import org.voovan.tools.log.Logger;
import org.voovan.tools.security.Cipher;

public class CipherFilter
implements IoFilter {
    Cipher cipher;

    public CipherFilter(Cipher cipher) {
        this.cipher = cipher;
    }

    @Override
    public Object decode(IoSession session, Object object) throws IoFilterException {
        if (object.getClass() == ByteFilter.BYTE_ARRAY_CLASS) {
            try {
                return this.cipher.decrypt((byte[])object);
            }
            catch (Exception e) {
                Logger.error("CipherFilter decode error, socket will be close", e);
                session.close();
            }
        }
        return null;
    }

    @Override
    public Object encode(IoSession session, Object object) throws IoFilterException {
        if (object.getClass() == ByteFilter.BYTE_ARRAY_CLASS) {
            try {
                return this.cipher.encrypt((byte[])object);
            }
            catch (Exception e) {
                Logger.error("CipherFilter encode error, socket will be close", e);
                session.close();
            }
        }
        return null;
    }
}

