/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.network.filter;

import java.nio.ByteBuffer;
import org.voovan.network.IoFilter;
import org.voovan.network.IoSession;
import org.voovan.tools.log.Logger;

public class ByteFilter
implements IoFilter {
    public static Class BYTE_ARRAY_CLASS = new byte[0].getClass();
    public static byte SPLITER = (byte)-1;
    public static int HEAD_LEGNTH = 6;

    @Override
    public Object encode(IoSession session, Object object) {
        if (object.getClass() == BYTE_ARRAY_CLASS) {
            byte[] data = (byte[])object;
            ByteBuffer byteBuffer = ByteBuffer.allocate(HEAD_LEGNTH + data.length);
            byteBuffer.put(SPLITER);
            byteBuffer.putInt(data.length);
            byteBuffer.put(SPLITER);
            byteBuffer.put(data);
            byteBuffer.flip();
            return byteBuffer;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object decode(IoSession session, Object object) {
        if (object instanceof ByteBuffer) {
            boolean success = false;
            ByteBuffer byteBuffer = (ByteBuffer)object;
            int originPosition = byteBuffer.position();
            try {
                if (byteBuffer.remaining() < HEAD_LEGNTH) {
                    Logger.error("ByteFilter decode error: Not enough data length, socket will be close");
                    Object var6_6 = null;
                    return var6_6;
                }
                if (byteBuffer.get() == SPLITER) {
                    int length = byteBuffer.getInt();
                    if (byteBuffer.get() == SPLITER) {
                        if (length > 0) {
                            byte[] data = new byte[length];
                            byteBuffer.get(data);
                            success = true;
                            byte[] byArray = data;
                            return byArray;
                        }
                    } else {
                        Logger.error("ByteFilter decode error: payloadLength end not exists, socket will be close");
                        session.close();
                    }
                } else {
                    Logger.error("ByteFilter decode error: payloadLength head not exists, socket will be close");
                    session.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                session.close();
            }
            finally {
                if (!success) {
                    byteBuffer.position(originPosition);
                }
            }
        }
        return null;
    }
}

