/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.network;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.voovan.Global;
import org.voovan.network.ConnectModel;
import org.voovan.network.EventRunner;
import org.voovan.network.EventTrigger;
import org.voovan.network.HeartBeat;
import org.voovan.network.IoSession;
import org.voovan.network.MessageLoader;
import org.voovan.network.NioUtil;
import org.voovan.network.SSLParser;
import org.voovan.network.SocketContext;
import org.voovan.network.tcp.TcpServerSocket;
import org.voovan.network.tcp.TcpSocket;
import org.voovan.network.udp.UdpServerSocket;
import org.voovan.network.udp.UdpSession;
import org.voovan.network.udp.UdpSocket;
import org.voovan.tools.TEnv;
import org.voovan.tools.buffer.ByteBufferChannel;
import org.voovan.tools.buffer.TByteBuffer;
import org.voovan.tools.collection.SimpleArraySet;
import org.voovan.tools.hashwheeltimer.HashWheelTask;
import org.voovan.tools.log.Logger;
import org.voovan.tools.reflect.TReflect;

public class SocketSelector
implements Closeable {
    private EventRunner eventRunner;
    protected Selector selector;
    protected ByteBuffer readTempBuffer;
    protected SimpleArraySet<SelectionKey> selectionKeys = new SimpleArraySet(1024);
    protected AtomicBoolean selecting = new AtomicBoolean(false);
    private boolean useSelectNow = false;
    int JvmEpollBugFlag = 0;
    static String BROKEN_PIPE = "Broken pipe";
    static String CONNECTION_RESET = "Connection reset by peer";

    public SocketSelector(final EventRunner eventRunner) throws IOException {
        this.selector = SelectorProvider.provider().openSelector();
        this.eventRunner = eventRunner;
        this.readTempBuffer = TByteBuffer.allocateDirect();
        try {
            TReflect.setFieldValue((Object)this.selector, NioUtil.selectedKeysField, this.selectionKeys);
            TReflect.setFieldValue((Object)this.selector, NioUtil.publicSelectedKeysField, this.selectionKeys);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        if (Global.IS_DEBUG_MODE.booleanValue()) {
            Global.getHashWheelTimer().addTask(new HashWheelTask(){

                @Override
                public void run() {
                    System.out.print(eventRunner.getThread().getName() + " " + SocketSelector.this.selector.keys().size() + " = " + eventRunner.getEventQueue().size());
                    int ioTaskCount = 0;
                    int eventTaskCount = 0;
                    int registerTaskCount = 0;
                    for (EventRunner.EventTask eventTask : eventRunner.getEventQueue()) {
                        if (eventTask.getPriority() == 4) {
                            ++ioTaskCount;
                        }
                        if (eventTask.getPriority() == 5) {
                            ++eventTaskCount;
                        }
                        if (eventTask.getPriority() != 6) continue;
                        ++registerTaskCount;
                    }
                    System.out.println(" (IO=" + ioTaskCount + ", Event=" + eventTaskCount + " ,register=" + registerTaskCount + ")");
                }
            }, 1);
        }
    }

    public EventRunner getEventRunner() {
        return this.eventRunner;
    }

    public boolean register(SocketContext socketContext, int ops) {
        if (ops == 0) {
            Object session = socketContext.getSession();
            ((IoSession)session).setSocketSelector(this);
        } else {
            this.addChooseEvent(6, () -> {
                try {
                    SelectionKey selectionKey = ((SelectableChannel)socketContext.socketChannel()).register(this.selector, ops, socketContext);
                    if (socketContext.connectModel != ConnectModel.LISTENER) {
                        Object session = socketContext.getSession();
                        ((IoSession)session).setSelectionKey(selectionKey);
                        ((IoSession)session).setSocketSelector(this);
                        if (!((IoSession)session).isSSLMode()) {
                            EventTrigger.fireConnect(session);
                        } else {
                            ((IoSession)session).getSSLParser().doHandShake();
                        }
                    }
                    socketContext.setRegister(true);
                    return true;
                }
                catch (ClosedChannelException e) {
                    Logger.error("Register " + socketContext + " to selector error");
                    return false;
                }
            });
            if (this.selecting.get()) {
                this.selector.wakeup();
            }
        }
        return true;
    }

    public void unRegister(SelectionKey selectionKey) {
        SocketContext socketContext;
        try {
            selectionKey.channel().close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (selectionKey.isValid()) {
            selectionKey.interestOps(0);
        }
        selectionKey.cancel();
        if (this.selecting.get()) {
            this.selector.wakeup();
        }
        if ((socketContext = (SocketContext)selectionKey.attachment()) != null && socketContext.isRegister() && selectionKey.channel().isRegistered()) {
            socketContext.setRegister(false);
            selectionKey.attach(null);
            ((IoSession)socketContext.getSession()).getReadByteBufferChannel().release();
            ((IoSession)socketContext.getSession()).getSendByteBufferChannel().release();
            if (((IoSession)socketContext.getSession()).isSSLMode()) {
                ((IoSession)socketContext.getSession()).getSSLParser().release();
            }
            EventTrigger.fireDisconnect(socketContext.getSession());
        }
    }

    private boolean inEventRunner() {
        return this.eventRunner.getThread() == Thread.currentThread();
    }

    public void addChooseEvent() {
        this.addChooseEvent(4, null);
    }

    public void addChooseEvent(int priority, Callable<Boolean> supplier) {
        if (this.selector.isOpen()) {
            this.eventRunner.addEvent(priority, () -> {
                boolean result = true;
                if (supplier != null) {
                    try {
                        result = (Boolean)supplier.call();
                    }
                    catch (Exception e) {
                        Logger.error("addChoseEvent error:", e);
                        result = false;
                    }
                }
                if (result) {
                    this.eventChoose();
                }
            });
        }
    }

    public void eventChoose() {
        try {
            if (this.selector != null && this.selector.isOpen() && this.selector.keys().size() > 0) {
                this.processSelect();
                if (!this.selectionKeys.isEmpty()) {
                    this.processSelectionKeys();
                    this.useSelectNow = true;
                } else {
                    this.useSelectNow = false;
                }
            }
        }
        catch (IOException e) {
            Logger.error("NioSelector error: ", e);
        }
        finally {
            if (this.inEventRunner() && !this.selector.keys().isEmpty()) {
                this.addChooseEvent();
            }
        }
    }

    private void processSelect() throws IOException {
        if (this.useSelectNow) {
            this.selector.selectNow();
        } else {
            long dealTime = TEnv.measureTime(() -> {
                try {
                    this.selecting.compareAndSet(false, true);
                    this.selector.select(1000L);
                    this.selecting.compareAndSet(true, false);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            int readyChannelCount = this.selectionKeys.size();
            this.JvmEpollBugFlag = readyChannelCount == 0 && (double)dealTime < 500000.0 ? ++this.JvmEpollBugFlag : 0;
            if (this.JvmEpollBugFlag >= 1024) {
                System.out.println(dealTime + " detect bug on " + Thread.currentThread().getName());
            }
        }
    }

    private void processSelectionKeys() throws IOException {
        for (int i = 0; i < this.selectionKeys.size(); ++i) {
            SelectionKey selectionKey = this.selectionKeys.getAndRemove(i);
            if (!selectionKey.isValid()) continue;
            SelectableChannel channel = selectionKey.channel();
            SocketContext socketContext = (SocketContext)selectionKey.attachment();
            if (!channel.isOpen() || !selectionKey.isValid()) continue;
            if ((selectionKey.readyOps() & 0x10) != 0) {
                SocketChannel socketChannel = ((ServerSocketChannel)channel).accept();
                this.tcpAccept((TcpServerSocket)socketContext, socketChannel);
            }
            if ((selectionKey.readyOps() & 1) == 0) continue;
            if (channel instanceof SocketChannel) {
                this.tcpReadFromChannel((TcpSocket)socketContext, (SocketChannel)channel);
            } else if (channel instanceof DatagramChannel) {
                this.udpReadFromChannel(socketContext, (DatagramChannel)channel);
            }
            socketContext.updateLastReadTime();
        }
        this.selectionKeys.reset();
    }

    @Override
    public void close() {
        try {
            TByteBuffer.release(this.readTempBuffer);
            this.selector.close();
        }
        catch (IOException e) {
            Logger.error("close selector error");
        }
    }

    public int readFromChannel(SocketContext socketContext, SelectableChannel selectableChannel) {
        if (selectableChannel instanceof SocketChannel) {
            return this.tcpReadFromChannel((TcpSocket)socketContext, (SocketChannel)selectableChannel);
        }
        if (selectableChannel instanceof DatagramChannel) {
            return this.udpReadFromChannel(socketContext, (DatagramChannel)selectableChannel);
        }
        return -1;
    }

    public int writeToChannel(SocketContext socketContext, ByteBuffer buffer) {
        if (socketContext instanceof TcpSocket) {
            return this.tcpWriteToChannel((TcpSocket)socketContext, buffer);
        }
        if (socketContext instanceof UdpSocket) {
            return this.udpWriteToChannel((UdpSocket)socketContext, buffer);
        }
        return -1;
    }

    public void tcpAccept(TcpServerSocket socketContext, SocketChannel socketChannel) {
        try {
            TcpSocket socket = new TcpSocket(socketContext, socketChannel);
            EventTrigger.fireAccept(socket.getSession());
        }
        catch (Exception e) {
            this.dealException(socketContext, e);
        }
    }

    public int tcpReadFromChannel(TcpSocket socketContext, SocketChannel socketChannel) {
        try {
            int readSize = socketChannel.read(this.readTempBuffer);
            readSize = this.loadAndPrepare(socketContext.getSession(), readSize);
            return readSize;
        }
        catch (Exception e) {
            return this.dealException(socketContext, e);
        }
    }

    public int tcpWriteToChannel(TcpSocket socketContext, ByteBuffer buffer) {
        try {
            int totalSendByte = 0;
            long start = System.currentTimeMillis();
            if (socketContext.isConnected() && buffer != null) {
                while (socketContext.isConnected() && buffer.remaining() != 0) {
                    int sendSize = socketContext.socketChannel().write(buffer);
                    if (sendSize == 0) {
                        if (System.currentTimeMillis() - start < (long)socketContext.getSendTimeout()) continue;
                        Logger.error("SocketSelector tcpWriteToChannel timeout", new TimeoutException());
                        socketContext.close();
                        return -1;
                    }
                    start = System.currentTimeMillis();
                    totalSendByte += sendSize;
                }
            }
            return totalSendByte;
        }
        catch (Exception e) {
            return this.dealException(socketContext, e);
        }
    }

    public UdpSocket udpAccept(UdpServerSocket socketContext, DatagramChannel datagramChannel, SocketAddress address) throws IOException {
        UdpSocket udpSocket = new UdpSocket(socketContext, datagramChannel, (InetSocketAddress)address);
        udpSocket.acceptStart();
        return udpSocket;
    }

    public int udpReadFromChannel(SocketContext<DatagramChannel, UdpSession> socketContext, DatagramChannel datagramChannel) {
        try {
            int readSize = -1;
            if (datagramChannel.isConnected()) {
                readSize = datagramChannel.read(this.readTempBuffer);
            } else {
                socketContext = this.udpAccept((UdpServerSocket)((Object)socketContext), datagramChannel, datagramChannel.receive(this.readTempBuffer));
                UdpSession session = (UdpSession)socketContext.getSession();
                readSize = this.readTempBuffer.position();
            }
            readSize = this.loadAndPrepare(socketContext.getSession(), readSize);
            return readSize;
        }
        catch (Exception e) {
            return this.dealException(socketContext, e);
        }
    }

    public int udpWriteToChannel(UdpSocket socketContext, ByteBuffer buffer) {
        try {
            DatagramChannel datagramChannel = socketContext.socketChannel();
            UdpSession session = socketContext.getSession();
            int totalSendByte = 0;
            long start = System.currentTimeMillis();
            if (socketContext.isOpen() && buffer != null) {
                while (buffer.remaining() != 0) {
                    int sendSize = 0;
                    sendSize = datagramChannel.isConnected() ? datagramChannel.write(buffer) : datagramChannel.send(buffer, session.getInetSocketAddress());
                    if (sendSize == 0) {
                        TEnv.sleep(1);
                        if (System.currentTimeMillis() - start < (long)socketContext.getSendTimeout()) continue;
                        Logger.error("SocketSelector udpWriteToChannel timeout, Socket will be close");
                        socketContext.close();
                        return -1;
                    }
                    start = System.currentTimeMillis();
                    totalSendByte += sendSize;
                }
            }
            return totalSendByte;
        }
        catch (Exception e) {
            return this.dealException(socketContext, e);
        }
    }

    public int loadAndPrepare(IoSession session, int readSize) throws IOException {
        ByteBufferChannel appByteBufferChannel = session.getReadByteBufferChannel();
        if (MessageLoader.isStreamEnd(this.readTempBuffer, readSize) || !session.isConnected()) {
            session.getMessageLoader().setStopType(MessageLoader.StopType.STREAM_END);
            session.close();
            return -1;
        }
        this.readTempBuffer.flip();
        if (readSize > 0) {
            try {
                TEnv.wait(((SocketContext)session.socketContext()).getReadTimeout(), () -> appByteBufferChannel.size() + this.readTempBuffer.limit() >= appByteBufferChannel.getMaxSize());
            }
            catch (TimeoutException e) {
                Logger.error("Session.readByteByteBuffer is not enough avaliable space:", e);
            }
            if (!SSLParser.isHandShakeDone(session)) {
                session.getSSLParser().getSSlByteBufferChannel().writeEnd(this.readTempBuffer);
                session.getSSLParser().doHandShake();
            } else {
                if (session.isSSLMode()) {
                    session.getSSLParser().unWarpByteBufferChannel(this.readTempBuffer);
                } else {
                    appByteBufferChannel.writeEnd(this.readTempBuffer);
                }
                if (session.getHeartBeat() != null) {
                    HeartBeat.interceptHeartBeat(session, appByteBufferChannel);
                }
                if (session.isConnected() && !session.getState().isReceive() && appByteBufferChannel.size() > 0) {
                    EventTrigger.fireReceiveAsEvent(session);
                }
            }
            this.readTempBuffer.clear();
        }
        return readSize;
    }

    public int dealException(SocketContext socketContext, Exception e) {
        if (BROKEN_PIPE.equals(e.getMessage()) || CONNECTION_RESET.equals(e.getMessage())) {
            socketContext.close();
            return -1;
        }
        if (e.getStackTrace()[0].getClassName().contains("sun.tcp.ch")) {
            return -1;
        }
        if (e instanceof Exception) {
            try {
                EventTrigger.fireException(socketContext.getSession(), e);
            }
            catch (Exception ex) {
                e.printStackTrace();
            }
        }
        return -1;
    }
}

