/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.network;

import java.io.IOException;
import java.net.SocketOption;
import java.nio.channels.SelectableChannel;
import javax.net.ssl.SSLException;
import org.voovan.network.ConnectModel;
import org.voovan.network.EventRunner;
import org.voovan.network.EventRunnerGroup;
import org.voovan.network.IoFilter;
import org.voovan.network.IoHandler;
import org.voovan.network.IoSession;
import org.voovan.network.MessageSplitter;
import org.voovan.network.SSLManager;
import org.voovan.network.SocketSelector;
import org.voovan.network.handler.SynchronousHandler;
import org.voovan.network.messagesplitter.TransferSplitter;
import org.voovan.tools.TEnv;
import org.voovan.tools.buffer.TByteBuffer;
import org.voovan.tools.collection.Chain;
import org.voovan.tools.log.Logger;

public abstract class SocketContext<C extends SelectableChannel, S extends IoSession> {
    protected String host;
    protected int port;
    protected int readTimeout;
    protected int sendTimeout = 1000;
    protected IoHandler handler;
    protected Chain<IoFilter> filterChain;
    protected MessageSplitter messageSplitter;
    protected SSLManager sslManager;
    protected ConnectModel connectModel;
    protected int readBufferSize = TByteBuffer.DEFAULT_BYTE_BUFFER_SIZE;
    protected int sendBufferSize = TByteBuffer.DEFAULT_BYTE_BUFFER_SIZE;
    protected int idleInterval = 0;
    protected long lastReadTime = System.currentTimeMillis();
    protected int readRecursionDepth = 1;
    private boolean isRegister = false;
    protected boolean isSynchronous = true;

    public SocketContext(String host, int port, int readTimeout) {
        this.init(host, port, readTimeout, this.sendTimeout, this.idleInterval);
    }

    public SocketContext(String host, int port, int readTimeout, int idleInterval) {
        this.init(host, port, readTimeout, this.sendTimeout, idleInterval);
    }

    public SocketContext(String host, int port, int readTimeout, int sendTimeout, int idleInterval) {
        this.init(host, port, readTimeout, sendTimeout, idleInterval);
    }

    private void init(String host, int port, int readTimeout, int sendTimeout, int idleInterval) {
        this.host = host;
        this.port = port;
        this.readTimeout = readTimeout;
        this.sendTimeout = sendTimeout;
        this.idleInterval = idleInterval;
        this.connectModel = null;
        this.filterChain = new Chain();
        this.messageSplitter = new TransferSplitter();
        this.handler = new SynchronousHandler();
    }

    protected void initSSL(IoSession session) throws SSLException {
        if (this.sslManager != null && this.connectModel == ConnectModel.SERVER) {
            this.sslManager.createServerSSLParser(session);
        } else if (this.sslManager != null && this.connectModel == ConnectModel.CLIENT) {
            this.sslManager.createClientSSLParser(session);
        }
    }

    protected void copyFrom(SocketContext parentSocketContext) {
        this.readTimeout = parentSocketContext.readTimeout;
        this.sendTimeout = parentSocketContext.sendTimeout;
        this.handler = parentSocketContext.handler;
        this.filterChain = parentSocketContext.filterChain;
        this.messageSplitter = parentSocketContext.messageSplitter;
        this.sslManager = parentSocketContext.sslManager;
        this.readBufferSize = parentSocketContext.readBufferSize;
        this.sendBufferSize = parentSocketContext.sendBufferSize;
        this.idleInterval = parentSocketContext.idleInterval;
        this.readRecursionDepth = parentSocketContext.readRecursionDepth;
    }

    public int getIdleInterval() {
        return this.idleInterval;
    }

    public abstract void setIdleInterval(int var1);

    public abstract <T> void setOption(SocketOption<T> var1, T var2) throws IOException;

    public abstract C socketChannel();

    public long getLastReadTime() {
        return this.lastReadTime;
    }

    public void updateLastReadTime() {
        this.lastReadTime = System.currentTimeMillis();
    }

    public boolean isReadTimeOut() {
        return System.currentTimeMillis() - this.lastReadTime >= (long)this.readTimeout;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public void setReadBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public int getReadRecursionDepth() {
        return this.readRecursionDepth;
    }

    public void setReadRecursionDepth(int readRecursionDepth) {
        this.readRecursionDepth = readRecursionDepth;
    }

    public boolean isRegister() {
        return this.isRegister;
    }

    protected void setRegister(boolean register) {
        this.isRegister = register;
    }

    protected SocketContext() {
        this.filterChain = new Chain();
    }

    public SSLManager getSSLManager() {
        return this.sslManager;
    }

    public void setSSLManager(SSLManager sslManager) {
        if (this.sslManager == null) {
            this.sslManager = sslManager;
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getSendTimeout() {
        return this.sendTimeout;
    }

    public ConnectModel getConnectModel() {
        return this.connectModel;
    }

    public IoHandler handler() {
        return this.handler;
    }

    public void handler(IoHandler handler) {
        this.handler = handler;
        this.isSynchronous = false;
    }

    public Chain<IoFilter> filterChain() {
        return this.filterChain;
    }

    public MessageSplitter messageSplitter() {
        return this.messageSplitter;
    }

    public void messageSplitter(MessageSplitter messageSplitter) {
        this.messageSplitter = messageSplitter;
    }

    public abstract S getSession();

    public abstract void start() throws IOException;

    public abstract void syncStart() throws IOException;

    protected abstract void acceptStart() throws IOException;

    public abstract boolean isOpen();

    public abstract boolean isConnected();

    public abstract boolean close();

    public void waitConnect() {
        try {
            TEnv.wait(this.readTimeout, () -> !this.isRegister);
            if (((IoSession)this.getSession()).isSSLMode()) {
                ((IoSession)this.getSession()).getSSLParser().waitHandShakeDone();
            }
        }
        catch (Exception e) {
            Logger.error(e);
            this.close();
        }
    }

    public void bindToSocketSelector(int ops) {
        EventRunner eventRunner = null;
        eventRunner = this.connectModel == ConnectModel.LISTENER ? EventRunnerGroup.ACCEPT_EVENT_RUNNER_GROUP.choseEventRunner() : EventRunnerGroup.IO_EVENT_RUNNER_GROUP.choseEventRunner();
        SocketSelector socketSelector = (SocketSelector)eventRunner.attachment();
        socketSelector.register(this, ops);
    }
}

