/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import org.voovan.network.EventTrigger;
import org.voovan.network.IoSession;
import org.voovan.network.SocketContext;
import org.voovan.tools.TEnv;
import org.voovan.tools.buffer.ByteBufferChannel;
import org.voovan.tools.buffer.TByteBuffer;
import org.voovan.tools.exception.MemoryReleasedException;
import org.voovan.tools.log.Logger;

public class SSLParser {
    private SSLEngine engine;
    private ByteBuffer appData;
    private ByteBuffer netData;
    private IoSession session;
    boolean handShakeDone = false;
    private ByteBufferChannel sslByteBufferChannel;

    public SSLParser(SSLEngine engine, IoSession session) {
        this.engine = engine;
        this.session = session;
        this.appData = this.buildAppDataBuffer();
        this.netData = this.buildNetDataBuffer();
        this.sslByteBufferChannel = new ByteBufferChannel(((SocketContext)session.socketContext()).getReadBufferSize());
    }

    public ByteBufferChannel getSSlByteBufferChannel() {
        return this.sslByteBufferChannel;
    }

    public boolean isHandShakeDone() {
        return this.handShakeDone;
    }

    public SSLEngine getSSLEngine() {
        return this.engine;
    }

    public ByteBuffer buildNetDataBuffer() {
        SSLSession sslSession = this.engine.getSession();
        int newBufferMax = sslSession.getPacketBufferSize();
        return TByteBuffer.allocateDirect(newBufferMax);
    }

    public ByteBuffer buildAppDataBuffer() {
        SSLSession sslSession = this.engine.getSession();
        int newBufferMax = sslSession.getPacketBufferSize();
        return TByteBuffer.allocateDirect(newBufferMax);
    }

    private void clearBuffer() {
        this.appData.clear();
        this.netData.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SSLEngineResult warpData(ByteBuffer buffer) throws IOException {
        if (this.session.isConnected()) {
            SSLEngineResult engineResult = null;
            do {
                ByteBuffer byteBuffer = this.netData;
                synchronized (byteBuffer) {
                    if (!TByteBuffer.isReleased(this.netData)) {
                        this.netData.clear();
                        engineResult = this.engine.wrap(buffer, this.netData);
                        this.netData.flip();
                        if (this.session.isConnected() && engineResult.bytesProduced() > 0 && this.netData.limit() > 0) {
                            this.session.send0(this.netData);
                        }
                    } else {
                        return null;
                    }
                    this.netData.clear();
                }
            } while (engineResult.getStatus() == SSLEngineResult.Status.OK && buffer.hasRemaining());
            return engineResult;
        }
        return null;
    }

    private synchronized SSLEngineResult.HandshakeStatus doHandShakeWarp() throws IOException {
        if (!this.session.isConnected()) {
            return null;
        }
        try {
            this.clearBuffer();
            this.appData.flip();
            if (this.warpData(this.appData) == null) {
                return null;
            }
            SSLEngineResult.HandshakeStatus handshakeStatus = this.runDelegatedTasks();
            return handshakeStatus;
        }
        catch (SSLException e) {
            Logger.error("HandShakeWarp error:", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SSLEngineResult unwarpData(ByteBuffer netBuffer, ByteBuffer appBuffer) throws SSLException {
        if (this.session.isConnected()) {
            SSLEngineResult engineResult = null;
            ByteBuffer byteBuffer = appBuffer;
            synchronized (byteBuffer) {
                if (TByteBuffer.isReleased(appBuffer)) {
                    return null;
                }
                engineResult = this.engine.unwrap(netBuffer, appBuffer);
            }
            return engineResult;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized SSLEngineResult.HandshakeStatus doHandShakeUnwarp() throws IOException {
        SSLEngineResult.HandshakeStatus handshakeStatus = null;
        SSLEngineResult engineResult = null;
        this.clearBuffer();
        if (this.sslByteBufferChannel.isReleased()) {
            throw new IOException("Socket is disconnect");
        }
        if (this.sslByteBufferChannel.size() > 0) {
            try {
                ByteBuffer byteBuffer = this.sslByteBufferChannel.getByteBuffer();
                engineResult = this.unwarpData(byteBuffer, this.appData);
                if (engineResult == null) {
                    SSLEngineResult.HandshakeStatus handshakeStatus2 = null;
                    return handshakeStatus2;
                }
                switch (engineResult.getStatus()) {
                    case OK: {
                        SSLEngineResult.HandshakeStatus handshakeStatus3 = this.engine.getHandshakeStatus();
                        return handshakeStatus3;
                    }
                }
                Logger.error(new SSLHandshakeException("Handshake failed: " + (Object)((Object)engineResult.getStatus())));
                this.session.close();
            }
            finally {
                this.sslByteBufferChannel.compact();
            }
        }
        return handshakeStatus == null ? this.engine.getHandshakeStatus() : handshakeStatus;
    }

    private synchronized SSLEngineResult.HandshakeStatus runDelegatedTasks() {
        if (!this.handShakeDone) {
            if (this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                Runnable runnable;
                while ((runnable = this.engine.getDelegatedTask()) != null) {
                    runnable.run();
                }
            }
            return this.engine.getHandshakeStatus();
        }
        return null;
    }

    public synchronized boolean doHandShake() {
        try {
            this.engine.beginHandshake();
            SSLEngineResult.HandshakeStatus handshakeStatus = this.engine.getHandshakeStatus();
            block9: for (int handShakeCount = 0; !this.handShakeDone && handShakeCount < 20; ++handShakeCount) {
                if (handshakeStatus == null) {
                    throw new SSLException("doHandShake: Socket is disconnect");
                }
                switch (handshakeStatus) {
                    case NEED_TASK: {
                        handshakeStatus = this.runDelegatedTasks();
                        continue block9;
                    }
                    case NEED_WRAP: {
                        handshakeStatus = this.doHandShakeWarp();
                        continue block9;
                    }
                    case NEED_UNWRAP: {
                        if (this.isEnoughToUnwarp()) {
                            handshakeStatus = this.doHandShakeUnwarp();
                            continue block9;
                        }
                        return false;
                    }
                    case FINISHED: {
                        handshakeStatus = this.engine.getHandshakeStatus();
                        continue block9;
                    }
                    case NOT_HANDSHAKING: {
                        this.handShakeDone = true;
                        EventTrigger.fireConnect(this.session);
                        continue block9;
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.error("SSLParser.doHandShake error:", e);
        }
        return this.handShakeDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int unWarpByteBufferChannel(ByteBuffer readByteBuffer) throws IOException {
        int readSize;
        block10: {
            ByteBufferChannel appByteBufferChannel = this.session.getReadByteBufferChannel();
            this.sslByteBufferChannel.writeEnd(readByteBuffer);
            if (!this.isEnoughToUnwarp()) {
                return 0;
            }
            readSize = 0;
            if (this.session.isConnected() && this.sslByteBufferChannel.size() > 0) {
                SSLEngineResult engineResult = null;
                try {
                    ByteBuffer byteBuffer;
                    do {
                        this.appData.clear();
                        byteBuffer = null;
                        try {
                            byteBuffer = this.sslByteBufferChannel.getByteBuffer();
                            engineResult = this.unwarpData(byteBuffer, this.appData);
                        }
                        finally {
                            this.sslByteBufferChannel.compact();
                        }
                        if (engineResult == null) {
                            throw new SSLException("unWarpByteBufferChannel: Socket is disconnect");
                        }
                        this.appData.flip();
                        appByteBufferChannel.writeEnd(this.appData);
                    } while ((engineResult == null || engineResult.getStatus() != SSLEngineResult.Status.OK || byteBuffer.remaining() != 0) && (engineResult == null || engineResult.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW && engineResult.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW && engineResult.getStatus() != SSLEngineResult.Status.CLOSED));
                }
                catch (MemoryReleasedException e) {
                    if (this.session.isConnected()) break block10;
                    throw new SSLException("unWarpByteBufferChannel ", e);
                }
            }
        }
        return readSize;
    }

    public void release() {
        TByteBuffer.release(this.netData);
        TByteBuffer.release(this.appData);
        this.sslByteBufferChannel.release();
    }

    public static boolean isHandShakeDone(IoSession session) {
        if (session == null || !session.isSSLMode()) {
            return true;
        }
        return session.getSSLParser().isHandShakeDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEnoughToUnwarp() throws SSLException {
        ByteBuffer src = this.sslByteBufferChannel.getByteBuffer();
        try {
            if (src.remaining() < 5) {
                boolean bl = false;
                return bl;
            }
            int pos = src.position();
            int type = src.get(pos) & 0xFF;
            if (type < 20 || type > 23) {
                throw new SSLException("Not SSL package");
            }
            int majorVersion = src.get(pos + 1) & 0xFF;
            int minorVersion = src.get(pos + 2) & 0xFF;
            int packetLength = src.getShort(pos + 3) & 0xFFFF;
            if (majorVersion != 3 || minorVersion < 1) {
                throw new SSLException("Not TLS protocol");
            }
            int len = packetLength + 5;
            if (src.remaining() < len) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.sslByteBufferChannel.compact();
        }
    }

    public void waitHandShakeDone() {
        try {
            TEnv.wait(((SocketContext)this.session.socketContext()).getReadTimeout(), () -> {
                if (this.session.isSSLMode() && this.session.getSSLParser().isHandShakeDone()) {
                    return false;
                }
                if (!this.session.isConnected()) {
                    Logger.error("Socket is disconnected");
                    return false;
                }
                return true;
            });
        }
        catch (Exception e) {
            Logger.error(e);
            this.session.close();
        }
    }
}

