/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.network;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.voovan.network.IoSession;
import org.voovan.network.SSLParser;
import org.voovan.network.SocketContext;
import org.voovan.tools.TString;

public class SSLManager {
    private KeyManagerFactory keyManagerFactory;
    private TrustManagerFactory trustManagerFactory;
    private SSLContext context;
    private boolean needClientAuth;
    private String protocol;

    public SSLManager(String protocol) throws NoSuchAlgorithmException {
        this.needClientAuth = true;
        this.protocol = protocol;
    }

    public SSLManager(String protocol, boolean useClientAuth) throws SSLException {
        this.needClientAuth = useClientAuth;
        this.protocol = protocol;
    }

    public void loadCertificate(String manageCertFile, String certPassword, String keyPassword) throws SSLException {
        FileInputStream certFIS = null;
        try {
            this.keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            this.trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            certFIS = new FileInputStream(manageCertFile);
            keystore.load(certFIS, certPassword.toCharArray());
            this.keyManagerFactory.init(keystore, keyPassword.toCharArray());
            this.trustManagerFactory.init(keystore);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new SSLException("Init SSLContext Error: " + e.getMessage(), e);
        }
        finally {
            if (certFIS != null) {
                try {
                    certFIS.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void loadCertificate(byte[] manageCert, String certPassword, String keyPassword) throws SSLException {
        FileInputStream certFIS = null;
        try {
            this.keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            this.trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(new ByteArrayInputStream(manageCert), certPassword.toCharArray());
            this.keyManagerFactory.init(keystore, keyPassword.toCharArray());
            this.trustManagerFactory.init(keystore);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new SSLException("Init SSLContext Error: " + e.getMessage(), e);
        }
        finally {
            if (certFIS != null) {
                try {
                    certFIS.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private synchronized void init(String protocol) throws SSLException {
        if (TString.isNullOrEmpty(protocol)) {
            this.protocol = "SSL";
        }
        try {
            this.context = SSLContext.getInstance(protocol, "SunJSSE");
            if (this.keyManagerFactory != null && this.trustManagerFactory != null) {
                this.context.init(this.keyManagerFactory.getKeyManagers(), this.trustManagerFactory.getTrustManagers(), new SecureRandom());
            } else {
                this.context.init(null, new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
            }
        }
        catch (Exception e) {
            throw new SSLException("Init SSLContext Error: " + e.getMessage(), e);
        }
    }

    private synchronized SSLEngine createSSLEngine(String protocol, String ipAddress, int port) throws SSLException {
        this.init(protocol);
        return this.context.createSSLEngine(ipAddress, port);
    }

    public synchronized SSLParser createClientSSLParser(IoSession session) throws SSLException {
        SSLEngine engine = this.createSSLEngine(this.protocol, ((SocketContext)session.socketContext()).getHost(), ((SocketContext)session.socketContext()).getPort());
        engine.setUseClientMode(true);
        SSLParser sslParser = new SSLParser(engine, session);
        session.setSSLParser(sslParser);
        return sslParser;
    }

    public synchronized SSLParser createServerSSLParser(IoSession session) throws SSLException {
        SSLEngine engine = this.createSSLEngine(this.protocol, ((SocketContext)session.socketContext()).getHost(), ((SocketContext)session.socketContext()).getPort());
        engine.setUseClientMode(false);
        engine.setNeedClientAuth(this.needClientAuth);
        SSLParser sslParser = new SSLParser(engine, session);
        session.setSSLParser(sslParser);
        return sslParser;
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

