/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.network;

import java.nio.ByteBuffer;
import org.voovan.network.IoSession;
import org.voovan.network.MessageSplitter;
import org.voovan.network.SocketContext;
import org.voovan.network.messagesplitter.TransferSplitter;
import org.voovan.network.udp.UdpSocket;
import org.voovan.tools.buffer.ByteBufferChannel;
import org.voovan.tools.buffer.TByteBuffer;
import org.voovan.tools.exception.MemoryReleasedException;
import org.voovan.tools.log.Logger;

public class MessageLoader {
    private IoSession session;
    private StopType stopType;
    private ByteBufferChannel byteBufferChannel;
    private boolean enable;

    public MessageLoader(IoSession session) {
        this.session = session;
        this.enable = true;
        this.byteBufferChannel = session.getReadByteBufferChannel();
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void enable(boolean enable) {
        this.enable = enable;
    }

    public StopType getStopType() {
        return this.stopType;
    }

    public void setStopType(StopType stopType) {
        this.stopType = stopType;
    }

    public static boolean isStreamEnd(ByteBuffer buffer, int length) {
        return length == -1;
    }

    public static boolean isStreamEnd(byte[] buffer, int length) {
        return length == -1;
    }

    public void close() {
        this.stopType = StopType.SOCKET_CLOSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() {
        int readZeroCount = 0;
        int splitLength = 0;
        ByteBuffer result = TByteBuffer.EMPTY_BYTE_BUFFER;
        int oldByteChannelSize = 0;
        ByteBufferChannel dataByteBufferChannel = null;
        ByteBuffer dataByteBuffer = null;
        dataByteBufferChannel = this.session.getReadByteBufferChannel();
        this.stopType = StopType.RUNNING;
        if (this.session == null) {
            return -1;
        }
        MessageSplitter messageSplitter = ((SocketContext)this.session.socketContext()).messageSplitter();
        if (messageSplitter == null) {
            Logger.error("[Error] MessageSplitter is null, you need to invoke SocketContext object's messageSplitter method to set MessageSplitter Object in it.");
            return -1;
        }
        boolean isConnect = true;
        while (isConnect && this.enable && this.stopType == StopType.RUNNING && dataByteBufferChannel.size() > 0) {
            isConnect = this.session.socketContext() instanceof UdpSocket ? this.session.isOpen() : this.session.isConnected();
            if (!isConnect) {
                this.stopType = StopType.SOCKET_CLOSED;
                return -1;
            }
            int readsize = this.byteBufferChannel.size() - oldByteChannelSize;
            try {
                dataByteBuffer = dataByteBufferChannel.getByteBuffer();
                try {
                    if (MessageLoader.isStreamEnd(dataByteBuffer, dataByteBufferChannel.size())) {
                        this.stopType = StopType.STREAM_END;
                    }
                    if (readsize == 0 && dataByteBuffer.limit() > 0 && (splitLength = messageSplitter instanceof TransferSplitter ? dataByteBuffer.limit() : messageSplitter.canSplite(this.session, dataByteBuffer)) >= 0) {
                        this.stopType = StopType.MSG_SPLITTER;
                        break;
                    }
                }
                finally {
                    dataByteBufferChannel.compact();
                }
            }
            catch (MemoryReleasedException e) {
                this.stopType = StopType.SOCKET_CLOSED;
            }
            if (readsize == 0 && this.stopType == StopType.RUNNING) {
                if (((SocketContext)this.session.socketContext()).isReadTimeOut()) {
                    this.stopType = StopType.STREAM_END;
                } else {
                    ++readZeroCount;
                }
            } else {
                readZeroCount = 0;
            }
            oldByteChannelSize = this.byteBufferChannel.size();
        }
        if (this.stopType == StopType.STREAM_END || this.stopType == StopType.SOCKET_CLOSED) {
            return -1;
        }
        if (this.stopType == StopType.MSG_SPLITTER) {
            if (splitLength >= 0) {
                return splitLength;
            }
            return -1;
        }
        return -1;
    }

    public static enum StopType {
        RUNNING,
        SOCKET_CLOSED,
        STREAM_END,
        MSG_SPLITTER,
        EXCEPTION;

    }
}

