/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.voovan.Global;
import org.voovan.network.EventProcess;
import org.voovan.network.EventRunner;
import org.voovan.network.EventTrigger;
import org.voovan.network.HeartBeat;
import org.voovan.network.MessageLoader;
import org.voovan.network.MessageSplitter;
import org.voovan.network.SSLParser;
import org.voovan.network.SocketContext;
import org.voovan.network.SocketSelector;
import org.voovan.network.exception.ReadMessageException;
import org.voovan.network.exception.SendMessageException;
import org.voovan.network.handler.SynchronousHandler;
import org.voovan.tools.TEnv;
import org.voovan.tools.buffer.ByteBufferChannel;
import org.voovan.tools.hashwheeltimer.HashWheelTask;
import org.voovan.tools.log.Logger;

public abstract class IoSession<T extends SocketContext> {
    private Map<Object, Object> attributes = new ConcurrentHashMap<Object, Object>();
    private boolean sslMode = false;
    private SSLParser sslParser;
    private MessageLoader messageLoader;
    protected ByteBufferChannel readByteBufferChannel;
    protected ByteBufferChannel sendByteBufferChannel;
    private T socketContext;
    private long lastIdleTime = -1L;
    private HashWheelTask checkIdleTask;
    private HeartBeat heartBeat;
    private State state;
    private SelectionKey selectionKey;
    private SocketSelector socketSelector;

    public IoSession(T socketContext) {
        this.socketContext = socketContext;
        this.state = new State();
        this.readByteBufferChannel = new ByteBufferChannel(((SocketContext)socketContext).getReadBufferSize());
        this.sendByteBufferChannel = new ByteBufferChannel(((SocketContext)socketContext).getSendBufferSize());
        this.messageLoader = new MessageLoader(this);
        this.checkIdle();
    }

    public SocketSelector getSocketSelector() {
        return this.socketSelector;
    }

    protected void setSocketSelector(SocketSelector socketSelector) {
        this.socketSelector = socketSelector;
    }

    protected EventRunner getEventRunner() {
        return this.socketSelector.getEventRunner();
    }

    protected SelectionKey getSelectionKey() {
        return this.selectionKey;
    }

    void setSelectionKey(SelectionKey selectionKey) {
        this.selectionKey = selectionKey;
    }

    public HeartBeat getHeartBeat() {
        return this.heartBeat;
    }

    void setHeartBeat(HeartBeat heartBeat) {
        this.heartBeat = heartBeat;
    }

    public State getState() {
        return this.state;
    }

    public void checkIdle() {
        if (((SocketContext)this.socketContext).getIdleInterval() > 0 && this.checkIdleTask == null) {
            final IoSession session = this;
            this.checkIdleTask = new HashWheelTask(){

                @Override
                public void run() {
                    long timeDiff = System.currentTimeMillis() - IoSession.this.lastIdleTime;
                    if (timeDiff >= (long)(IoSession.this.socketContext.getIdleInterval() * 1000)) {
                        boolean isConnect = false;
                        if (session.state.isInit() || session.state.isConnect()) {
                            return;
                        }
                        if (session.state.isClose()) {
                            session.cancelIdle();
                            return;
                        }
                        isConnect = session.isConnected();
                        if (!isConnect) {
                            session.cancelIdle();
                            this.cancel();
                            return;
                        }
                        if (IoSession.this.socketContext.getIdleInterval() < 1) {
                            return;
                        }
                        EventTrigger.fireIdle(session);
                        IoSession.this.lastIdleTime = System.currentTimeMillis();
                    }
                }
            };
            this.checkIdleTask.run();
            Global.getHashWheelTimer().addTask(this.checkIdleTask, 1);
        }
    }

    public void cancelIdle() {
        if (this.checkIdleTask != null) {
            this.checkIdleTask.cancel();
            this.checkIdleTask = null;
            if (this.heartBeat != null) {
                this.heartBeat = null;
            }
        }
    }

    public int getIdleInterval() {
        return ((SocketContext)this.socketContext).getIdleInterval();
    }

    public void setIdleInterval(int idleInterval) {
        ((SocketContext)this.socketContext).setIdleInterval(idleInterval);
    }

    public ByteBufferChannel getReadByteBufferChannel() {
        return this.readByteBufferChannel;
    }

    public ByteBufferChannel getSendByteBufferChannel() {
        return this.sendByteBufferChannel;
    }

    public SSLParser getSSLParser() {
        return this.sslParser;
    }

    protected void setSSLParser(SSLParser sslParser) {
        if (this.sslParser == null && sslParser != null) {
            this.sslParser = sslParser;
            this.sslMode = true;
        }
    }

    public boolean isSSLMode() {
        return this.sslMode;
    }

    public Map<Object, Object> getAttributes() {
        return this.attributes;
    }

    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    public void setAttribute(Object key, Object value) {
        this.attributes.put(key, value);
    }

    public void removeAttribute(Object key) {
        this.attributes.remove(key);
    }

    public boolean containAttribute(Object key) {
        return this.attributes.containsKey(key);
    }

    public abstract String localAddress();

    public abstract int loaclPort();

    public abstract String remoteAddress();

    public abstract int remotePort();

    public T socketContext() {
        return this.socketContext;
    }

    protected int read0() throws IOException {
        return this.socketSelector.readFromChannel((SocketContext)this.socketContext, (SelectableChannel)((SocketContext)this.socketContext).socketChannel());
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        int readSize = -1;
        if (byteBuffer != null && !this.getReadByteBufferChannel().isReleased()) {
            readSize = this.getReadByteBufferChannel().readHead(byteBuffer);
        }
        if (!this.isConnected() && readSize <= 0) {
            readSize = -1;
        }
        return readSize;
    }

    public Object syncRead() throws ReadMessageException {
        Object readObject;
        block7: {
            readObject = null;
            SynchronousHandler synchronousHandler = null;
            boolean waitedTime = false;
            if (!(((SocketContext)this.socketContext).handler() instanceof SynchronousHandler)) {
                throw new ReadMessageException("Use the syncRead method must set an object of SynchronousHandler into the socket handler ");
            }
            synchronousHandler = (SynchronousHandler)((SocketContext)this.socketContext).handler();
            try {
                SynchronousHandler finalSynchronousHandler = synchronousHandler;
                TEnv.wait(((SocketContext)this.socketContext).getReadTimeout(), () -> !finalSynchronousHandler.hasNextResponse() && this.isConnected());
                if (this.isConnected()) {
                    readObject = ((SynchronousHandler)((SocketContext)this.socketContext).handler()).getResponse();
                }
                if (readObject == null && !this.isConnected()) {
                    throw new ReadMessageException("Method syncRead error! Socket is disconnected");
                }
                if (readObject instanceof Throwable) {
                    Exception exception = (Exception)readObject;
                    if (exception != null) {
                        this.removeAttribute("SocketException");
                        throw new ReadMessageException("Method syncRead error! Error by " + exception.getClass().getSimpleName() + ". " + exception.getMessage(), exception);
                    }
                    break block7;
                }
                return readObject;
            }
            catch (TimeoutException e) {
                throw new ReadMessageException("syncRead readFromChannel timeout or socket is disconnect");
            }
        }
        return readObject;
    }

    protected int send0(ByteBuffer buffer) throws IOException {
        return this.socketSelector.writeToChannel((SocketContext)this.socketContext, buffer);
    }

    public int sendByBuffer(ByteBuffer buffer) {
        try {
            return this.sendByteBufferChannel.writeEnd(buffer);
        }
        catch (Exception e) {
            if (((SocketContext)this.socketContext).isConnected()) {
                Logger.error("IoSession.sendByBuffer buffer failed", e);
            }
            return -1;
        }
    }

    public void syncSend(Object obj) throws SendMessageException {
        block4: {
            try {
                TEnv.wait(((SocketContext)this.socketContext).getSendTimeout(), () -> this.sslParser != null && !this.sslParser.handShakeDone);
                if (obj == null) break block4;
                try {
                    EventProcess.sendMessage(this, obj);
                    this.flush();
                }
                catch (Exception e) {
                    throw new SendMessageException("Method syncSend error! Error by " + e.getClass().getSimpleName() + ".", e);
                }
            }
            catch (TimeoutException e) {
                throw new SendMessageException("Method syncSend error! Error by " + e.getClass().getSimpleName() + ".", e);
            }
        }
    }

    public int send(ByteBuffer buffer) {
        try {
            if (this.sslParser != null && this.sslParser.isHandShakeDone()) {
                this.sslParser.warpData(buffer);
                return buffer.limit();
            }
            if (buffer.limit() + this.sendByteBufferChannel.size() > this.sendByteBufferChannel.getMaxSize()) {
                this.flush();
            }
            return this.sendByBuffer(buffer);
        }
        catch (IOException e) {
            Logger.error("IoSession.writeToChannel data failed", e);
            return -1;
        }
    }

    public void flush() {
        if (this.sendByteBufferChannel.size() > 0) {
            try {
                this.send0(this.sendByteBufferChannel.getByteBuffer());
                EventTrigger.fireFlush(this);
            }
            catch (IOException e) {
                if (this.isConnected() && ((SocketContext)this.socketContext).isConnected()) {
                    Logger.error("IoSession.flush buffer failed", e);
                }
            }
            finally {
                this.sendByteBufferChannel.compact();
            }
        }
    }

    public MessageLoader getMessageLoader() {
        return this.messageLoader;
    }

    protected abstract MessageSplitter getMessagePartition();

    public void enabledMessageSpliter(boolean useSpliter) {
        this.messageLoader.enable(useSpliter);
    }

    public abstract boolean isConnected();

    public abstract boolean isOpen();

    public abstract boolean close();

    public void release() {
        this.socketSelector.unRegister(this.selectionKey);
    }

    public abstract String toString();

    public class State {
        private volatile boolean init = true;
        private volatile boolean connect = false;
        private volatile boolean receive = false;
        private volatile boolean send = false;
        private volatile boolean close = false;

        public boolean isInit() {
            return this.init;
        }

        public void setInit(boolean init) {
            this.init = init;
        }

        public boolean isConnect() {
            return this.connect;
        }

        public void setConnect(boolean connect) {
            this.connect = connect;
        }

        public boolean isReceive() {
            return this.receive;
        }

        public void setReceive(boolean receive) {
            this.receive = receive;
        }

        public boolean isSend() {
            return this.send;
        }

        public void setSend(boolean send) {
            this.send = send;
        }

        public boolean isClose() {
            return this.close;
        }

        public void setClose(boolean close) {
            this.close = close;
        }
    }
}

