/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.network;

import java.nio.ByteBuffer;
import java.util.concurrent.LinkedBlockingDeque;
import org.voovan.network.ConnectModel;
import org.voovan.network.IoSession;
import org.voovan.network.SocketContext;
import org.voovan.tools.TEnv;
import org.voovan.tools.buffer.ByteBufferChannel;

public class HeartBeat {
    private byte[] ping;
    private byte[] pong;
    private boolean isFirstBeat = true;
    private LinkedBlockingDeque<Integer> queue;
    private int fieldCount = 0;

    private HeartBeat(String ping, String pong) {
        this.ping = ping.getBytes();
        this.pong = pong.getBytes();
        this.queue = new LinkedBlockingDeque();
    }

    private LinkedBlockingDeque<Integer> getQueue() {
        return this.queue;
    }

    public byte[] getPing() {
        return this.ping;
    }

    public byte[] getPong() {
        return this.pong;
    }

    public int getFailedCount() {
        return this.fieldCount;
    }

    public static void interceptHeartBeat(IoSession session, ByteBufferChannel byteBufferChannel) {
        if (session == null || byteBufferChannel == null) {
            return;
        }
        HeartBeat heartBeat = session.getHeartBeat();
        if (heartBeat != null && byteBufferChannel.size() > 0 && heartBeat != null) {
            if (byteBufferChannel.startWith(heartBeat.getPing())) {
                byteBufferChannel.shrink(0, heartBeat.getPing().length);
                heartBeat.getQueue().addLast(1);
                return;
            }
            if (byteBufferChannel.startWith(heartBeat.getPong())) {
                byteBufferChannel.shrink(0, heartBeat.getPong().length);
                heartBeat.getQueue().addLast(2);
                return;
            }
        }
    }

    public static boolean beat(IoSession session) {
        if (!session.isConnected()) {
            return false;
        }
        HeartBeat heartBeat = session.getHeartBeat();
        if (heartBeat.isFirstBeat) {
            heartBeat.isFirstBeat = false;
            if (((SocketContext)session.socketContext()).getConnectModel() == ConnectModel.CLIENT) {
                TEnv.sleep(session.getIdleInterval());
                session.send(ByteBuffer.wrap(heartBeat.ping));
                session.flush();
            }
            return true;
        }
        int waitCount = 0;
        while (heartBeat.getQueue().size() == 0) {
            TEnv.sleep(1);
            if (++waitCount < session.getIdleInterval() * 1000) continue;
        }
        if (heartBeat.getQueue().size() > 0) {
            int beatType = heartBeat.getQueue().pollFirst();
            if (beatType == 1) {
                session.send(ByteBuffer.wrap(heartBeat.pong));
                session.flush();
                heartBeat.fieldCount = 0;
                return true;
            }
            if (beatType == 2) {
                session.send(ByteBuffer.wrap(heartBeat.ping));
                session.flush();
                heartBeat.fieldCount = 0;
                return true;
            }
            ++heartBeat.fieldCount;
            return false;
        }
        ++heartBeat.fieldCount;
        return false;
    }

    public static HeartBeat attachSession(IoSession session, String ping, String pong) {
        HeartBeat heartBeat = null;
        if (session.getHeartBeat() == null) {
            heartBeat = new HeartBeat(ping, pong);
            session.setHeartBeat(heartBeat);
        } else {
            heartBeat = session.getHeartBeat();
        }
        return heartBeat;
    }

    public static HeartBeat attachSession(IoSession session, int connectModel) {
        HeartBeat heartBeat = null;
        if (session.getHeartBeat() == null) {
            heartBeat = new HeartBeat("PING", "PONG");
            session.setHeartBeat(heartBeat);
        } else {
            heartBeat = session.getHeartBeat();
        }
        return heartBeat;
    }
}

