/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.network;

import org.voovan.network.Event;
import org.voovan.network.EventProcess;
import org.voovan.network.IoSession;

public class EventTrigger {
    public static void fireAcceptAsEvent(IoSession session) {
        EventTrigger.fireEvent(session, Event.EventName.ON_ACCEPTED, null);
    }

    public static void fireConnectAsEvent(IoSession session) {
        session.getState().setInit(false);
        session.getState().setConnect(true);
        EventTrigger.fireEvent(session, Event.EventName.ON_CONNECT, null);
    }

    public static void fireReceiveAsEvent(IoSession session) {
        EventTrigger.fireEvent(session, Event.EventName.ON_RECEIVE, null);
    }

    public static void fireSentAsEvent(IoSession session, Object obj) {
        EventTrigger.fireEvent(session, Event.EventName.ON_SENT, obj);
    }

    public static void fireFlushAsEvent(IoSession session) {
        EventTrigger.fireEvent(session, Event.EventName.ON_FLUSH, null);
    }

    public static void fireDisconnectAsEvent(IoSession session) {
        session.getState().setClose(true);
        EventTrigger.fireEvent(session, Event.EventName.ON_DISCONNECT, null);
    }

    public static void fireIdleAsEvent(IoSession session) {
        if (session.getIdleInterval() > 0) {
            EventTrigger.fireEvent(session, Event.EventName.ON_IDLE, null);
        }
    }

    public static void fireExceptionAsEvent(IoSession session, Exception exception) {
        EventTrigger.fireEvent(session, Event.EventName.ON_EXCEPTION, exception);
    }

    public static void fireAccept(IoSession session) {
        EventTrigger.fire(session, Event.EventName.ON_ACCEPTED, null);
    }

    public static void fireConnect(IoSession session) {
        session.getState().setInit(false);
        session.getState().setConnect(true);
        EventTrigger.fire(session, Event.EventName.ON_CONNECT, null);
    }

    public static void fireReceive(IoSession session) {
        EventTrigger.fire(session, Event.EventName.ON_RECEIVE, null);
    }

    public static void fireSent(IoSession session, Object obj) {
        EventTrigger.fire(session, Event.EventName.ON_SENT, obj);
    }

    public static void fireFlush(IoSession session) {
        EventTrigger.fire(session, Event.EventName.ON_FLUSH, null);
    }

    public static void fireDisconnect(IoSession session) {
        session.getState().setClose(true);
        EventTrigger.fire(session, Event.EventName.ON_DISCONNECT, null);
    }

    public static void fireIdle(IoSession session) {
        if (session.getIdleInterval() > 0) {
            EventTrigger.fire(session, Event.EventName.ON_IDLE, null);
        }
    }

    public static void fireException(IoSession session, Exception exception) {
        EventTrigger.fire(session, Event.EventName.ON_EXCEPTION, exception);
    }

    public static void fireEvent(IoSession session, Event.EventName name, Object other) {
        session.getEventRunner().addEvent(5, () -> {
            Event event = new Event(session, name, other);
            EventProcess.process(event);
        });
    }

    public static void fire(IoSession session, Event.EventName name, Object other) {
        Event event = new Event(session, name, other);
        EventProcess.process(event);
    }
}

