/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.network;

import java.io.IOException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.voovan.network.EventRunner;
import org.voovan.network.SocketSelector;
import org.voovan.tools.TObject;
import org.voovan.tools.TPerformance;
import org.voovan.tools.threadpool.ThreadPool;

public class EventRunnerGroup {
    public static int ACCEPT_THREAD_SIZE = 1;
    public static ThreadPoolExecutor ACCEPT_THREAD_POOL = ThreadPool.createThreadPool("ACCEPT", 1, ACCEPT_THREAD_SIZE, 60000, true, 10);
    public static EventRunnerGroup ACCEPT_EVENT_RUNNER_GROUP = new EventRunnerGroup(ACCEPT_THREAD_POOL, ACCEPT_THREAD_SIZE, obj -> {
        try {
            return new SocketSelector((EventRunner)obj);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    });
    public static int IO_THREAD_SIZE = Integer.valueOf(TObject.nullDefault(System.getProperty("IoThreadSize"), TPerformance.getProcessorCount() + ""));
    public static ThreadPoolExecutor IO_THREAD_POOL = ThreadPool.createThreadPool("IO", IO_THREAD_SIZE, IO_THREAD_SIZE, 60000, true, 9);
    public static EventRunnerGroup IO_EVENT_RUNNER_GROUP = new EventRunnerGroup(IO_THREAD_POOL, IO_THREAD_SIZE, obj -> {
        try {
            return new SocketSelector((EventRunner)obj);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    });
    private AtomicInteger indexAtom = new AtomicInteger();
    private EventRunner[] eventRunners;
    private volatile int size;

    public EventRunnerGroup(ThreadPoolExecutor threadPoolExecutor, int size, Function<EventRunner, Object> attachmentSupplier) {
        this.size = size;
        this.eventRunners = new EventRunner[size];
        for (int i = 0; i < size; ++i) {
            EventRunner eventRunner = new EventRunner();
            if (attachmentSupplier != null) {
                eventRunner.attachment(attachmentSupplier.apply(eventRunner));
            }
            this.eventRunners[i] = eventRunner;
            threadPoolExecutor.execute(() -> {
                eventRunner.setThread(Thread.currentThread());
                eventRunner.process();
            });
        }
    }

    public EventRunner[] getEventRunners() {
        return this.eventRunners;
    }

    public EventRunner choseEventRunner() {
        int index = this.indexAtom.getAndUpdate(val -> {
            int newVal = val + 1;
            return this.size == newVal ? 0 : newVal;
        });
        EventRunner eventRunner = this.eventRunners[index];
        return eventRunner;
    }

    static {
        System.out.println("[SOCKET] IO_THREAD_SIZE: " + IO_THREAD_SIZE);
    }
}

