/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.network;

import java.util.concurrent.PriorityBlockingQueue;

public class EventRunner {
    private PriorityBlockingQueue<EventTask> eventQueue = new PriorityBlockingQueue();
    private Object attachment;
    private Thread thread = null;

    public Thread getThread() {
        return this.thread;
    }

    void setThread(Thread thread) {
        this.thread = thread;
    }

    public Object attachment() {
        return this.attachment;
    }

    public void attachment(Object attachment) {
        this.attachment = attachment;
    }

    public void addEvent(int priority, Runnable runnable) {
        if (priority > 10 || priority < 1) {
            throw new UnsupportedOperationException("priority must between 1-10");
        }
        this.eventQueue.add(EventTask.newInstance(priority, runnable));
    }

    public PriorityBlockingQueue<EventTask> getEventQueue() {
        return this.eventQueue;
    }

    public void process() {
        while (true) {
            try {
                while (true) {
                    EventTask eventTask;
                    Runnable runnable;
                    if ((runnable = (eventTask = this.eventQueue.take()).getRunnable()) == null) {
                        continue;
                    }
                    runnable.run();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static class EventTask
    implements Comparable {
        private int priority;
        private Runnable runnable;

        public EventTask(int priority, Runnable runnable) {
            this.priority = priority;
            this.runnable = runnable;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public Runnable getRunnable() {
            return this.runnable;
        }

        public void setRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        public static EventTask newInstance(int priority, Runnable runnable) {
            return new EventTask(priority, runnable);
        }

        public static EventTask newInstance(Runnable runnable) {
            return new EventTask(0, runnable);
        }

        public int compareTo(Object o) {
            EventTask current = (EventTask)o;
            if (current.priority > this.priority) {
                return 1;
            }
            if (current.priority == this.priority) {
                return 0;
            }
            return -1;
        }
    }
}

