/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeoutException;
import org.voovan.network.Event;
import org.voovan.network.EventTrigger;
import org.voovan.network.HeartBeat;
import org.voovan.network.IoFilter;
import org.voovan.network.IoHandler;
import org.voovan.network.IoSession;
import org.voovan.network.MessageLoader;
import org.voovan.network.SocketContext;
import org.voovan.network.exception.IoFilterException;
import org.voovan.network.udp.UdpSocket;
import org.voovan.tools.FastThreadLocal;
import org.voovan.tools.buffer.TByteBuffer;
import org.voovan.tools.collection.Chain;

public class EventProcess {
    public static FastThreadLocal<ByteBuffer> THREAD_BYTE_BYTE = FastThreadLocal.withInitial(() -> TByteBuffer.allocateDirect());

    private EventProcess() {
    }

    public static void onAccepted(Event event) throws IOException {
        Object socketContext = event.getSession().socketContext();
        ((SocketContext)socketContext).acceptStart();
    }

    public static void onConnect(Event event) throws IOException {
        Object original;
        IoSession session = event.getSession();
        Object socketContext = event.getSession().socketContext();
        if (socketContext != null && session != null && (original = ((SocketContext)socketContext).handler().onConnect(session)) != null) {
            EventProcess.sendMessage(session, original);
            session.flush();
        }
        session.getState().setConnect(false);
    }

    public static void onDisconnect(Event event) {
        IoSession session = event.getSession();
        session.cancelIdle();
        Object socketContext = event.getSession().socketContext();
        if (socketContext != null) {
            ((SocketContext)socketContext).handler().onDisconnect(session);
        }
        session.getState().setClose(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onRead(Event event, int recursionDepth) throws IOException, TimeoutException {
        block10: {
            IoSession session = event.getSession();
            int currentRecursionDepth = recursionDepth++;
            if (session != null) {
                MessageLoader messageLoader = session.getMessageLoader();
                if (!messageLoader.isEnable()) {
                    return;
                }
                try {
                    int splitLength = messageLoader.read();
                    if (splitLength >= 0) {
                        Object result = EventProcess.doRecive(session, splitLength);
                        if (recursionDepth < ((SocketContext)session.socketContext()).getReadRecursionDepth() && session.getReadByteBufferChannel().size() > 0) {
                            EventProcess.onRead(event, recursionDepth);
                        }
                        break block10;
                    }
                    session.close();
                    throw new TimeoutException("Socket is read timeout");
                }
                finally {
                    if (currentRecursionDepth == 0) {
                        if (session.getSendByteBufferChannel().size() > 0) {
                            session.flush();
                        }
                        if (session.getReadByteBufferChannel().size() > 0) {
                            HeartBeat.interceptHeartBeat(session, session.getReadByteBufferChannel());
                            EventTrigger.fireReceiveAsEvent(session);
                        }
                    }
                }
            }
        }
    }

    public static ByteBuffer loadSplitData(IoSession session, int splitLength) {
        if (splitLength == 0) {
            return TByteBuffer.EMPTY_BYTE_BUFFER;
        }
        ByteBuffer byteBuffer = THREAD_BYTE_BYTE.get();
        byteBuffer.clear();
        if (byteBuffer.capacity() < splitLength) {
            TByteBuffer.reallocate(byteBuffer, splitLength);
        }
        try {
            byteBuffer.limit(splitLength);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (session.socketContext() instanceof UdpSocket && session.isOpen() || session.isConnected()) {
            session.getReadByteBufferChannel().readHead(byteBuffer);
            return byteBuffer;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object doRecive(IoSession session, int splitLength) throws IOException {
        Object result = null;
        session.getState().setReceive(true);
        try {
            ByteBuffer byteBuffer = EventProcess.loadSplitData(session, splitLength);
            if (byteBuffer == null) {
                session.getState().setReceive(false);
                Object var4_4 = null;
                return var4_4;
            }
            result = EventProcess.filterDecoder(session, byteBuffer);
            if (result != null) {
                IoHandler handler = ((SocketContext)session.socketContext()).handler();
                result = handler.onReceive(session, result);
            }
        }
        finally {
            session.getState().setReceive(false);
        }
        if (result != null) {
            session.getState().setSend(true);
            EventProcess.sendMessage(session, result);
            return result;
        }
        return null;
    }

    public static Object filterDecoder(IoSession session, ByteBuffer readedBuffer) throws IoFilterException {
        IoFilter fitler;
        Object result = readedBuffer;
        Chain<IoFilter> filterChain = ((SocketContext)session.socketContext()).filterChain().rewind();
        while (filterChain.hasNext() && (result = (fitler = filterChain.next()).decode(session, result)) != null) {
        }
        return result;
    }

    public static ByteBuffer filterEncoder(IoSession session, Object result) throws IoFilterException {
        IoFilter fitler;
        Chain<IoFilter> filterChain = ((SocketContext)session.socketContext()).filterChain().rewind();
        filterChain.rewind();
        while (filterChain.hasPrevious() && (result = (fitler = filterChain.previous()).encode(session, result)) != null) {
        }
        if (result instanceof ByteBuffer) {
            return (ByteBuffer)result;
        }
        if (result == null) {
            return null;
        }
        throw new IoFilterException("Send object must be ByteBuffer, please check you filter be sure the latest filter return Object's type is ByteBuffer.");
    }

    public static void sendMessage(IoSession session, Object obj) {
        Object sendObj = obj;
        try {
            ByteBuffer sendBuffer = EventProcess.filterEncoder(session, sendObj);
            if (sendBuffer != null && session.isOpen() && sendBuffer.limit() > 0) {
                int sendLength = session.send(sendBuffer);
                if (sendLength >= 0) {
                    sendBuffer.rewind();
                } else {
                    throw new IOException("EventProcess.sendMessage faild, writeToChannel length: " + sendLength);
                }
            }
            EventTrigger.fireSent(session, sendObj);
            session.getState().setSend(false);
        }
        catch (IOException e) {
            EventTrigger.fireException(session, e);
        }
    }

    public static void onSent(Event event, Object sendObj) throws IOException {
        IoSession session = event.getSession();
        Object socketContext = session.socketContext();
        if (socketContext != null) {
            ((SocketContext)socketContext).handler().onSent(session, sendObj);
        }
    }

    public static void onFlush(Event event) throws IOException {
        IoSession session = event.getSession();
        Object socketContext = session.socketContext();
        if (socketContext != null) {
            ((SocketContext)socketContext).handler().onFlush(session);
        }
    }

    public static void onIdle(Event event) {
        Object socketContext = event.getSession().socketContext();
        if (socketContext != null) {
            IoSession session = event.getSession();
            ((SocketContext)socketContext).handler().onIdle(session);
        }
    }

    public static void onException(Event event, Exception e) {
        IoSession session = event.getSession();
        Object socketContext = event.getSession().socketContext();
        if (socketContext != null && ((SocketContext)socketContext).handler() != null) {
            ((SocketContext)socketContext).handler().onException(session, e);
        }
    }

    public static void process(Event event) {
        if (event == null) {
            return;
        }
        Event.EventName eventName = event.getName();
        try {
            if (eventName == Event.EventName.ON_ACCEPTED) {
                EventProcess.onAccepted(event);
            } else if (eventName == Event.EventName.ON_CONNECT) {
                EventProcess.onConnect(event);
            } else if (eventName == Event.EventName.ON_DISCONNECT) {
                EventProcess.onDisconnect(event);
            } else if (eventName == Event.EventName.ON_RECEIVE) {
                EventProcess.onRead(event, 0);
            } else if (eventName == Event.EventName.ON_SENT) {
                EventProcess.onSent(event, event.getOther());
            } else if (eventName == Event.EventName.ON_FLUSH) {
                EventProcess.onFlush(event);
            } else if (eventName == Event.EventName.ON_IDLE) {
                EventProcess.onIdle(event);
            } else if (eventName == Event.EventName.ON_EXCEPTION) {
                EventProcess.onException(event, (Exception)event.getOther());
            }
        }
        catch (Exception e) {
            EventProcess.onException(event, e);
        }
    }
}

