/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.websocket;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.voovan.http.HttpSessionParam;
import org.voovan.http.server.HttpRequest;
import org.voovan.http.server.HttpSession;
import org.voovan.http.websocket.WebSocketFrame;
import org.voovan.http.websocket.WebSocketRouter;
import org.voovan.http.websocket.WebSocketTools;
import org.voovan.http.websocket.WebSocketType;
import org.voovan.http.websocket.exception.WebSocketFilterException;
import org.voovan.network.IoSession;
import org.voovan.network.exception.SendMessageException;
import org.voovan.tools.log.Logger;

public class WebSocketSession {
    private IoSession socketSession;
    private WebSocketRouter webSocketRouter;
    private String remoteAddres;
    private int remotePort;
    private WebSocketType webSocketType;
    private boolean masked;
    private Map<String, Object> attributes;

    public WebSocketSession(IoSession socketSession, WebSocketRouter webSocketRouter, WebSocketType webSocketType) {
        this.socketSession = socketSession;
        this.remoteAddres = socketSession.remoteAddress();
        this.remotePort = socketSession.remotePort();
        this.webSocketRouter = webSocketRouter;
        this.attributes = new ConcurrentHashMap<String, Object>();
        this.webSocketType = webSocketType;
        this.masked = this.webSocketType != WebSocketType.SERVER;
    }

    public String getLocation() {
        HttpRequest request = (HttpRequest)this.socketSession.getAttribute(HttpSessionParam.HTTP_REQUEST);
        return request.protocol().getPath();
    }

    public HttpSession getHttpSession() {
        HttpRequest request = (HttpRequest)this.socketSession.getAttribute(HttpSessionParam.HTTP_REQUEST);
        if (request.sessionExists()) {
            return request.getSession();
        }
        return null;
    }

    public String getRemoteAddres() {
        return this.remoteAddres;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public boolean containAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public WebSocketRouter getWebSocketRouter() {
        return this.webSocketRouter;
    }

    public void setWebSocketRouter(WebSocketRouter webSocketRouter) {
        this.webSocketRouter = webSocketRouter;
    }

    public void send(Object obj) throws SendMessageException, WebSocketFilterException {
        ByteBuffer byteBuffer = (ByteBuffer)this.webSocketRouter.filterEncoder(this, obj);
        WebSocketFrame webSocketFrame = WebSocketFrame.newInstance(true, WebSocketFrame.Opcode.TEXT, this.masked, byteBuffer);
        this.socketSession.syncSend(webSocketFrame);
    }

    public void sendBinary(Object obj) throws SendMessageException, WebSocketFilterException {
        ByteBuffer byteBuffer = (ByteBuffer)this.webSocketRouter.filterEncoder(this, obj);
        WebSocketFrame webSocketFrame = WebSocketFrame.newInstance(true, WebSocketFrame.Opcode.BINARY, this.masked, byteBuffer);
        this.socketSession.syncSend(webSocketFrame);
    }

    protected void send(WebSocketFrame webSocketFrame) throws SendMessageException {
        this.socketSession.syncSend(webSocketFrame);
    }

    public boolean isConnected() {
        return this.socketSession.isConnected();
    }

    public void close() {
        WebSocketFrame closeWebSocketFrame = WebSocketFrame.newInstance(true, WebSocketFrame.Opcode.CLOSING, this.masked, ByteBuffer.wrap(WebSocketTools.intToByteArray(1000, 2)));
        try {
            this.send(closeWebSocketFrame);
        }
        catch (SendMessageException e) {
            Logger.error("Close WebSocket error, Socket will be close ", e);
            this.socketSession.close();
        }
    }

    protected IoSession getSocketSession() {
        return this.socketSession;
    }

    public void setSocketSession(IoSession socketSession) {
        this.socketSession = socketSession;
    }
}

