/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.websocket;

import java.nio.ByteBuffer;
import org.voovan.http.websocket.WebSocketFilter;
import org.voovan.http.websocket.WebSocketSession;
import org.voovan.http.websocket.exception.WebSocketFilterException;
import org.voovan.tools.collection.Chain;

public abstract class WebSocketRouter
implements Cloneable {
    protected Chain<WebSocketFilter> webSocketFilterChain = new Chain();

    public WebSocketRouter addFilterChain(WebSocketFilter webSocketFilter) {
        this.webSocketFilterChain.add(webSocketFilter);
        return this;
    }

    public WebSocketRouter clearFilterChain(WebSocketFilter webSocketFilter) {
        this.webSocketFilterChain.clear();
        return this;
    }

    public WebSocketRouter removeFilterChain(WebSocketFilter webSocketFilter) {
        this.webSocketFilterChain.remove(webSocketFilter);
        return this;
    }

    public Object filterDecoder(WebSocketSession session, Object result) throws WebSocketFilterException {
        WebSocketFilter fitler;
        Chain<WebSocketFilter> tmpWebFilterChain = this.webSocketFilterChain.rewind();
        tmpWebFilterChain.rewind();
        while (tmpWebFilterChain.hasNext() && (result = (fitler = tmpWebFilterChain.next()).decode(session, result)) != null) {
        }
        return result;
    }

    public Object filterEncoder(WebSocketSession session, Object result) throws WebSocketFilterException {
        WebSocketFilter fitler;
        Chain<WebSocketFilter> tmpWebFilterChain = this.webSocketFilterChain.rewind();
        tmpWebFilterChain.rewind();
        while (tmpWebFilterChain.hasPrevious() && (result = (fitler = tmpWebFilterChain.previous()).encode(session, result)) != null) {
        }
        if (result instanceof ByteBuffer || result == null) {
            return (ByteBuffer)result;
        }
        throw new WebSocketFilterException("Send object must be ByteBuffer, please check you filter be sure the latest filter return Object's type is ByteBuffer.");
    }

    public abstract Object onOpen(WebSocketSession var1);

    public abstract Object onRecived(WebSocketSession var1, Object var2);

    public abstract void onSent(WebSocketSession var1, Object var2);

    public abstract void onClose(WebSocketSession var1);
}

