/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.websocket;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Random;
import org.voovan.tools.buffer.TByteBuffer;
import org.voovan.tools.log.Logger;

public class WebSocketFrame {
    private boolean fin;
    private Opcode opcode;
    private boolean transfereMask;
    private ByteBuffer frameData;
    private int errorCode = 0;

    public boolean isFin() {
        return this.fin;
    }

    public void setFin(boolean fin) {
        this.fin = fin;
    }

    public Opcode getOpcode() {
        return this.opcode;
    }

    public void setOpcode(Opcode opcode) {
        this.opcode = opcode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public boolean isTransfereMask() {
        return this.transfereMask;
    }

    public void setTransfereMask(boolean transfereMask) {
        this.transfereMask = transfereMask;
    }

    public ByteBuffer getFrameData() {
        return this.frameData;
    }

    public void setFrameData(ByteBuffer frameData) {
        this.frameData = frameData;
    }

    public static WebSocketFrame newInstance(boolean fin, Opcode opcode, boolean mask, ByteBuffer binary, int errorCode) {
        WebSocketFrame webSocketFrame = new WebSocketFrame();
        webSocketFrame.setFin(fin);
        webSocketFrame.setOpcode(opcode);
        webSocketFrame.setTransfereMask(mask);
        webSocketFrame.setFrameData(binary);
        webSocketFrame.setErrorCode(errorCode);
        return webSocketFrame;
    }

    public static WebSocketFrame newInstance(boolean fin, Opcode opcode, boolean mask, ByteBuffer binary) {
        WebSocketFrame webSocketFrame = new WebSocketFrame();
        webSocketFrame.setFin(fin);
        webSocketFrame.setOpcode(opcode);
        webSocketFrame.setTransfereMask(mask);
        webSocketFrame.setFrameData(binary);
        return webSocketFrame;
    }

    public static WebSocketFrame parse(ByteBuffer byteBuffer) {
        byte maskByte;
        byte finByte;
        int expectPackagesize;
        if (!byteBuffer.hasRemaining()) {
            return null;
        }
        int errorCode = 0;
        int maxpacketsize = byteBuffer.remaining();
        if (maxpacketsize < (expectPackagesize = 2)) {
            Logger.error("Expect package size error!");
            errorCode = 1002;
        }
        boolean fin = (finByte = byteBuffer.get()) >> 8 != 0;
        byte rsv = (byte)((finByte & 0x7F) >> 4);
        if (rsv != 0) {
            Logger.error("RSV data error!");
            errorCode = 1002;
        }
        boolean mask = ((maskByte = byteBuffer.get()) & 0xFFFFFF80) != 0;
        int payloadlength = maskByte & 0x7F;
        Opcode opcode = WebSocketFrame.toOpcode((byte)(finByte & 0xF));
        if (opcode == null) {
            Logger.error("Opcode data error!");
            errorCode = 1002;
        }
        if (payloadlength == 126) {
            expectPackagesize += 2;
            byte[] sizebytes = new byte[3];
            sizebytes[1] = byteBuffer.get();
            sizebytes[2] = byteBuffer.get();
            payloadlength = new BigInteger(sizebytes).intValue();
        } else if (payloadlength == 127) {
            expectPackagesize += 8;
            byte[] bytes = new byte[8];
            for (int i = 0; i < 8; ++i) {
                bytes[i] = byteBuffer.get();
            }
            long length = new BigInteger(bytes).longValue();
            if (length <= Integer.MAX_VALUE) {
                payloadlength = (int)length;
            }
        }
        expectPackagesize += mask ? 4 : 0;
        if (maxpacketsize < (expectPackagesize += payloadlength)) {
            Logger.error("Parse package size error!");
        }
        ByteBuffer payload = ByteBuffer.allocateDirect(payloadlength);
        if (mask) {
            byte[] maskskey = new byte[4];
            byteBuffer.get(maskskey);
            for (int i = 0; i < payloadlength; ++i) {
                payload.put((byte)(byteBuffer.get() ^ maskskey[i % 4]));
            }
        } else {
            payload.put(byteBuffer);
        }
        payload.flip();
        WebSocketFrame webSocketFrame = WebSocketFrame.newInstance(fin, opcode, mask, payload, errorCode);
        return webSocketFrame;
    }

    private static Opcode toOpcode(byte opcode) {
        switch (opcode) {
            case 0: {
                return Opcode.CONTINUOUS;
            }
            case 1: {
                return Opcode.TEXT;
            }
            case 2: {
                return Opcode.BINARY;
            }
            case 8: {
                return Opcode.CLOSING;
            }
            case 9: {
                return Opcode.PING;
            }
            case 10: {
                return Opcode.PONG;
            }
        }
        return null;
    }

    private static byte fromOpcode(Opcode opcode) {
        if (opcode == Opcode.CONTINUOUS) {
            return 0;
        }
        if (opcode == Opcode.TEXT) {
            return 1;
        }
        if (opcode == Opcode.BINARY) {
            return 2;
        }
        if (opcode == Opcode.CLOSING) {
            return 8;
        }
        if (opcode == Opcode.PING) {
            return 9;
        }
        if (opcode == Opcode.PONG) {
            return 10;
        }
        return -1;
    }

    private static byte[] toByteArray(long value, int bytecount) {
        byte[] buffer = new byte[bytecount];
        int highest = 8 * bytecount - 8;
        for (int i = 0; i < bytecount; ++i) {
            buffer[i] = (byte)(value >>> highest - 8 * i);
        }
        return buffer;
    }

    public ByteBuffer toByteBuffer() {
        ByteBuffer data = this.getFrameData();
        if (data == null) {
            data = TByteBuffer.EMPTY_BYTE_BUFFER;
        }
        boolean mask = this.isTransfereMask();
        int sizebytes = data.remaining() <= 125 ? 1 : (data.remaining() <= 65535 ? 2 : 8);
        ByteBuffer buf = ByteBuffer.allocateDirect(1 + (sizebytes > 1 ? sizebytes + 1 : sizebytes) + (mask ? 4 : 0) + data.remaining());
        byte optcode = WebSocketFrame.fromOpcode(this.getOpcode());
        byte one = (byte)(this.isFin() ? -128 : 0);
        one = (byte)(one | optcode);
        buf.put(one);
        byte[] payloadlengthbytes = WebSocketFrame.toByteArray(data.remaining(), sizebytes);
        if (sizebytes == 1) {
            buf.put((byte)(payloadlengthbytes[0] | (mask ? -128 : 0)));
        } else if (sizebytes == 2) {
            buf.put((byte)(0x7E | (mask ? -128 : 0)));
            buf.put(payloadlengthbytes);
        } else if (sizebytes == 8) {
            buf.put((byte)(0x7F | (mask ? -128 : 0)));
            buf.put(payloadlengthbytes);
        } else {
            Logger.error("Size representation not supported/specified");
        }
        if (mask) {
            ByteBuffer maskkey = TByteBuffer.allocateDirect(4);
            Random reuseableRandom = new Random();
            maskkey.putInt(reuseableRandom.nextInt());
            maskkey.flip();
            buf.put(maskkey);
            int i = 0;
            while (data.hasRemaining()) {
                buf.put((byte)(data.get() ^ maskkey.get(i % 4)));
                ++i;
            }
            TByteBuffer.release(maskkey);
        } else {
            buf.put(data);
        }
        buf.flip();
        return buf;
    }

    public String toString() {
        return "Framedata={FIN: " + this.isFin() + " , Mask: " + this.isTransfereMask() + " , OpCode: " + (Object)((Object)this.getOpcode()) + " , Data: " + TByteBuffer.toString(this.getFrameData()) + "}";
    }

    public static enum Opcode {
        CONTINUOUS,
        TEXT,
        BINARY,
        PING,
        PONG,
        CLOSING;

    }
}

