/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.server.router;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import org.voovan.http.server.HttpRequest;
import org.voovan.http.server.HttpResponse;
import org.voovan.http.server.HttpRouter;
import org.voovan.http.server.MimeTools;
import org.voovan.http.server.exception.ResourceNotFound;
import org.voovan.tools.TDateTime;
import org.voovan.tools.TFile;
import org.voovan.tools.TString;
import org.voovan.tools.security.THash;

public class MimeFileRouter
implements HttpRouter {
    private String rootPath;

    public MimeFileRouter(String rootPath) {
        this.rootPath = rootPath;
    }

    public File getStaticFile(HttpRequest request) {
        String urlPath = request.protocol().getPath();
        urlPath = TString.fastReplaceAll(urlPath, "//", File.separator);
        String filePath = this.rootPath + urlPath;
        return new File(filePath);
    }

    @Override
    public void process(HttpRequest request, HttpResponse response) throws Exception {
        String urlPath = request.protocol().getPath();
        File responseFile = this.getStaticFile(request);
        if (responseFile.exists()) {
            String fileExtension = urlPath.substring(urlPath.lastIndexOf(".") + 1, urlPath.length());
            response.header().put("Content-Type", MimeTools.getMimeByFileExtension(fileExtension));
            if (this.isNotModify(responseFile, request, response)) {
                return;
            }
        } else {
            throw new ResourceNotFound(urlPath);
        }
        this.fillMimeFile(responseFile, request, response);
    }

    public boolean isNotModify(File responseFile, HttpRequest request, HttpResponse response) throws ParseException {
        Date fileModifyDate = new Date(responseFile.lastModified());
        Date requestModifyDate = null;
        if (request.header().contain("If-Modified-Since")) {
            try {
                requestModifyDate = TDateTime.parseToGMT(request.header().get("If-Modified-Since"));
            }
            catch (Exception e) {
                requestModifyDate = null;
            }
        }
        String eTag = TString.assembly("\"", THash.encryptMD5(Integer.toString(responseFile.hashCode() + fileModifyDate.hashCode())).toUpperCase(), "\"");
        String requestETag = request.header().get("If-None-Match");
        response.header().put("ETag", eTag);
        response.header().put("Last-Modified", TDateTime.formatToGMT(fileModifyDate));
        response.header().put("Cache-Control", "max-age=86400");
        response.header().put("Expires", TDateTime.formatToGMT(new Date(System.currentTimeMillis() + 86400000L)));
        if (eTag.equals(requestETag)) {
            this.setNotModifyResponse(response);
            return true;
        }
        if (fileModifyDate.equals(requestModifyDate)) {
            this.setNotModifyResponse(response);
            return true;
        }
        return false;
    }

    public void fillMimeFile(File responseFile, HttpRequest request, HttpResponse response) throws IOException {
        byte[] fileByte = null;
        long fileSize = TFile.getFileSize(responseFile);
        if (request.header().get("Range") != null && request.header().get("Range").contains("-")) {
            long beginPos = -1L;
            long endPos = -1L;
            String rangeStr = request.header().get("Range");
            rangeStr = rangeStr.replace("bytes=", "").trim();
            String[] ranges = rangeStr.split("-");
            if (rangeStr.startsWith("-") && ranges.length == 1) {
                beginPos = fileSize - Long.parseLong(ranges[0]);
                endPos = fileSize;
            } else if (rangeStr.endsWith("-") && ranges.length == 1) {
                beginPos = Integer.parseInt(ranges[0]);
                endPos = fileSize;
            } else if (ranges.length == 2) {
                beginPos = Long.parseLong(ranges[0]);
                endPos = Long.parseLong(ranges[1]);
            }
            fileByte = TFile.loadFileFromSysPath(responseFile.getPath(), beginPos, endPos);
            response.header().put("Content-Range", TString.assembly("bytes ", rangeStr, File.separator, fileSize));
            response.body().write(fileByte);
        } else {
            response.body().changeToFile(responseFile.getCanonicalPath());
        }
    }

    public void setNotModifyResponse(HttpResponse response) {
        response.protocol().setStatus(304);
        response.protocol().setStatusCode("Not Modified");
    }
}

