/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.server.module.monitor;

import java.util.concurrent.atomic.AtomicLong;

public class RequestAnalysis {
    private String path;
    private AtomicLong count;
    private int avgTime;
    private int maxTime;
    private int minTime;

    public RequestAnalysis(String path) {
        this.path = path;
        this.count = new AtomicLong(0L);
        this.avgTime = 0;
        this.maxTime = 0;
        this.minTime = 0;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public long getCount() {
        return this.count.get();
    }

    public int getAvgTime() {
        return this.avgTime;
    }

    public int getMaxTime() {
        return this.maxTime;
    }

    public int getMinTime() {
        return this.minTime;
    }

    public void addRequestTime(int time) {
        this.count.addAndGet(1L);
        if (this.avgTime == 0) {
            this.avgTime = time;
        }
        this.avgTime = (this.avgTime + time) / 2;
        if (this.maxTime == 0) {
            this.maxTime = time;
        }
        if (this.minTime == 0) {
            this.minTime = time;
        }
        if (this.maxTime < time) {
            this.maxTime = time;
        }
        if (this.minTime > time) {
            this.minTime = time;
        }
    }
}

