/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.server.module.monitor;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import org.voovan.http.server.HttpRequest;
import org.voovan.http.server.HttpResponse;
import org.voovan.http.server.HttpRouter;
import org.voovan.http.server.context.WebContext;
import org.voovan.http.server.module.monitor.IPAnalysis;
import org.voovan.http.server.module.monitor.MonitorGlobal;
import org.voovan.http.server.module.monitor.RequestAnalysis;
import org.voovan.tools.TDateTime;
import org.voovan.tools.TEnv;
import org.voovan.tools.TFile;
import org.voovan.tools.TObject;
import org.voovan.tools.TPerformance;
import org.voovan.tools.json.JSON;

public class MonitorRouter
implements HttpRouter {
    public static String readLogs(String type, int lineNumber) throws IOException {
        String fileName;
        if ("SYSOUT".equals(type)) {
            fileName = "sysout." + TDateTime.now("yyyyMMdd") + ".log";
        } else if ("ACCESS".equals(type)) {
            fileName = "access.log";
        } else {
            return null;
        }
        String fullPath = TFile.getSystemPath("logs" + File.separator + fileName);
        return new String(TFile.loadFileLastLines(new File(fullPath), lineNumber), "UTF-8");
    }

    public static List<RequestAnalysis> requestInfo() {
        return TObject.mapValueToList(MonitorGlobal.REQUEST_ANALYSIS);
    }

    public static List<IPAnalysis> ipAddressInfo() {
        return TObject.mapValueToList(MonitorGlobal.IP_ANALYSIS);
    }

    @Override
    public void process(HttpRequest request, HttpResponse response) throws Exception {
        String authToken = request.header().get("AUTH-TOKEN");
        if (authToken != null && authToken.equals(WebContext.AUTH_TOKEN) && MonitorGlobal.ALLOW_IP_ADDRESS.contains(request.getRemoteAddres())) {
            String type = request.getParameter("Type");
            String responseStr = "";
            if ("JVM".equals(type)) {
                responseStr = JSON.toJSON(TPerformance.getJVMInfo());
            } else if ("CPU".equals(type)) {
                responseStr = JSON.toJSON(TPerformance.getProcessorInfo());
            } else if ("Memory".equals(type)) {
                responseStr = JSON.toJSON(TPerformance.getJVMMemoryInfo());
            } else if ("MemoryUsage".equals(type)) {
                responseStr = JSON.toJSON(TPerformance.getJVMMemoryUsage());
            } else if ("Objects".equals(type)) {
                String filterWord = request.getParameter("Param1");
                filterWord = filterWord == null ? ".*" : filterWord;
                String headCountStr = request.getParameter("Param2");
                int headCount = headCountStr == null ? 10 : Integer.valueOf(headCountStr);
                responseStr = JSON.toJSON(TPerformance.getJVMObjectInfo(filterWord, headCount));
            } else if ("GC".equals(type)) {
                responseStr = JSON.toJSON(TPerformance.getJVMGCInfo());
            } else if ("Threads".equals(type)) {
                String state = request.getParameter("Param1");
                boolean withStack = Boolean.valueOf(request.getParameter("Param2"));
                responseStr = JSON.toJSON(TPerformance.getThreadDetail(state, withStack));
            } else if ("ThreadCount".equals(type)) {
                responseStr = Integer.toString(TEnv.getThreads().length);
            } else if ("ThreadPool".equals(type)) {
                responseStr = JSON.toJSON(TPerformance.getThreadPoolInfo());
            } else if ("RequestAnalysis".equals(type)) {
                responseStr = JSON.toJSON(MonitorRouter.requestInfo());
            } else if ("IPAddressAnalysis".equals(type)) {
                responseStr = JSON.toJSON(MonitorRouter.ipAddressInfo());
            } else if ("Log".equals(type)) {
                String logType = request.getParameter("Param1");
                logType = logType == null ? "SYSOUT" : logType;
                String lineNumberStr = request.getParameter("Param2");
                int lineNumber = lineNumberStr == null ? 50 : Integer.valueOf(lineNumberStr);
                responseStr = MonitorRouter.readLogs(logType, lineNumber);
            } else if ("Summary".equals(type)) {
                LinkedHashMap<String, Object> summary = new LinkedHashMap<String, Object>();
                summary.put("CPU", TPerformance.getProcessorInfo());
                summary.put("Memory", TPerformance.getJVMMemoryInfo());
                summary.put("MemoryUsage", TPerformance.getJVMMemoryUsage());
                summary.put("ThreadPool", TPerformance.getThreadPoolInfo());
                summary.put("ThreadCount", TEnv.getThreads().length);
                if (!"fast".equals(request.getParameter("Param1"))) {
                    summary.put("Objects", TPerformance.getJVMObjectInfo("", 10));
                    summary.put("GC", TPerformance.getJVMGCInfo());
                    summary.put("RunningThreads", TPerformance.getThreadDetail("RUNNABLE", false));
                    summary.put("RequestAnalysis", MonitorRouter.requestInfo());
                    summary.put("IPAddressAnalysis", MonitorRouter.ipAddressInfo());
                }
                responseStr = JSON.toJSON(summary);
            } else {
                request.getSession().close();
            }
            response.header().put("Content-Type", "application/json");
            response.write(responseStr);
        } else {
            request.getSession().close();
        }
    }
}

