/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.server.module.monitor;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.voovan.tools.TDateTime;
import org.voovan.tools.json.annotation.NotJSON;

public class IPAnalysis {
    private String address;
    private AtomicLong totalCount;
    private int lastMinuteCount;
    @NotJSON
    private int minute;
    private Map<String, Integer> data;

    public IPAnalysis(String address) {
        this.address = address;
        this.totalCount = new AtomicLong(0L);
        this.lastMinuteCount = 0;
        this.minute = TDateTime.getDateAtom(null, 12);
        this.data = new ConcurrentHashMap<String, Integer>();
    }

    public String getAddress() {
        return this.address;
    }

    public long getTotalCount() {
        return this.totalCount.get();
    }

    public int getLastMinuteCount() {
        return this.lastMinuteCount;
    }

    public Map<String, Integer> getData() {
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequest(String requestPath) {
        if (this.data.containsKey(requestPath)) {
            Map<String, Integer> map = this.data;
            synchronized (map) {
                this.data.put(requestPath, this.data.get(requestPath) + 1);
            }
        } else {
            this.data.put(requestPath, 1);
        }
        int currentMinute = TDateTime.getDateAtom(null, 12);
        if (currentMinute == this.minute) {
            ++this.lastMinuteCount;
        } else {
            this.minute = currentMinute;
            this.lastMinuteCount = 1;
        }
        this.totalCount.addAndGet(1L);
    }
}

