/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.server.module.annontationRouter.router;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.voovan.http.message.packet.Cookie;
import org.voovan.http.server.HttpContentType;
import org.voovan.http.server.HttpDispatcher;
import org.voovan.http.server.HttpRequest;
import org.voovan.http.server.HttpResponse;
import org.voovan.http.server.HttpRouter;
import org.voovan.http.server.HttpSession;
import org.voovan.http.server.WebServer;
import org.voovan.http.server.exception.AnnotationRouterException;
import org.voovan.http.server.module.annontationRouter.AnnotationModule;
import org.voovan.http.server.module.annontationRouter.annotation.Body;
import org.voovan.http.server.module.annontationRouter.annotation.BodyParam;
import org.voovan.http.server.module.annontationRouter.annotation.Check;
import org.voovan.http.server.module.annontationRouter.annotation.Head;
import org.voovan.http.server.module.annontationRouter.annotation.Param;
import org.voovan.http.server.module.annontationRouter.annotation.Router;
import org.voovan.http.server.module.annontationRouter.annotation.Session;
import org.voovan.http.server.module.annontationRouter.annotation.Source;
import org.voovan.tools.TEnv;
import org.voovan.tools.TFile;
import org.voovan.tools.TString;
import org.voovan.tools.json.JSON;
import org.voovan.tools.log.Logger;
import org.voovan.tools.reflect.TReflect;

public class AnnotationRouter
implements HttpRouter {
    private static Map<Class, Object> singletonObjs = new ConcurrentHashMap<Class, Object>();
    private Class clazz;
    private Method method;
    private Router classRouter;

    public AnnotationRouter(Class clazz, Method method, Router classRouter) {
        this.clazz = clazz;
        this.method = method;
        this.classRouter = classRouter;
        if (classRouter.singleton() && !singletonObjs.containsKey(clazz)) {
            try {
                singletonObjs.put(clazz, clazz.newInstance());
            }
            catch (Exception e) {
                Logger.error("New a singleton object error", e);
            }
        }
    }

    public static void scanRouterClassAndRegister(AnnotationModule httpModule) {
        int routeMethodNum = 0;
        WebServer webServer = httpModule.getWebServer();
        try {
            List<Class> routerClasses = TEnv.searchClassInEnv(httpModule.getScanRouterPackage(), new Class[]{Router.class});
            for (Class routerClass : routerClasses) {
                Method[] methods = routerClass.getMethods();
                Router annonClassRouter = routerClass.getAnnotation(Router.class);
                String classRouterPath = annonClassRouter.path().isEmpty() ? annonClassRouter.value() : annonClassRouter.path();
                String classRouterMethod = annonClassRouter.method();
                if (classRouterPath.isEmpty()) {
                    classRouterPath = TString.assembly("/", routerClass.getSimpleName());
                }
                for (Method method : methods) {
                    if (!method.isAnnotationPresent(Router.class)) continue;
                    Router annonMethodRouter = method.getAnnotation(Router.class);
                    String methodRouterPath = annonMethodRouter.path().isEmpty() ? annonMethodRouter.value() : annonMethodRouter.path();
                    String methodRouterMethod = annonMethodRouter.method();
                    if (methodRouterPath.isEmpty()) {
                        methodRouterPath = method.getName().equals("index") ? "/" : TString.assembly("/", method.getName());
                    }
                    String routePath = classRouterPath + methodRouterPath;
                    String routeMethod = methodRouterMethod != null ? methodRouterMethod : classRouterMethod;
                    String paramPath = "";
                    Annotation[][] parameterAnnotations = method.getParameterAnnotations();
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    for (int i = 0; i < parameterAnnotations.length; ++i) {
                        Annotation[] annotations = parameterAnnotations[i];
                        if (annotations.length == 0 && parameterTypes[i] != HttpRequest.class && parameterTypes[i] != HttpResponse.class && parameterTypes[i] != HttpSession.class) {
                            paramPath = paramPath + "/:param" + (i + 1);
                            continue;
                        }
                        for (Annotation annotation : annotations) {
                            if (!(annotation instanceof Param)) continue;
                            paramPath = TString.assembly(paramPath, "/:", ((Param)annotation).value());
                        }
                    }
                    if (webServer.getHttpRouters().get(routeMethod) == null) continue;
                    routePath = HttpDispatcher.fixRoutePath(routePath);
                    HashMap<String, HttpRouter> routerMaps = new HashMap<String, HttpRouter>();
                    routerMaps.putAll(webServer.getHttpRouters().get(routeMethod));
                    if (!paramPath.isEmpty()) {
                        routePath = routePath + paramPath;
                    }
                    if (routerMaps.containsKey(httpModule.getModuleConfig().getPath() + routePath)) continue;
                    AnnotationRouter annotationRouter = new AnnotationRouter(routerClass, method, annonClassRouter);
                    httpModule.otherMethod(routeMethod, routePath, annotationRouter);
                    httpModule.otherMethod(routeMethod, routePath, annotationRouter);
                    Logger.simple("[SYSTEM] Module [" + httpModule.getModuleConfig().getName() + "] Router add annotation route: " + TString.rightPad(routeMethod, 8, ' ') + httpModule.getModuleConfig().getPath() + routePath);
                    ++routeMethodNum;
                }
            }
            if (routeMethodNum > 0) {
                Logger.simple(TFile.getLineSeparator() + "[SYSTEM] Module [" + httpModule.getModuleConfig().getName() + "] Scan some class annotation by Router: " + routerClasses.size() + ". Register Router method annotation by route: " + routeMethodNum + ".");
            }
        }
        catch (Exception e) {
            Logger.error("Scan router class error.", e);
        }
    }

    public Object invokeRouterMethod(HttpRequest request, HttpResponse response, Class clazz, Method method) throws Exception {
        Object annotationObj = null;
        annotationObj = this.classRouter.singleton() ? singletonObjs.get(clazz) : (Object)clazz.newInstance();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        String bodyString = "";
        Map bodyMap = null;
        if (request.body().size() > 0L && JSON.isJSONMap(bodyString)) {
            bodyString = request.body().getBodyString();
            bodyMap = (Map)JSON.parse(bodyString);
        }
        Object[] params = new Object[parameterTypes.length];
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            if (parameterTypes[i] == HttpRequest.class) {
                params[i] = request;
                continue;
            }
            if (parameterTypes[i] == HttpResponse.class) {
                params[i] = response;
                continue;
            }
            if (parameterTypes[i] == HttpSession.class) {
                params[i] = request.getSession();
                continue;
            }
            for (Annotation annotation : parameterAnnotations[i]) {
                String paramName;
                if (annotation instanceof Param) {
                    paramName = ((Param)annotation).value();
                    params[i] = TString.toObject(request.getParameter(paramName), parameterTypes[i], true);
                    continue;
                }
                if (annotation instanceof BodyParam) {
                    paramName = ((BodyParam)annotation).value();
                    if (bodyMap == null || !(bodyMap instanceof Map)) continue;
                    params[i] = TString.toObject(bodyMap.get(paramName).toString(), parameterTypes[i], true);
                    continue;
                }
                if (annotation instanceof Head) {
                    String headName = ((Head)annotation).value();
                    params[i] = TString.toObject(request.header().get(headName), parameterTypes[i], true);
                    continue;
                }
                if (annotation instanceof org.voovan.http.server.module.annontationRouter.annotation.Cookie) {
                    String cookieValue = null;
                    String cookieName = ((org.voovan.http.server.module.annontationRouter.annotation.Cookie)annotation).value();
                    Cookie cookie = request.getCookie(cookieName);
                    if (cookie != null) {
                        cookieValue = cookie.getValue();
                    }
                    params[i] = TString.toObject(cookieValue, parameterTypes[i], true);
                    continue;
                }
                if (annotation instanceof Body) {
                    params[i] = TString.toObject(bodyString, parameterTypes[i], true);
                    continue;
                }
                if (!(annotation instanceof Session)) continue;
                String sessionName = ((Session)annotation).value();
                HttpSession httpSession = request.getSession();
                if (httpSession.getAttribute(sessionName).getClass() != parameterTypes[i]) continue;
                params[i] = httpSession.getAttribute(sessionName);
            }
            if (params[i] != null) continue;
            String value = request.getParameter("param" + String.valueOf(i + 1));
            params[i] = TString.toObject(value, parameterTypes[i], true);
        }
        return TReflect.invokeMethod(annotationObj, method, params);
    }

    @Override
    public void process(HttpRequest request, HttpResponse response) throws Exception {
        try {
            String checkResult = this.check(this.method, request);
            if (checkResult != null) {
                response.write(checkResult);
            } else {
                Router router = this.method.getAnnotation(Router.class);
                response.header().put("Content-Type", HttpContentType.getHttpContentType(router.ContentType()));
                Object responseObj = this.invokeRouterMethod(request, response, this.clazz, this.method);
                if (responseObj != null) {
                    if (responseObj instanceof String) {
                        response.write((String)responseObj);
                    } else if (responseObj instanceof byte[]) {
                        response.write((byte[])responseObj);
                    } else {
                        response.header().put("Content-Type", HttpContentType.getHttpContentType(HttpContentType.JSON));
                        response.write(JSON.toJSON(responseObj));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new AnnotationRouterException("Process annotation router error. URL: " + request.protocol().getPath(), e);
        }
    }

    public String check(Method method, HttpRequest httpRequest) throws Exception {
        Check[] methodCheckAnnotations;
        for (Check check : methodCheckAnnotations = (Check[])method.getAnnotationsByType(Check.class)) {
            Class<?> methodClass;
            String[] methodConfig;
            if (check.name().equals("null")) {
                return null;
            }
            Object value = null;
            if (check.Source() == Source.REQ_PARAM) {
                value = httpRequest.getParameters().get(check.name());
            } else if (check.Source() == Source.SESSION_PARAM) {
                value = httpRequest.getSession().getAttribute(check.name());
            }
            if (!check.valueMethod().equals("null") && (methodConfig = check.valueMethod().split("@")).length == 2) {
                methodClass = Class.forName(methodConfig[0]);
                value = TReflect.invokeMethod(methodClass, methodConfig[1], value);
            }
            if (value == null) {
                value = "null";
            }
            if (!check.value().equals(value)) continue;
            if (check.responseMethod().equals("null")) {
                return check.response();
            }
            methodConfig = check.responseMethod().split("#");
            if (methodConfig.length != 2) continue;
            methodClass = Class.forName(methodConfig[0]);
            return JSON.toJSON(TReflect.invokeMethod(methodClass, methodConfig[1], value));
        }
        return null;
    }
}

