/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.server.filter;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.voovan.http.server.HttpFilter;
import org.voovan.http.server.HttpRequest;
import org.voovan.http.server.HttpResponse;
import org.voovan.http.server.context.HttpFilterConfig;
import org.voovan.tools.bucket.Bucket;
import org.voovan.tools.bucket.LeakBucket;
import org.voovan.tools.bucket.TokenBucket;
import org.voovan.tools.collection.CachedHashMap;
import org.voovan.tools.collection.MultiMap;
import org.voovan.tools.log.Logger;
import org.voovan.tools.reflect.TReflect;

public class RateLimiterFilter
implements HttpFilter {
    private static MultiMap<String, Limiter> LIMITER_DEFINE_MAP = new MultiMap();
    private static Function<Limiter, Object> bucketRelease = limiter -> {
        limiter.getBucket().release();
        return null;
    };
    private static CachedHashMap<String, Limiter> URL_LIMITER_MAP = new CachedHashMap((Integer)10000).autoRemove(true).interval(1).destory(bucketRelease).create();
    private static CachedHashMap<String, Limiter> IP_LIMITER_MAP = new CachedHashMap((Integer)10000).autoRemove(true).interval(1).destory(bucketRelease).create();
    private static CachedHashMap<String, Limiter> HEADER_LIMITER_MAP = new CachedHashMap((Integer)10000).autoRemove(true).interval(1).destory(bucketRelease).create();
    private static CachedHashMap<String, Limiter> SESSION_LIMITER_MAP = new CachedHashMap((Integer)10000).autoRemove(true).interval(1).destory(bucketRelease).create();
    private AtomicBoolean isInit = new AtomicBoolean(false);

    @Override
    public Object onRequest(HttpFilterConfig httpFilterConfig, HttpRequest httpRequest, HttpResponse httpResponse, Object o) {
        List<Limiter> ipLimiterList;
        List<Limiter> urlLimiterList;
        String requestPath;
        Limiter urlLimiter;
        List limiterMapList = (List)httpFilterConfig.getParameter("limiter");
        if (this.isInit.compareAndSet(false, true)) {
            try {
                for (Map limiterMap : limiterMapList) {
                    Limiter limiter = (Limiter)TReflect.getObjectFromMap(Limiter.class, limiterMap, true);
                    LIMITER_DEFINE_MAP.putValue(limiter.type.toUpperCase(), limiter);
                }
            }
            catch (Exception e) {
                Logger.error("TokenBucketFilter error: ", e);
            }
        }
        if ((urlLimiter = (Limiter)URL_LIMITER_MAP.get(requestPath = httpRequest.protocol().getPath())) == null && (urlLimiterList = LIMITER_DEFINE_MAP.getValues("URL")) != null) {
            for (Limiter limiterDefine : LIMITER_DEFINE_MAP.getValues("URL")) {
                if (!limiterDefine.getValue().equals(requestPath)) continue;
                urlLimiter = limiterDefine.newInstance();
                URL_LIMITER_MAP.put(urlLimiter.getValue(), urlLimiter);
            }
        }
        if (this.dealLimiter(urlLimiter, httpResponse)) {
            return null;
        }
        String ipAddress = httpRequest.getRemoteAddres();
        Limiter ipLimiter = (Limiter)IP_LIMITER_MAP.get(ipAddress);
        if (ipLimiter == null && (ipLimiterList = LIMITER_DEFINE_MAP.getValues("IP")) != null) {
            for (Limiter limiter : LIMITER_DEFINE_MAP.getValues("IP")) {
                if (!limiter.getValue().equals(ipAddress)) continue;
                ipLimiter = limiter.newInstance();
                IP_LIMITER_MAP.put(ipLimiter.getValue(), ipLimiter);
            }
        }
        if (this.dealLimiter(ipLimiter, httpResponse)) {
            return null;
        }
        Limiter headerLimiter = null;
        List<Limiter> headerLimiterList = LIMITER_DEFINE_MAP.getValues("HEADER");
        if (headerLimiterList != null) {
            for (Limiter limiterDefine : LIMITER_DEFINE_MAP.getValues("HEADER")) {
                String headerValue = httpRequest.header().get(limiterDefine.getValue());
                if (headerValue == null) continue;
                headerLimiter = (Limiter)HEADER_LIMITER_MAP.get(headerValue);
                if (headerLimiter != null) {
                    if (!this.dealLimiter(headerLimiter, httpResponse)) continue;
                    return null;
                }
                headerLimiter = limiterDefine.newInstance();
                HEADER_LIMITER_MAP.put(headerValue, headerLimiter);
            }
        }
        Object var12_16 = null;
        List<Limiter> sessionLimiterList = LIMITER_DEFINE_MAP.getValues("SESSION");
        if (sessionLimiterList != null) {
            for (Limiter limiterDefine : LIMITER_DEFINE_MAP.getValues("SESSION")) {
                String sessionValue = httpRequest.getSession().getAttribute(limiterDefine.getValue()).toString();
                if (sessionValue == null) continue;
                Limiter limiter = (Limiter)SESSION_LIMITER_MAP.get(sessionValue);
                if (limiter != null) {
                    if (!this.dealLimiter(limiter, httpResponse)) continue;
                    return null;
                }
                Limiter limiter2 = limiterDefine.newInstance();
                SESSION_LIMITER_MAP.put(sessionValue, limiter2);
            }
        }
        return true;
    }

    public boolean dealLimiter(Limiter limiter, HttpResponse httpResponse) {
        if (limiter != null) {
            if (limiter.getBucket().acquire()) {
                return false;
            }
            httpResponse.write(limiter.getResponse());
            return true;
        }
        return false;
    }

    @Override
    public Object onResponse(HttpFilterConfig httpFilterConfig, HttpRequest httpRequest, HttpResponse httpResponse, Object o) {
        return true;
    }

    public class Limiter {
        private String value;
        private String type;
        private String response;
        private int limitSize;
        private int interval;
        private String bucketType;
        private Bucket bucket;

        private Limiter() {
        }

        public Limiter init() {
            this.bucket = "LEAK".equalsIgnoreCase(this.bucketType) ? new LeakBucket(this.limitSize, this.interval) : new TokenBucket(this.limitSize, this.interval);
            return this;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getResponse() {
            return this.response;
        }

        public void setResponse(String response) {
            this.response = response;
        }

        public int getLimitSize() {
            return this.limitSize;
        }

        public void setLimitSize(int limitSize) {
            this.limitSize = limitSize;
        }

        public int getInterval() {
            return this.interval;
        }

        public void setInterval(int interval) {
            this.interval = interval;
        }

        public Bucket getBucket() {
            return this.bucket;
        }

        public void setBucket(Bucket bucket) {
            this.bucket = bucket;
        }

        public String getBucketType() {
            return this.bucketType;
        }

        public void setBucketType(String bucketType) {
            this.bucketType = bucketType;
        }

        public Limiter newInstance() {
            Limiter limiter = new Limiter();
            limiter.setLimitSize(this.getLimitSize());
            limiter.setInterval(this.interval);
            limiter.setResponse(this.response);
            limiter.setType(this.type);
            limiter.setValue(this.value);
            limiter.setBucketType(this.bucketType);
            return limiter.init();
        }
    }
}

