/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.server.filter;

import org.voovan.http.server.HttpFilter;
import org.voovan.http.server.HttpRequest;
import org.voovan.http.server.HttpResponse;
import org.voovan.http.server.context.HttpFilterConfig;
import org.voovan.tools.TString;

public class CrossOriginFilter
implements HttpFilter {
    @Override
    public Object onRequest(HttpFilterConfig filterConfig, HttpRequest request, HttpResponse response, Object prevFilterResult) {
        return true;
    }

    @Override
    public Object onResponse(HttpFilterConfig filterConfig, HttpRequest request, HttpResponse response, Object prevFilterResult) {
        String functionParamName;
        String functionName;
        if (filterConfig.getParameters().containsKey("allowOrigin")) {
            String allowOrigin = filterConfig.getParameter("allowOrigin").toString();
            if ("*".equals(allowOrigin)) {
                allowOrigin = request.header().get("Origin");
            }
            response.header().put("Access-Control-Allow-Origin", allowOrigin);
            response.header().put("Access-Control-Allow-Methods", (String)filterConfig.getParameter("allowMethods"));
            response.header().put("Access-Control-Allow-Headers", (String)filterConfig.getParameter("allowHeaders"));
            response.header().put("Access-Control-Allow-Credentials", "true");
        }
        if (filterConfig.getParameters().containsKey("functionParamName") && (functionName = request.getParameter(functionParamName = (String)filterConfig.getParameter("functionParamName"))) != null) {
            String jsonpResponse = TString.assembly(functionName, "(", response.body().getBodyString(), ")");
            response.body().clear();
            response.body().write(jsonpResponse.getBytes());
        }
        return true;
    }
}

