/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.server.context;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.voovan.Global;
import org.voovan.http.server.context.HttpFilterConfig;
import org.voovan.http.server.context.HttpModuleConfig;
import org.voovan.http.server.context.HttpRouterConfig;
import org.voovan.http.server.context.HttpsConfig;
import org.voovan.tools.TObject;
import org.voovan.tools.collection.Chain;
import org.voovan.tools.log.Logger;
import org.voovan.tools.reflect.TReflect;

public class WebServerConfig {
    private String serverName;
    private String host = "0.0.0.0";
    private int port = 28080;
    private int readTimeout = 30;
    private int sendTimeout = 30;
    private String contextPath = "WEBAPP";
    private boolean MatchRouteIgnoreCase = false;
    private String characterSet = "UTF-8";
    private String responseCharacterSet = "";
    private String sessionContainer = "org.voovan.tools.collection.CachedHashMap";
    private int sessionTimeout = 30;
    private int keepAliveTimeout = 60;
    private boolean accessLog = false;
    private boolean gzip = true;
    private int gzipMinSize = 2048;
    private List<String> gzipMimeType = TObject.asList("text/html", "text/xml", "text/javascript", "application/javascript", "text/css", "text/plain", "text/json", "application/json");
    private HttpsConfig https;
    private String indexFiles = "index.htm,index.html,default.htm,default.htm";
    private int hotSwapInterval = 0;
    private String lifeCycleClass = null;
    private String pauseURL = null;
    private String scanAopPackage = null;
    private int maxRequestSize = 1024;
    private boolean cache = true;
    private Chain<HttpFilterConfig> filterConfigs = new Chain();
    private List<HttpRouterConfig> routerConfigs = new Vector<HttpRouterConfig>();
    private List<HttpModuleConfig> moduleConfigs = new Vector<HttpModuleConfig>();

    public String getServerName() {
        if (this.serverName == null) {
            this.serverName = Global.NAME;
        }
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setSendTimeout(int sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public boolean isMatchRouteIgnoreCase() {
        return this.MatchRouteIgnoreCase;
    }

    public void setMatchRouteIgnoreCase(boolean matchRouteIgnoreCase) {
        this.MatchRouteIgnoreCase = matchRouteIgnoreCase;
    }

    public void setCharacterSet(String characterSet) {
        this.characterSet = characterSet;
        this.responseCharacterSet = ";charset=" + characterSet;
    }

    public String getResponseCharacterSet() {
        return this.responseCharacterSet;
    }

    public void setSessionContainer(String sessionContainer) {
        this.sessionContainer = sessionContainer;
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getSendTimeout() {
        return this.sendTimeout;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public String getSessionContainer() {
        return this.sessionContainer;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public boolean isGzip() {
        return this.gzip;
    }

    public void setGzip(boolean gzip) {
        this.gzip = gzip;
    }

    public int getGzipMinSize() {
        return this.gzipMinSize;
    }

    public void setGzipMinSize(int gzipMinSize) {
        this.gzipMinSize = gzipMinSize;
    }

    public List<String> getGzipMimeType() {
        return this.gzipMimeType;
    }

    public boolean isAccessLog() {
        return this.accessLog;
    }

    public void setAccessLog(boolean accessLog) {
        this.accessLog = accessLog;
    }

    public HttpsConfig getHttps() {
        return this.https;
    }

    public boolean isHttps() {
        return this.https != null;
    }

    public void setHttps(HttpsConfig https) {
        this.https = https;
    }

    public String[] getIndexFiles() {
        return this.indexFiles.split(",");
    }

    public void setIndexFiles(String indexFiles) {
        this.indexFiles = indexFiles;
    }

    public int getHotSwapInterval() {
        return this.hotSwapInterval;
    }

    public void setHotSwapInterval(int hotSwapInterval) {
        this.hotSwapInterval = hotSwapInterval;
    }

    public String getLifeCycleClass() {
        return this.lifeCycleClass;
    }

    public void setLifeCycleClassClass(String lifeCycleClass) {
        this.lifeCycleClass = lifeCycleClass;
    }

    public String getPauseURL() {
        return this.pauseURL;
    }

    public void setPauseURL(String pauseURL) {
        this.pauseURL = pauseURL;
    }

    public boolean isCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public Chain<HttpFilterConfig> getFilterConfigs() {
        return this.filterConfigs;
    }

    public List<HttpRouterConfig> getRouterConfigs() {
        return this.routerConfigs;
    }

    public List<HttpModuleConfig> getModuleonfigs() {
        return this.moduleConfigs;
    }

    public String getScanAopPackage() {
        return this.scanAopPackage;
    }

    public int getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public void setMaxRequestSize(int maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
    }

    public void addFilterByList(List<Map<String, Object>> filterInfoList) {
        for (Map<String, Object> filterConfigMap : filterInfoList) {
            HttpFilterConfig httpFilterConfig = new HttpFilterConfig(filterConfigMap);
            this.filterConfigs.add(httpFilterConfig);
            Logger.simple("Load HttpFilter [" + httpFilterConfig.getName() + "] by [" + httpFilterConfig.getClassName() + "]");
            this.filterConfigs.rewind();
        }
    }

    public void addRouterByList(List<Map<String, Object>> routerInfoList) {
        for (Map<String, Object> routerInfoMap : routerInfoList) {
            HttpRouterConfig httpRouterConfig = new HttpRouterConfig(routerInfoMap);
            this.routerConfigs.add(httpRouterConfig);
            Logger.simple("Load HttpRouter [" + httpRouterConfig.getName() + "] by Method [" + httpRouterConfig.getMethod() + "] on route [" + httpRouterConfig.getRoute() + "] by [" + httpRouterConfig.getClassName() + "]");
        }
    }

    public void addModuleByList(List<Map<String, Object>> moduleInfoList) {
        for (Map<String, Object> moduleInfoMap : moduleInfoList) {
            HttpModuleConfig httpModuleConfig = new HttpModuleConfig(moduleInfoMap);
            this.moduleConfigs.add(httpModuleConfig);
            Logger.simple("Load HttpModule [" + httpModuleConfig.getName() + "] on [" + httpModuleConfig.getPath() + "] by [" + httpModuleConfig.getClassName() + "]");
        }
    }

    public String toString() {
        try {
            Map<Field, Object> fieldValues = TReflect.getFieldValues(this);
            StringBuilder str = new StringBuilder();
            for (Map.Entry<Field, Object> entry : fieldValues.entrySet()) {
                str.append(entry.getKey().getName());
                str.append(":\t\t");
                str.append(entry.getValue());
                str.append("\r\n");
            }
            return str.toString();
        }
        catch (ReflectiveOperationException e) {
            Logger.error(e);
            return "ReflectiveOperationException error by TReflect.getFieldValues Method. ";
        }
    }
}

