/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.server.context;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.voovan.Global;
import org.voovan.http.client.HttpClient;
import org.voovan.http.message.Response;
import org.voovan.http.server.HttpRequest;
import org.voovan.http.server.HttpResponse;
import org.voovan.http.server.WebServer;
import org.voovan.http.server.context.WebServerConfig;
import org.voovan.tools.TDateTime;
import org.voovan.tools.TEnv;
import org.voovan.tools.TFile;
import org.voovan.tools.TObject;
import org.voovan.tools.TString;
import org.voovan.tools.hashwheeltimer.HashWheelTask;
import org.voovan.tools.json.JSONDecode;
import org.voovan.tools.log.Logger;
import org.voovan.tools.log.SingleLogger;
import org.voovan.tools.reflect.TReflect;

public class WebContext {
    public static String AUTH_TOKEN = TString.generateShortUUID();
    public static boolean PAUSE = false;
    public static final String FRAMEWORK_NAME = "Voovan";
    public static final String FULL_VERSION = "Voovan v" + Global.getVersion();
    public static final String VERSION = "v" + Global.getVersion();
    private static final String SESSION_NAME = "VOOVAN_SESSIONID";
    public static byte[] RESPONSE_COMMON_HEADER = ("Date: " + TDateTime.formatToGMT(new Date()) + "\r\nServer: " + "Voovan" + "\r\n\r\n").getBytes();
    private static Map<String, Object> WEB_CONFIG;
    private static Map<String, Object> MIME_TYPES;
    private static Map<String, Object> ERROR_DEFINE;
    private static final String ACCESS_LOG_FILE_NAME;
    private static WebServerConfig webServerConfig;

    private WebContext() {
    }

    public static boolean isCache() {
        if (webServerConfig != null) {
            return webServerConfig.isCache();
        }
        return false;
    }

    private static Map<String, Object> loadJsonFromFile(File configFile) {
        if (configFile.exists()) {
            String fileContent = null;
            try {
                fileContent = new String(TFile.loadFile(configFile), "UTF-8");
                Map<String, Object> configObject = WebContext.loadJsonFromJSON(fileContent);
                return configObject;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return new HashMap<String, Object>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadWebConfig() {
        Map<String, Object> map = WEB_CONFIG;
        synchronized (map) {
            WEB_CONFIG = WebContext.loadJsonFromFile(new File(TFile.getSystemPath("/conf/web.json")));
        }
        map = MIME_TYPES;
        synchronized (map) {
            MIME_TYPES = WebContext.loadJsonFromFile(new File(TFile.getSystemPath("/conf/mime.json")));
        }
        map = ERROR_DEFINE;
        synchronized (map) {
            ERROR_DEFINE = WebContext.loadJsonFromFile(new File(TFile.getSystemPath("/conf/error.json")));
        }
    }

    private static Map<String, Object> loadJsonFromJSON(String json) {
        if (json != null) {
            Object configObject = JSONDecode.parse(json);
            return (Map)configObject;
        }
        return new HashMap<String, Object>();
    }

    public static WebServerConfig buildConfigFromMap(Map<String, Object> configMap) {
        if (configMap.size() > 0) {
            WEB_CONFIG = configMap;
        }
        webServerConfig = new WebServerConfig();
        try {
            webServerConfig = (WebServerConfig)TReflect.getObjectFromMap(WebServerConfig.class, configMap, true);
            webServerConfig = TObject.nullDefault(webServerConfig, new WebServerConfig());
        }
        catch (ReflectiveOperationException e) {
            Logger.error(e);
        }
        catch (ParseException e) {
            Logger.error(e);
        }
        if (!webServerConfig.getContextPath().startsWith(File.separator)) {
            webServerConfig.setContextPath(System.getProperty("user.dir") + File.separator + webServerConfig.getContextPath());
        }
        if (webServerConfig.getContextPath().endsWith(File.separator)) {
            webServerConfig.setContextPath(TString.removeSuffix(webServerConfig.getContextPath()));
        }
        return webServerConfig;
    }

    public static WebServerConfig buildConfigFromFile(String configFilePath) {
        String configFileFullPath = TFile.getContextPath() + File.separator + configFilePath;
        File configFile = new File(configFileFullPath);
        if (configFile.exists()) {
            return WebContext.buildConfigFromMap(WebContext.loadJsonFromFile(configFile));
        }
        Logger.warn("Use the config file: " + configFilePath + " is not exists, now use default config.");
        return null;
    }

    public static WebServerConfig buildConfigFromJSON(String json) {
        return WebContext.buildConfigFromMap(WebContext.loadJsonFromJSON(json));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebServerConfig buildConfigFromRemote(String httpUrl) {
        try (HttpClient httpClient = null;){
            URL url = new URL(httpUrl);
            httpClient = new HttpClient(url.getProtocol() + "://" + url.getHost() + ":" + url.getPort());
            Response response = httpClient.send(url.getPath());
            if (response.protocol().getStatus() == 200) {
                WebServerConfig webServerConfig = WebContext.buildConfigFromJSON(response.body().getBodyString());
                return webServerConfig;
            }
            try {
                throw new IOException("Get the config url: \" + args[i] + \" error");
            }
            catch (Exception e) {
                Logger.error("Use the config url: " + httpUrl + " error", e);
            }
        }
        return null;
    }

    public static void initWebServerPluginConfig(boolean isInit) {
        if (!isInit) {
            webServerConfig.getFilterConfigs().clear();
        }
        webServerConfig.addFilterByList(WebContext.getContextParameter("Filters", new ArrayList()));
        if (!isInit) {
            webServerConfig.getRouterConfigs().clear();
        }
        webServerConfig.addRouterByList(WebContext.getContextParameter("Routers", new ArrayList()));
        if (!isInit) {
            webServerConfig.getModuleonfigs().clear();
        }
        webServerConfig.addModuleByList(WebContext.getContextParameter("Modules", new ArrayList()));
        Logger.simple("==================================================================================================================================================");
    }

    public static WebServerConfig getWebServerConfig() {
        return webServerConfig;
    }

    public static void logo() {
        System.out.println("==================================================================================================================================================");
        System.out.println("");
        System.out.println("       *************************************  ****        ****  ************   ***********   ****        ****     ****       ***********     ");
        System.out.println("       *************************************   *****      **** **************  *************  *****      ****     ******    **************   ");
        System.out.println("       ***************      ****************   *****      **** **************  ************** *****      ****    ********   ***************  ");
        System.out.println("       **********                ***********   *****     ****  **************  ************** *****     ****    *********   ***************  ");
        System.out.println("       *********                  **********   *****     **** *************** *************** *****     ****   **********   ***************  ");
        System.out.println("       *******     ***********      ********   *****     **** *************** ***************  ****     ****  ***********   ***************  ");
        System.out.println("       ******    ***************    ********    ****     **** *************** ***************  *****    ****  ***********   ***************  ");
        System.out.println("       *****    *****************    *******    *****    ****  *****     ****  ****      ****  *****    ****  ****** ****    *****     ****  ");
        System.out.println("       *****    *******************   ******     ****   ****   ****      ****  *****     ****  *****    ****  ***********    ****      ****  ");
        System.out.println("       **********        ********     ******     ****   ****   ****      ****  ****      ****   ****   ****   *****  ****    ****      ****  ");
        System.out.println("       *********       ********            *     ****  ****    ****      ****  ****      ****   ****   ****   *****  ****    ****     ****   ");
        System.out.println("       *             ***********************     ****  ****    ****      ****  ****     ****    ****  ****    *****  ****    ****     ****   ");
        System.out.println("       ****    *******************   *******     ****  ****    ****     ****   ****     ****    ****  ****    *****  ****   ****      ****   ");
        System.out.println("       *************************     *******     ****  ****    ****     ****   ****     ****    ****  ****    ****   ****   ****      ****   ");
        System.out.println("       *****     **************     ********     ***** ****   ****      ****  ****      ****    **** ****    *****   ****   ****      ****   ");
        System.out.println("       ******     ************      ********     *********    ****      ****  ****      ****    **** ****    ************   ****      ****   ");
        System.out.println("       *******      ********       *********     **** ****    *************** **************    **** ****    ************   ****     *****   ");
        System.out.println("       ********                  ***********     *********    **************  **************    *********    ************   ****     *****   ");
        System.out.println("       **********              *************     ********     **************  **************    *********    ************   ****     *****   ");
        System.out.println("       **************      *****************     ********     *************   *************     ********     *****   ****   ****     *****   ");
        System.out.println("       *************************************      *******     *************   *************      ******     *****     **** ****      *****   ");
        System.out.println("       *************************************      *******      ***********     ***********        ****     *****      **** ****      *****   ");
        System.out.println("");
        System.out.println("==================================================================================================================================================");
    }

    public static void welcome() {
        WebServerConfig config = webServerConfig;
        System.out.println("========================================================= [Config file parameter list] ===========================================================");
        System.out.println(TString.rightPad("  ReadTimeout:", 35, ' ') + config.getReadTimeout());
        System.out.println(TString.rightPad("  SendTimeout:", 35, ' ') + config.getSendTimeout());
        System.out.println(TString.rightPad("  ContextPath:", 35, ' ') + config.getContextPath());
        System.out.println(TString.rightPad("  CharacterSet: ", 35, ' ') + config.getCharacterSet());
        System.out.println(TString.rightPad("  SessionContainer:", 35, ' ') + config.getSessionContainer());
        System.out.println(TString.rightPad("  SessionTimeout:", 35, ' ') + config.getSessionTimeout());
        System.out.println(TString.rightPad("  KeepAliveTimeout:", 35, ' ') + config.getKeepAliveTimeout());
        System.out.println(TString.rightPad("  MatchRouteIgnoreCase:", 35, ' ') + config.isMatchRouteIgnoreCase());
        System.out.println(TString.rightPad("  Gzip:", 35, ' ') + config.isGzip());
        System.out.println(TString.rightPad("  GzipMinSize:", 35, ' ') + config.getGzipMinSize());
        System.out.println(TString.rightPad("  GzipMimeType:", 35, ' ') + config.getGzipMimeType());
        System.out.println(TString.rightPad("  AccessLog:", 35, ' ') + config.isAccessLog());
        System.out.println(TString.rightPad("  Cache:", 35, ' ') + config.isCache());
        System.out.println(TString.rightPad("  PauseURL:", 35, ' ') + config.getPauseURL());
        System.out.println(TString.rightPad("  MaxRequestSize:", 35, ' ') + config.getMaxRequestSize());
        if (config.getHotSwapInterval() > 0) {
            System.out.println(TString.rightPad("  HotSwapInterval:", 35, ' ') + config.getHotSwapInterval());
        }
        if (config.getScanAopPackage() != null) {
            System.out.println(TString.rightPad("  ScanAopPackage:", 35, ' ') + config.getScanAopPackage());
        }
        if (config.isHttps()) {
            System.out.println(TString.rightPad("  CertificateFile:", 35, ' ') + config.getHttps().getCertificateFile());
            System.out.println(TString.rightPad("  CertificatePassword:", 35, ' ') + config.getHttps().getCertificatePassword());
            System.out.println(TString.rightPad("  KeyPassword:", 35, ' ') + config.getHttps().getKeyPassword());
        }
        System.out.println(TString.rightPad("  AuthToken:", 35, ' ') + AUTH_TOKEN);
        System.out.println("==================================================================================================================================================");
        System.out.println("  This WebServer based on VoovanFramework.");
        System.out.println("  Version: " + VERSION);
        System.out.println("  WebSite: http://www.voovan.org");
        System.out.println("  Author: helyho");
        System.out.println("  E-mail: helyho@gmail.com");
        System.out.println("==================================================================================================================================================");
    }

    public static void getAuthToken() {
        File tokenFile = new File("logs/.token");
        if (tokenFile.exists()) {
            AUTH_TOKEN = new String(TFile.loadFile(tokenFile));
        } else {
            try {
                TFile.writeFile(tokenFile, false, AUTH_TOKEN.getBytes());
            }
            catch (IOException e) {
                Logger.error("Write token to file: " + tokenFile.getPath() + " error", e);
            }
        }
    }

    private static String genAccessLog(HttpRequest request, HttpResponse response) {
        StringBuilder content = new StringBuilder();
        content.append("[" + TDateTime.now() + "]");
        content.append(" " + TString.rightPad(request.getRemoteAddres(), 15, ' '));
        content.append(" " + TString.rightPad(request.getRemotePort() + "", 5, ' '));
        content.append(" " + request.protocol().getProtocol() + "/" + request.protocol().getVersion() + " " + TString.rightPad(request.protocol().getMethod(), 6, ' '));
        content.append(" " + response.protocol().getStatus());
        content.append(" " + response.body().size());
        content.append("\t " + request.protocol().getPath());
        content.append("\t " + TObject.nullDefault(request.header().get("User-Agent"), ""));
        content.append("\t " + TObject.nullDefault(request.header().get("Referer"), ""));
        content.append("\r\n");
        return content.toString();
    }

    public static void writeAccessLog(WebServerConfig webServerConfig, HttpRequest request, HttpResponse response) {
        if (webServerConfig.isAccessLog() && !request.protocol().getPath().contains("/VoovanMonitor/")) {
            SingleLogger.writeLog(ACCESS_LOG_FILE_NAME, WebContext.genAccessLog(request, response));
        }
    }

    public static <T> T getContextParameter(String name, T defaultValue) {
        return (T)TObject.nullDefault(WEB_CONFIG.get(name), defaultValue);
    }

    public static Map<String, Object> getMimeDefine() {
        byte[] mimeDefBytes = TFile.loadResource(TEnv.classToResource(WebServer.class).replaceAll("WebServer.class", "conf/mime.json"));
        ConcurrentHashMap<String, Object> mimeDefMap = new ConcurrentHashMap<String, Object>();
        try {
            Map systemMimeDef = (Map)JSONDecode.parse(new String(mimeDefBytes, "UTF-8"));
            mimeDefMap.putAll(systemMimeDef);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        mimeDefMap.putAll(MIME_TYPES);
        return mimeDefMap;
    }

    public static Map<String, Object> getErrorDefine() {
        return ERROR_DEFINE;
    }

    public static String getSessionName() {
        return SESSION_NAME;
    }

    public static String getDefaultErrorPage() {
        return "RequestMethod: {{RequestMethod}} <hr/>StatusCode: {{StatusCode}} <hr/>RequestPath: {{RequestPath}} <hr/>ErrorMessage: {{ErrorMessage}} <hr/>Version: {{Version}} <hr/>Description: <br>{{Description}} <hr/>";
    }

    static {
        Global.getHashWheelTimer().addTask(new HashWheelTask(){

            @Override
            public void run() {
                RESPONSE_COMMON_HEADER = ("Date: " + TDateTime.formatToGMT(new Date()) + "\r\nServer: " + WebContext.FRAMEWORK_NAME + "\r\n\r\n").getBytes();
            }
        }, 1);
        WEB_CONFIG = new HashMap<String, Object>();
        MIME_TYPES = new HashMap<String, Object>();
        ERROR_DEFINE = new HashMap<String, Object>();
        WebContext.loadWebConfig();
        ACCESS_LOG_FILE_NAME = TFile.getContextPath() + File.separator + "logs" + File.separator + "access.log";
        webServerConfig = WebContext.buildConfigFromMap(WEB_CONFIG);
    }
}

