/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.server.context;

import java.util.Map;
import org.voovan.http.server.HttpRouter;
import org.voovan.http.websocket.WebSocketRouter;
import org.voovan.tools.TObject;
import org.voovan.tools.log.Logger;
import org.voovan.tools.reflect.TReflect;

public class HttpRouterConfig {
    private String name;
    private String route;
    private String className;
    private String method;
    private HttpRouter httpRouter;
    private WebSocketRouter webSocketRouter;

    public HttpRouterConfig(Map<String, Object> configMap) {
        for (Map.Entry<String, Object> entry : configMap.entrySet()) {
            if ("Name".equalsIgnoreCase(entry.getKey())) {
                this.name = (String)entry.getValue();
                continue;
            }
            if ("Route".equalsIgnoreCase(entry.getKey())) {
                this.route = (String)entry.getValue();
                continue;
            }
            if ("ClassName".equalsIgnoreCase(entry.getKey())) {
                this.className = (String)entry.getValue();
                continue;
            }
            if (!"Method".equalsIgnoreCase(entry.getKey())) continue;
            this.method = (String)entry.getValue();
        }
    }

    public HttpRouterConfig() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRoute() {
        return TObject.nullDefault(this.route, "/");
    }

    public void setRoute(String route) {
        this.route = route;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public HttpRouter getHttpRouterInstance() {
        try {
            if (this.httpRouter == null) {
                this.httpRouter = (HttpRouter)TReflect.newInstance(this.className, new Object[0]);
            }
            return this.httpRouter;
        }
        catch (ReflectiveOperationException e) {
            Logger.error("[ERROR] New HttpRouter [" + this.className + "] error.");
            e.printStackTrace();
            return null;
        }
    }

    public WebSocketRouter getWebSocketRouterInstance() {
        try {
            if (this.webSocketRouter == null) {
                this.webSocketRouter = (WebSocketRouter)TReflect.newInstance(this.className, new Object[0]);
            }
            return this.webSocketRouter;
        }
        catch (ReflectiveOperationException e) {
            Logger.error("[ERROR] New HttpRouter [" + this.className + "] error.");
            e.printStackTrace();
            return null;
        }
    }
}

