/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.server.context;

import java.util.HashMap;
import java.util.Map;
import org.voovan.http.server.HttpModule;
import org.voovan.http.server.WebServer;
import org.voovan.tools.TObject;
import org.voovan.tools.log.Logger;
import org.voovan.tools.reflect.TReflect;

public class HttpModuleConfig {
    private String name;
    private String path;
    private String className;
    private Map<String, Object> paramters = new HashMap<String, Object>();
    private String lifeCycleClass = null;
    private HttpModule httpModule;

    public HttpModuleConfig(Map<String, Object> configMap) {
        for (Map.Entry<String, Object> entry : configMap.entrySet()) {
            if ("Name".equalsIgnoreCase(entry.getKey())) {
                this.name = (String)entry.getValue();
                continue;
            }
            if ("Path".equalsIgnoreCase(entry.getKey())) {
                this.path = (String)entry.getValue();
                continue;
            }
            if ("ClassName".equalsIgnoreCase(entry.getKey())) {
                this.className = (String)entry.getValue();
                continue;
            }
            if ("LifeCycleClass".equalsIgnoreCase(entry.getKey())) {
                this.lifeCycleClass = (String)entry.getValue();
                continue;
            }
            this.paramters.put(entry.getKey(), entry.getValue());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return TObject.nullDefault(this.path, "/");
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Map<String, Object> getParameters() {
        return this.paramters;
    }

    public Object getParameter(String name) {
        return this.paramters.get(name);
    }

    public String getLifeCycleClass() {
        return this.lifeCycleClass;
    }

    public void setLifeCycleClass(String lifeCycleClass) {
        this.lifeCycleClass = lifeCycleClass;
    }

    public HttpModule getHttpModuleInstance(WebServer webServer) {
        try {
            if (this.httpModule == null) {
                this.httpModule = (HttpModule)TReflect.newInstance(this.className, new Object[0]);
                this.httpModule.init(webServer, this);
            }
            return this.httpModule;
        }
        catch (ReflectiveOperationException e) {
            Logger.error("[ERROR] New HttpModule [" + this.className + "] error.");
            e.printStackTrace();
            return null;
        }
    }
}

