/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.server.context;

import java.util.HashMap;
import java.util.Map;
import org.voovan.http.server.HttpFilter;
import org.voovan.tools.log.Logger;
import org.voovan.tools.reflect.TReflect;

public class HttpFilterConfig {
    private String name;
    private String className;
    private Map<String, Object> paramters = new HashMap<String, Object>();
    private HttpFilter httpFilter;

    public HttpFilterConfig(Map<String, Object> configMap) {
        for (Map.Entry<String, Object> entry : configMap.entrySet()) {
            if ("Name".equalsIgnoreCase(entry.getKey())) {
                this.name = (String)entry.getValue();
                continue;
            }
            if ("ClassName".equalsIgnoreCase(entry.getKey())) {
                this.className = (String)entry.getValue();
                continue;
            }
            this.paramters.put(entry.getKey(), entry.getValue());
        }
    }

    public HttpFilterConfig(String name, String className, Map<String, Object> parameters) {
        this.name = name;
        this.className = className;
        if (parameters != null) {
            this.paramters = parameters;
        }
    }

    public HttpFilterConfig() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Map<String, Object> getParameters() {
        return this.paramters;
    }

    public Object getParameter(String name) {
        return this.paramters.get(name);
    }

    public HttpFilter getHttpFilterInstance() {
        try {
            if (this.httpFilter == null) {
                this.httpFilter = (HttpFilter)TReflect.newInstance(this.className, new Object[0]);
            }
            return this.httpFilter;
        }
        catch (ReflectiveOperationException e) {
            Logger.error("[ERROR] New HttpFilter [" + this.className + "] error.");
            e.printStackTrace();
            return null;
        }
    }

    public static HttpFilterConfig newInstance(String name, String className, Map<String, Object> parameters) {
        return new HttpFilterConfig(name, className, parameters);
    }

    public static HttpFilterConfig newInstance(String name, Class clazz, Map<String, Object> parameters) {
        return new HttpFilterConfig(name, clazz.getCanonicalName(), parameters);
    }
}

