/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.server;

import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.voovan.Global;
import org.voovan.http.HttpRequestType;
import org.voovan.http.HttpSessionParam;
import org.voovan.http.server.HttpDispatcher;
import org.voovan.http.server.HttpRequest;
import org.voovan.http.server.HttpSession;
import org.voovan.http.server.SessionManager;
import org.voovan.http.server.WebServerHandler;
import org.voovan.http.server.context.WebServerConfig;
import org.voovan.http.server.exception.RouterNotFound;
import org.voovan.http.websocket.WebSocketFrame;
import org.voovan.http.websocket.WebSocketRouter;
import org.voovan.http.websocket.WebSocketSession;
import org.voovan.http.websocket.WebSocketType;
import org.voovan.http.websocket.exception.WebSocketFilterException;
import org.voovan.network.IoSession;
import org.voovan.network.SocketContext;
import org.voovan.network.exception.SendMessageException;
import org.voovan.tools.TEnv;
import org.voovan.tools.TObject;
import org.voovan.tools.log.Logger;
import org.voovan.tools.reflect.annotation.NotSerialization;

public class WebSocketDispatcher {
    private WebServerConfig webConfig;
    private SessionManager sessionManager;
    @NotSerialization
    private Map<IoSession, WebSocketSession> webSocketSessions;
    private Map<String, WebSocketRouter> routers;

    public WebSocketDispatcher(WebServerConfig webConfig, SessionManager sessionManager) {
        this.webConfig = webConfig;
        this.sessionManager = sessionManager;
        this.webSocketSessions = new ConcurrentHashMap<IoSession, WebSocketSession>();
        this.routers = new TreeMap<String, WebSocketRouter>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.length() > o2.length()) {
                    return -1;
                }
                if (o1.length() < o2.length()) {
                    return 1;
                }
                if (o1.equals(o2)) {
                    return 0;
                }
                return 1;
            }
        });
    }

    public Map<String, WebSocketRouter> getRouters() {
        return this.routers;
    }

    public void addRouteHandler(String routeRegexPath, WebSocketRouter handler) {
        routeRegexPath = HttpDispatcher.fixRoutePath(routeRegexPath);
        this.routers.put(routeRegexPath, handler);
    }

    public List<Object> findRouter(HttpRequest request) {
        String requestPath = request.protocol().getPath();
        for (Map.Entry<String, WebSocketRouter> routeEntry : this.routers.entrySet()) {
            String routePath = routeEntry.getKey();
            if (!HttpDispatcher.matchPath(requestPath, routePath, this.webConfig.isMatchRouteIgnoreCase())) continue;
            return TObject.asList(routePath, routeEntry.getValue());
        }
        return null;
    }

    public WebSocketFrame process(WebSocketEvent event, IoSession session, HttpRequest request, ByteBuffer byteBuffer) {
        List<Object> routerInfo = this.findRouter(request);
        if (routerInfo != null) {
            WebSocketRouter webSocketRouter = (WebSocketRouter)routerInfo.get(1);
            WebSocketSession webSocketSession = this.disposeSession(request, webSocketRouter);
            ByteBuffer responseMessage = null;
            try {
                Object result = byteBuffer;
                if (event == WebSocketEvent.OPEN) {
                    result = webSocketRouter.onOpen(webSocketSession);
                    responseMessage = (ByteBuffer)webSocketRouter.filterEncoder(webSocketSession, result);
                } else if (event == WebSocketEvent.RECIVED) {
                    result = webSocketRouter.filterDecoder(webSocketSession, result);
                    result = webSocketRouter.onRecived(webSocketSession, result);
                    responseMessage = (ByteBuffer)webSocketRouter.filterEncoder(webSocketSession, result);
                }
                if (responseMessage != null) {
                    return WebSocketFrame.newInstance(true, WebSocketFrame.Opcode.TEXT, false, responseMessage);
                }
                if (event == WebSocketEvent.SENT) {
                    result = webSocketRouter.filterDecoder(webSocketSession, byteBuffer);
                    webSocketRouter.onSent(webSocketSession, result);
                } else if (event == WebSocketEvent.CLOSE) {
                    webSocketRouter.onClose(webSocketSession);
                    this.webSocketSessions.remove(session);
                } else {
                    IoSession poneSession;
                    if (event == WebSocketEvent.PING) {
                        return WebSocketFrame.newInstance(true, WebSocketFrame.Opcode.PONG, false, byteBuffer);
                    }
                    if (event == WebSocketEvent.PONG && (poneSession = session).isConnected()) {
                        Global.getThreadPool().execute(new Runnable(){

                            @Override
                            public void run() {
                                TEnv.sleep(((SocketContext)poneSession.socketContext()).getReadTimeout() / 3);
                                try {
                                    poneSession.syncSend(WebSocketFrame.newInstance(true, WebSocketFrame.Opcode.PING, false, null));
                                }
                                catch (SendMessageException e) {
                                    poneSession.close();
                                    Logger.error("Send WebSocket ping error", e);
                                }
                            }
                        });
                    }
                }
            }
            catch (WebSocketFilterException e) {
                Logger.error(e);
            }
        } else {
            new RouterNotFound("Not avaliable router!").printStackTrace();
        }
        return null;
    }

    public WebSocketSession disposeSession(HttpRequest request, WebSocketRouter webSocketRouter) {
        request.setSessionManager(this.sessionManager);
        HttpSession httpSession = request.getSession();
        IoSession socketSession = request.getSocketSession();
        if (!this.webSocketSessions.containsKey(socketSession)) {
            WebSocketSession webSocketSession = new WebSocketSession(httpSession.getSocketSession(), webSocketRouter, WebSocketType.SERVER);
            this.webSocketSessions.put(socketSession, webSocketSession);
            return webSocketSession;
        }
        return this.webSocketSessions.get(socketSession);
    }

    public WebSocketFrame fireOpenEvent(IoSession session, HttpRequest request) {
        return this.process(WebSocketEvent.OPEN, session, request, null);
    }

    public WebSocketFrame fireReceivedEvent(IoSession session, HttpRequest request, ByteBuffer byteBuffer) {
        return this.process(WebSocketEvent.RECIVED, session, request, byteBuffer);
    }

    public void fireSentEvent(IoSession session, HttpRequest request, ByteBuffer byteBuffer) {
        this.process(WebSocketEvent.SENT, session, request, byteBuffer);
    }

    public void fireCloseEvent(IoSession session) {
        if (HttpRequestType.WEBSOCKET.equals(WebServerHandler.getAttribute(session, HttpSessionParam.TYPE))) {
            this.process(WebSocketEvent.CLOSE, session, (HttpRequest)WebServerHandler.getAttribute(session, HttpSessionParam.HTTP_REQUEST), null);
        }
    }

    public WebSocketFrame firePingEvent(IoSession session, HttpRequest request, ByteBuffer byteBuffer) {
        return this.process(WebSocketEvent.PING, session, request, byteBuffer);
    }

    public void firePoneEvent(IoSession session, HttpRequest request, ByteBuffer byteBuffer) {
        this.process(WebSocketEvent.PONG, session, request, byteBuffer);
    }

    public static enum WebSocketEvent {
        OPEN,
        RECIVED,
        SENT,
        CLOSE,
        PING,
        PONG;

    }
}

