/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.server;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.TimeoutException;
import org.voovan.Global;
import org.voovan.http.HttpRequestType;
import org.voovan.http.HttpSessionParam;
import org.voovan.http.message.HttpParser;
import org.voovan.http.message.Request;
import org.voovan.http.server.HttpDispatcher;
import org.voovan.http.server.HttpRequest;
import org.voovan.http.server.HttpResponse;
import org.voovan.http.server.WebSocketDispatcher;
import org.voovan.http.server.context.WebContext;
import org.voovan.http.server.context.WebServerConfig;
import org.voovan.http.server.exception.RouterNotFound;
import org.voovan.http.websocket.WebSocketFrame;
import org.voovan.http.websocket.WebSocketTools;
import org.voovan.network.IoHandler;
import org.voovan.network.IoSession;
import org.voovan.network.SocketContext;
import org.voovan.network.exception.SendMessageException;
import org.voovan.tools.FastThreadLocal;
import org.voovan.tools.buffer.ByteBufferChannel;
import org.voovan.tools.exception.MemoryReleasedException;
import org.voovan.tools.hashwheeltimer.HashWheelTask;
import org.voovan.tools.log.Logger;

public class WebServerHandler
implements IoHandler {
    private static FastThreadLocal<HttpRequest> THREAD_HTTP_REQUEST = new FastThreadLocal();
    private static FastThreadLocal<HttpResponse> THREAD_HTTP_RESPONSE = new FastThreadLocal();
    private HttpDispatcher httpDispatcher;
    private WebSocketDispatcher webSocketDispatcher;
    private WebServerConfig webConfig;
    private List<IoSession> keepAliveSessionList;
    private static String upgradeStatusCode = "Switching Protocols";

    public WebServerHandler(WebServerConfig webConfig, HttpDispatcher httpDispatcher, WebSocketDispatcher webSocketDispatcher) {
        this.httpDispatcher = httpDispatcher;
        this.webSocketDispatcher = webSocketDispatcher;
        this.webConfig = webConfig;
        this.keepAliveSessionList = new Vector<IoSession>();
        this.initKeepAliveTimer();
    }

    public static <T> T getAttribute(IoSession session, int sessionParam) {
        return (T)session.getAttribute(sessionParam);
    }

    public static <T> void setAttribute(IoSession session, int sessionParam, T value) {
        session.setAttribute(sessionParam, value);
    }

    public void initKeepAliveTimer() {
        Global.getHashWheelTimer().addTask(new HashWheelTask(){

            @Override
            public void run() {
                long currentTimeValue = System.currentTimeMillis();
                for (int i = 0; i < WebServerHandler.this.keepAliveSessionList.size(); ++i) {
                    long timeoutValue;
                    IoSession session = (IoSession)WebServerHandler.this.keepAliveSessionList.get(i);
                    if (session == null || (timeoutValue = ((Long)WebServerHandler.getAttribute(session, HttpSessionParam.KEEP_ALIVE_TIMEOUT)).longValue()) >= currentTimeValue) continue;
                    session.close();
                    WebServerHandler.this.keepAliveSessionList.remove(session);
                    --i;
                }
            }
        }, 1);
    }

    @Override
    public Object onConnect(IoSession session) {
        return null;
    }

    @Override
    public void onDisconnect(IoSession session) {
        if (HttpRequestType.WEBSOCKET.equals(WebServerHandler.getAttribute(session, HttpSessionParam.TYPE))) {
            this.webSocketDispatcher.fireCloseEvent(session);
            ByteBufferChannel byteBufferChannel = (ByteBufferChannel)session.getAttribute("WebSocketByteBufferChannel");
            if (byteBufferChannel != null && !byteBufferChannel.isReleased()) {
                byteBufferChannel.release();
            }
        }
        this.keepAliveSessionList.remove(session);
    }

    public void checkPause(IoSession session, Request request) {
        if (WebContext.PAUSE && !request.protocol().getMethod().equals("ADMIN") && !request.protocol().getMethod().equals("MONITOR")) {
            if (this.webConfig.getPauseURL() != null) {
                request.protocol().setPath(this.webConfig.getPauseURL());
            } else {
                session.close();
            }
        }
    }

    private void resetThreadLocal() {
        HttpParser.resetThreadLocal();
        THREAD_HTTP_REQUEST.set(null);
        THREAD_HTTP_RESPONSE.set(null);
    }

    @Override
    public Object onReceive(IoSession session, Object obj) {
        String defaultCharacterSet = this.webConfig.getCharacterSet();
        if (obj instanceof Request) {
            Request request = (Request)obj;
            this.checkPause(session, request);
            if (!session.isConnected()) {
                return null;
            }
            HttpRequest httpRequest = THREAD_HTTP_REQUEST.get();
            if (httpRequest == null) {
                httpRequest = new HttpRequest(request, defaultCharacterSet, session);
                THREAD_HTTP_REQUEST.set(httpRequest);
            } else {
                httpRequest.init(request, defaultCharacterSet, session);
            }
            HttpResponse httpResponse = THREAD_HTTP_RESPONSE.get();
            if (httpResponse == null) {
                httpResponse = new HttpResponse(defaultCharacterSet, session);
                THREAD_HTTP_RESPONSE.set(httpResponse);
            } else {
                httpResponse.init(defaultCharacterSet, session);
            }
            WebServerHandler.setAttribute(session, HttpSessionParam.HTTP_REQUEST, httpRequest);
            WebServerHandler.setAttribute(session, HttpSessionParam.HTTP_RESPONSE, httpResponse);
            if (WebSocketTools.isWebSocketUpgrade(request)) {
                return this.disposeUpgrade(session, httpRequest, httpResponse);
            }
            return this.disposeHttp(session, httpRequest, httpResponse);
        }
        if (obj instanceof WebSocketFrame) {
            return this.disposeWebSocket(session, (WebSocketFrame)obj);
        }
        session.close();
        return null;
    }

    public HttpResponse disposeHttp(IoSession session, HttpRequest httpRequest, HttpResponse httpResponse) {
        int bodyMark;
        Long requestMark;
        if (httpRequest.protocol().getVersion().endsWith("1.1")) {
            WebServerHandler.setAttribute(session, HttpSessionParam.KEEP_ALIVE, true);
        } else if (httpRequest.header().contain("Connection")) {
            if (httpRequest.header().get("Connection").toLowerCase().contains("keep-alive")) {
                WebServerHandler.setAttribute(session, HttpSessionParam.KEEP_ALIVE, true);
                httpResponse.header().put("Connection", httpRequest.header().get("Connection"));
            }
            if (httpRequest.header().get("Connection").toLowerCase().contains("close")) {
                WebServerHandler.setAttribute(session, HttpSessionParam.KEEP_ALIVE, false);
                httpResponse.header().remove("Connection");
            }
        }
        if (this.webConfig.isGzip() && httpRequest.header().contain("Accept-Encoding") && httpRequest.header().get("Accept-Encoding").contains("gzip") && httpResponse.header().get("Content-Type") != null && httpResponse.body().size() > (long)this.webConfig.getGzipMinSize()) {
            for (String gzipMimeType : this.webConfig.getGzipMimeType()) {
                if (!httpResponse.header().get("Content-Type").contains(gzipMimeType)) continue;
                httpResponse.setCompress(true);
            }
        }
        this.httpDispatcher.process(httpRequest, httpResponse);
        if (WebContext.isCache() && (requestMark = Long.valueOf(httpRequest.getMark())) != null && (bodyMark = httpResponse.body().getMark().intValue()) != 0) {
            httpResponse.setMark(requestMark << 32 >> 32 | (long)bodyMark);
        }
        return httpResponse;
    }

    public HttpResponse disposeUpgrade(IoSession session, HttpRequest httpRequest, HttpResponse httpResponse) {
        if (this.webSocketDispatcher.findRouter(httpRequest) != null) {
            WebServerHandler.setAttribute(session, HttpSessionParam.TYPE, HttpRequestType.UPGRADE);
            httpResponse.protocol().setStatus(101);
            httpResponse.protocol().setStatusCode(upgradeStatusCode);
            httpResponse.header().put("Connection", "Upgrade");
            if (httpRequest.header() != null && "websocket".equals(httpRequest.header().get("Upgrade"))) {
                httpResponse.header().put("Upgrade", "websocket");
                String webSocketKey = WebSocketTools.generateSecKey(httpRequest.header().get("Sec-WebSocket-Key"));
                httpResponse.header().put("Sec-WebSocket-Accept", webSocketKey);
            } else if (httpRequest.header() != null && "h2c".equals(httpRequest.header().get("Upgrade"))) {
                httpResponse.header().put("Upgrade", "h2c");
            }
        } else {
            this.httpDispatcher.exceptionMessage(httpRequest, httpResponse, new RouterNotFound("Not avaliable router!"));
        }
        this.resetThreadLocal();
        return httpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized WebSocketFrame disposeWebSocket(IoSession session, WebSocketFrame webSocketFrame) {
        ByteBufferChannel byteBufferChannel = null;
        if (!session.containAttribute("WebSocketByteBufferChannel")) {
            byteBufferChannel = new ByteBufferChannel(((SocketContext)session.socketContext()).getReadBufferSize());
            session.setAttribute("WebSocketByteBufferChannel", byteBufferChannel);
        } else {
            byteBufferChannel = (ByteBufferChannel)session.getAttribute("WebSocketByteBufferChannel");
        }
        HttpRequest reqWebSocket = (HttpRequest)WebServerHandler.getAttribute(session, HttpSessionParam.HTTP_REQUEST);
        if (webSocketFrame.getOpcode() == WebSocketFrame.Opcode.CLOSING) {
            return WebSocketFrame.newInstance(true, WebSocketFrame.Opcode.CLOSING, false, webSocketFrame.getFrameData());
        }
        if (webSocketFrame.getOpcode() == WebSocketFrame.Opcode.PING) {
            return this.webSocketDispatcher.firePingEvent(session, reqWebSocket, webSocketFrame.getFrameData());
        }
        if (webSocketFrame.getOpcode() == WebSocketFrame.Opcode.PONG) {
            this.refreshTimeout(session);
            this.webSocketDispatcher.firePoneEvent(session, reqWebSocket, webSocketFrame.getFrameData());
            return null;
        }
        if (webSocketFrame.getOpcode() == WebSocketFrame.Opcode.CONTINUOUS) {
            byteBufferChannel.writeEnd(webSocketFrame.getFrameData());
        } else if (webSocketFrame.getOpcode() == WebSocketFrame.Opcode.TEXT || webSocketFrame.getOpcode() == WebSocketFrame.Opcode.BINARY) {
            byteBufferChannel.writeEnd(webSocketFrame.getFrameData());
            WebSocketFrame respWebSocketFrame = null;
            if (webSocketFrame.getErrorCode() == 0) {
                try {
                    respWebSocketFrame = this.webSocketDispatcher.fireReceivedEvent(session, reqWebSocket, byteBufferChannel.getByteBuffer());
                }
                finally {
                    byteBufferChannel.compact();
                    byteBufferChannel.clear();
                }
            } else {
                respWebSocketFrame = WebSocketFrame.newInstance(true, WebSocketFrame.Opcode.CLOSING, false, ByteBuffer.wrap(WebSocketTools.intToByteArray(webSocketFrame.getErrorCode(), 2)));
            }
            return respWebSocketFrame;
        }
        return null;
    }

    private void refreshTimeout(IoSession session) {
        int keepAliveTimeout = this.webConfig.getKeepAliveTimeout();
        long timeoutValue = System.currentTimeMillis() + (long)(keepAliveTimeout * 1000);
        WebServerHandler.setAttribute(session, HttpSessionParam.KEEP_ALIVE_TIMEOUT, timeoutValue);
    }

    @Override
    public void onSent(final IoSession session, Object obj) {
        WebSocketFrame webSocketFrame;
        HttpRequest request = (HttpRequest)WebServerHandler.getAttribute(session, HttpSessionParam.HTTP_REQUEST);
        if (obj instanceof WebSocketFrame) {
            webSocketFrame = (WebSocketFrame)obj;
            if (webSocketFrame.getOpcode() == WebSocketFrame.Opcode.CLOSING) {
                session.close();
            } else if (webSocketFrame.getOpcode() != WebSocketFrame.Opcode.PING && webSocketFrame.getOpcode() != WebSocketFrame.Opcode.PONG) {
                this.webSocketDispatcher.fireSentEvent(session, request, webSocketFrame.getFrameData());
            }
        }
        if (HttpRequestType.UPGRADE.equals(WebServerHandler.getAttribute(session, HttpSessionParam.TYPE))) {
            WebServerHandler.setAttribute(session, HttpSessionParam.TYPE, HttpRequestType.WEBSOCKET);
            WebServerHandler.setAttribute(session, HttpSessionParam.KEEP_ALIVE, true);
            webSocketFrame = this.webSocketDispatcher.fireOpenEvent(session, request);
            if (webSocketFrame != null) {
                try {
                    session.syncSend(webSocketFrame);
                }
                catch (SendMessageException e) {
                    session.close();
                    Logger.error("WebSocket Open event writeToChannel frame error", e);
                }
            }
            Global.getHashWheelTimer().addTask(new HashWheelTask(){

                @Override
                public void run() {
                    try {
                        WebSocketFrame ping = WebSocketFrame.newInstance(true, WebSocketFrame.Opcode.PING, false, null);
                        session.send(ping.toByteBuffer());
                    }
                    catch (Exception e) {
                        session.close();
                        Logger.error("WebSocket writeToChannel Ping frame error", e);
                    }
                    finally {
                        this.cancel();
                    }
                }
            }, ((SocketContext)session.socketContext()).getReadTimeout() / 3 / 1000);
        }
    }

    @Override
    public void onFlush(IoSession session) {
        HttpRequest request = (HttpRequest)WebServerHandler.getAttribute(session, HttpSessionParam.HTTP_REQUEST);
        if (WebServerHandler.getAttribute(session, HttpSessionParam.KEEP_ALIVE) != null && ((Boolean)WebServerHandler.getAttribute(session, HttpSessionParam.KEEP_ALIVE)).booleanValue() && this.webConfig.getKeepAliveTimeout() > 0) {
            if (Boolean.valueOf(false).equals(WebServerHandler.getAttribute(session, HttpSessionParam.KEEP_ALIVE_LIST_CONTAIN))) {
                this.keepAliveSessionList.add(session);
                WebServerHandler.setAttribute(session, HttpSessionParam.KEEP_ALIVE_LIST_CONTAIN, true);
            }
            this.refreshTimeout(session);
        } else {
            this.keepAliveSessionList.remove(session);
            session.close();
        }
        request.release();
    }

    @Override
    public void onException(IoSession session, Exception e) {
        if (!(e instanceof MemoryReleasedException)) {
            Logger.error("Http Server Error", e);
        }
        if (e instanceof TimeoutException) {
            session.close();
        }
    }

    @Override
    public void onIdle(IoSession session) {
    }
}

