/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentSkipListMap;
import org.voovan.Global;
import org.voovan.http.HttpRequestType;
import org.voovan.http.HttpSessionParam;
import org.voovan.http.message.HttpParser;
import org.voovan.http.message.Request;
import org.voovan.http.message.Response;
import org.voovan.http.server.HttpResponse;
import org.voovan.http.server.WebServerHandler;
import org.voovan.http.server.context.WebContext;
import org.voovan.http.server.exception.RequestTooLarge;
import org.voovan.http.websocket.WebSocketFrame;
import org.voovan.network.IoFilter;
import org.voovan.network.IoSession;
import org.voovan.network.SocketContext;
import org.voovan.tools.buffer.ByteBufferChannel;
import org.voovan.tools.hashwheeltimer.HashWheelTask;
import org.voovan.tools.log.Logger;

public class WebServerFilter
implements IoFilter {
    public static ConcurrentSkipListMap<Long, byte[]> RESPONSE_CACHE = new ConcurrentSkipListMap();

    @Override
    public Object encode(IoSession session, Object object) {
        session.enabledMessageSpliter(true);
        if (object instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)object;
            try {
                if (httpResponse.isAutoSend()) {
                    if (WebContext.isCache()) {
                        Long mark = httpResponse.getMark();
                        byte[] cacheBytes = RESPONSE_CACHE.get(mark);
                        if (cacheBytes == null) {
                            ByteBufferChannel sendByteBufferChannel = session.getSendByteBufferChannel();
                            int size = sendByteBufferChannel.size();
                            httpResponse.send();
                            if (size == 0) {
                                cacheBytes = new byte[session.getSendByteBufferChannel().size()];
                                sendByteBufferChannel.get(cacheBytes);
                                RESPONSE_CACHE.putIfAbsent(mark, cacheBytes);
                            }
                        } else {
                            session.sendByBuffer(ByteBuffer.wrap(cacheBytes));
                            httpResponse.clear();
                        }
                    } else {
                        httpResponse.send();
                    }
                }
            }
            catch (Exception e) {
                Logger.error(e);
            }
            return null;
        }
        if (object instanceof WebSocketFrame) {
            WebSocketFrame webSocketFrame = (WebSocketFrame)object;
            return webSocketFrame.toByteBuffer();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object decode(IoSession session, Object object) {
        if (!session.isConnected()) {
            return null;
        }
        ByteBuffer byteBuffer = (ByteBuffer)object;
        ByteBufferChannel byteBufferChannel = null;
        if (byteBuffer.limit() == 0) {
            session.enabledMessageSpliter(false);
            byteBufferChannel = session.getReadByteBufferChannel();
        }
        if (HttpRequestType.HTTP.equals(WebServerHandler.getAttribute(session, HttpSessionParam.TYPE))) {
            Request request = null;
            try {
                if (!(object instanceof ByteBuffer)) return null;
                request = HttpParser.parseRequest(session, byteBufferChannel, ((SocketContext)session.socketContext()).getReadTimeout(), WebContext.getWebServerConfig().getMaxRequestSize());
                if (request != null) {
                    return request;
                }
                session.close();
                return null;
            }
            catch (IOException e) {
                Response response = new Response();
                response.protocol().setStatus(500);
                if (e instanceof RequestTooLarge) {
                    response.protocol().setStatus(413);
                    response.body().write("false");
                }
                try {
                    response.send(session);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                Logger.error("ParseRequest failed", e);
                return null;
            }
        }
        if (HttpRequestType.WEBSOCKET.equals(WebServerHandler.getAttribute(session, HttpSessionParam.TYPE))) {
            if (!(object instanceof ByteBuffer) || byteBuffer.limit() == 0) return null;
            WebSocketFrame webSocketFrame = WebSocketFrame.parse(byteBuffer);
            if (webSocketFrame.getErrorCode() == 0) {
                return webSocketFrame;
            }
            session.close();
            return null;
        } else {
            session.close();
        }
        return null;
    }

    static {
        Global.getHashWheelTimer().addTask(new HashWheelTask(){

            @Override
            public void run() {
                RESPONSE_CACHE.clear();
            }
        }, 1);
    }
}

