/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.server;

import java.io.File;
import java.io.IOException;
import java.nio.channels.ShutdownChannelGroupException;
import java.util.Map;
import org.voovan.Global;
import org.voovan.http.server.HttpDispatcher;
import org.voovan.http.server.HttpModule;
import org.voovan.http.server.HttpRequest;
import org.voovan.http.server.HttpResponse;
import org.voovan.http.server.HttpRouter;
import org.voovan.http.server.SessionManager;
import org.voovan.http.server.WebServerFilter;
import org.voovan.http.server.WebServerHandler;
import org.voovan.http.server.WebServerLifeCycle;
import org.voovan.http.server.WebSocketDispatcher;
import org.voovan.http.server.context.HttpModuleConfig;
import org.voovan.http.server.context.HttpRouterConfig;
import org.voovan.http.server.context.WebContext;
import org.voovan.http.server.context.WebServerConfig;
import org.voovan.http.server.router.OptionsRouter;
import org.voovan.http.websocket.WebSocketRouter;
import org.voovan.network.SSLManager;
import org.voovan.network.SocketContext;
import org.voovan.network.messagesplitter.HttpMessageSplitter;
import org.voovan.network.tcp.TcpServerSocket;
import org.voovan.tools.TDateTime;
import org.voovan.tools.TEnv;
import org.voovan.tools.TFile;
import org.voovan.tools.TPerformance;
import org.voovan.tools.TString;
import org.voovan.tools.aop.Aop;
import org.voovan.tools.hotswap.Hotswaper;
import org.voovan.tools.json.JSON;
import org.voovan.tools.log.Logger;
import org.voovan.tools.reflect.TReflect;

public class WebServer {
    private SocketContext serverSocket;
    private HttpDispatcher httpDispatcher;
    private WebSocketDispatcher webSocketDispatcher;
    private SessionManager sessionManager;
    private WebServerConfig config;

    public WebServer(WebServerConfig config) {
        this.config = config;
        this.initAop();
        this.initHotSwap();
        this.initWebServer(config);
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    private void initHotSwap() {
        if (this.config.getHotSwapInterval() > 0) {
            try {
                Hotswaper hotSwaper = new Hotswaper();
                hotSwaper.autoReload(this.config.getHotSwapInterval());
            }
            catch (Exception e) {
                Logger.error("Init hotswap failed: " + e.getMessage());
            }
        }
    }

    private void initAop() {
        if (this.config.getScanAopPackage() != null) {
            try {
                Aop.init(this.config.getScanAopPackage());
            }
            catch (Exception e) {
                Logger.error("Init aop failed: " + e.getMessage());
            }
        }
    }

    private void initWebServer(WebServerConfig config) {
        this.sessionManager = SessionManager.newInstance(config);
        this.httpDispatcher = new HttpDispatcher(config, this.sessionManager);
        this.webSocketDispatcher = new WebSocketDispatcher(config, this.sessionManager);
    }

    private void initSocketServer(WebServerConfig config) throws IOException {
        this.serverSocket = new TcpServerSocket(config.getHost(), config.getPort(), config.getReadTimeout() * 1000, config.getSendTimeout() * 1000, 0);
        this.serverSocket.setReadRecursionDepth(16);
        if (config.isHttps()) {
            SSLManager sslManager = new SSLManager("TLS", false);
            sslManager.loadCertificate(System.getProperty("user.dir") + config.getHttps().getCertificateFile(), config.getHttps().getCertificatePassword(), config.getHttps().getKeyPassword());
            this.serverSocket.setSSLManager(sslManager);
        }
        this.serverSocket.handler(new WebServerHandler(config, this.httpDispatcher, this.webSocketDispatcher));
        this.serverSocket.filterChain().add(new WebServerFilter());
        this.serverSocket.messageSplitter(new HttpMessageSplitter());
    }

    private void initRouter() {
        for (HttpRouterConfig httpRouterConfig : this.config.getRouterConfigs()) {
            String method = httpRouterConfig.getMethod();
            String route = httpRouterConfig.getRoute();
            String className = httpRouterConfig.getClassName();
            if (!method.equals("WEBSOCKET")) {
                this.otherMethod(method, route, httpRouterConfig.getHttpRouterInstance());
                continue;
            }
            this.socket(route, httpRouterConfig.getWebSocketRouterInstance());
        }
    }

    public void initModule() {
        for (HttpModuleConfig httpModuleConfig : this.config.getModuleonfigs()) {
            HttpModule httpModule = httpModuleConfig.getHttpModuleInstance(this);
            if (httpModule == null) continue;
            httpModule.runModuleInit();
            httpModule.install();
        }
    }

    public void unInitModule() {
        for (HttpModuleConfig moduleConfig : this.config.getModuleonfigs().toArray(new HttpModuleConfig[0])) {
            HttpModule httpModule = moduleConfig.getHttpModuleInstance(this);
            httpModule.runModuleDestory();
            httpModule.unInstall();
            Logger.simple("[SYSTEM] Module [" + moduleConfig.getName() + "] uninstall");
        }
    }

    public WebServerConfig getWebServerConfig() {
        return this.config;
    }

    public WebServer get(String routeRegexPath, HttpRouter router) {
        this.httpDispatcher.addRouteHandler("GET", routeRegexPath, router);
        return this;
    }

    public WebServer post(String routeRegexPath, HttpRouter router) {
        this.httpDispatcher.addRouteHandler("POST", routeRegexPath, router);
        return this;
    }

    public WebServer getAndPost(String routeRegexPath, HttpRouter router) {
        this.get(routeRegexPath, router);
        this.post(routeRegexPath, router);
        return this;
    }

    public WebServer head(String routeRegexPath, HttpRouter router) {
        this.httpDispatcher.addRouteHandler("HEAD", routeRegexPath, router);
        return this;
    }

    public WebServer put(String routeRegexPath, HttpRouter router) {
        this.httpDispatcher.addRouteHandler("PUT", routeRegexPath, router);
        return this;
    }

    public WebServer delete(String routeRegexPath, HttpRouter router) {
        this.httpDispatcher.addRouteHandler("DELETE", routeRegexPath, router);
        return this;
    }

    public WebServer trace(String routeRegexPath, HttpRouter router) {
        this.httpDispatcher.addRouteHandler("TRACE", routeRegexPath, router);
        return this;
    }

    public WebServer connect(String routeRegexPath, HttpRouter router) {
        this.httpDispatcher.addRouteHandler("CONNECT", routeRegexPath, router);
        return this;
    }

    public WebServer options(String routeRegexPath, HttpRouter router) {
        this.httpDispatcher.addRouteHandler("OPTIONS", routeRegexPath, router);
        return this;
    }

    public WebServer otherMethod(String method, String routeRegexPath, HttpRouter router) {
        this.httpDispatcher.addRouteMethod(method);
        this.httpDispatcher.addRouteHandler(method, routeRegexPath, router);
        return this;
    }

    public WebServer socket(String routeRegexPath, WebSocketRouter router) {
        this.webSocketDispatcher.addRouteHandler(routeRegexPath, router);
        return this;
    }

    public static WebServer newInstance(WebServerConfig config) {
        if (config != null) {
            return new WebServer(config);
        }
        Logger.error("Create WebServer failed: WebServerConfig object is null.");
        return null;
    }

    public static WebServer newInstance(String json) {
        if (json != null) {
            return new WebServer(WebContext.buildConfigFromJSON(json));
        }
        Logger.error("Create WebServer failed: WebServerConfig object is null.");
        return null;
    }

    public static WebServer newInstance(File configFile) {
        try {
            if (configFile != null && configFile.exists()) {
                return new WebServer(WebContext.buildConfigFromFile(configFile.getCanonicalPath()));
            }
            Logger.error("Create WebServer failed: WebServerConfig object is null.");
        }
        catch (IOException e) {
            Logger.error("Create WebServer failed", e);
        }
        return null;
    }

    public static WebServer newInstance(int port) {
        WebServerConfig config = WebContext.getWebServerConfig();
        config.setPort(port);
        return WebServer.newInstance(config);
    }

    public static WebServer newInstance() {
        return WebServer.newInstance(WebContext.getWebServerConfig());
    }

    private void commonServe() throws IOException {
        WebContext.getAuthToken();
        WebContext.logo();
        this.runWebInit(this);
        WebContext.initWebServerPluginConfig(true);
        this.initRouter();
        this.initModule();
        this.InitManagerRouter();
        this.initSocketServer(this.config);
        WebContext.welcome();
        Long pid = TEnv.getCurrentPID();
        System.out.println("Pid: \t" + pid.toString());
        File pidFile = new File("logs/.pid");
        try {
            TFile.writeFile(pidFile, false, pid.toString().getBytes());
        }
        catch (IOException e) {
            Logger.error("Write pid to file: " + pidFile.getPath() + " error", e);
        }
        String serviceUrl = "http" + (this.config.isHttps() ? "s" : "") + "://" + (this.config.getHost().equals("0.0.0.0") ? "127.0.0.1" : this.config.getHost()) + ":" + this.config.getPort();
        System.out.println("Listen: " + serviceUrl);
        System.out.println("Time: \t" + TDateTime.now());
    }

    public void reload(String reloadInfoJson) {
        WebContext.PAUSE = true;
        this.unInitModule();
        WebServerConfig config = null;
        Map reloadInfo = (Map)JSON.parse(reloadInfoJson);
        if ("FILE".equals(reloadInfo.get("Type"))) {
            config = WebContext.buildConfigFromFile(reloadInfo.get("Content").toString());
        }
        if ("HTTP".equals(reloadInfo.get("Type"))) {
            config = WebContext.buildConfigFromRemote(reloadInfo.get("Content").toString());
        }
        if ("JSON".equals(reloadInfo.get("Type"))) {
            config = WebContext.buildConfigFromJSON(reloadInfo.get("Content").toString());
        }
        this.config = config;
        this.httpDispatcher = new HttpDispatcher(config, this.sessionManager);
        this.webSocketDispatcher = new WebSocketDispatcher(config, this.sessionManager);
        this.serverSocket.handler(new WebServerHandler(config, this.httpDispatcher, this.webSocketDispatcher));
        WebContext.welcome();
        WebContext.initWebServerPluginConfig(false);
        this.initRouter();
        this.initModule();
        this.InitManagerRouter();
        WebContext.PAUSE = false;
    }

    private void runWebInit(WebServer webServer) {
        String lifeCycleClass = WebContext.getWebServerConfig().getLifeCycleClass();
        if (lifeCycleClass == null) {
            Logger.info("None WebServer lifeCycle class to load.");
            return;
        }
        if (lifeCycleClass.isEmpty()) {
            Logger.info("None WebServer lifeCycle class to load.");
            return;
        }
        try {
            WebServerLifeCycle webServerLifeCycle = null;
            Class<?> clazz = Class.forName(lifeCycleClass);
            if (TReflect.isImpByInterface(clazz, WebServerLifeCycle.class)) {
                webServerLifeCycle = (WebServerLifeCycle)TReflect.newInstance(clazz, new Object[0]);
                webServerLifeCycle.init(webServer);
            } else {
                Logger.warn("The WebServer lifeCycle class " + lifeCycleClass + " is not a class implement by " + WebServerLifeCycle.class.getName());
            }
        }
        catch (Exception e) {
            Logger.error("Initialize WebServer lifeCycle class error: " + e);
        }
    }

    private void runWebDestory(WebServer webServer) {
        String lifeCycleClass = WebContext.getWebServerConfig().getLifeCycleClass();
        if (lifeCycleClass == null) {
            Logger.info("None WebServer lifeCycle class to load.");
            return;
        }
        if (lifeCycleClass.isEmpty()) {
            Logger.info("None WebServer lifeCycle class to load.");
            return;
        }
        try {
            WebServerLifeCycle webServerLifeCycle = null;
            Class<?> clazz = Class.forName(lifeCycleClass);
            if (TReflect.isImpByInterface(clazz, WebServerLifeCycle.class)) {
                webServerLifeCycle = (WebServerLifeCycle)TReflect.newInstance(clazz, new Object[0]);
                webServerLifeCycle.destory(webServer);
            } else {
                Logger.warn("The WebServer lifeCycle class " + lifeCycleClass + " is not a class implement by " + WebServerLifeCycle.class.getName());
            }
        }
        catch (Exception e) {
            Logger.error("Initialize WebServer destory lifeCycle error: ", e);
        }
    }

    public static boolean hasAdminRight(HttpRequest request) {
        String authToken;
        if (!TPerformance.getLocalIpAddrs().contains(request.getRemoteAddres())) {
            request.getSession().close();
        }
        return (authToken = request.header().get("AUTH-TOKEN")) != null && authToken.equals(WebContext.AUTH_TOKEN);
    }

    public void InitManagerRouter() {
        final WebServer innerWebServer = this;
        this.otherMethod("ADMIN", "/status", new HttpRouter(){

            @Override
            public void process(HttpRequest request, HttpResponse response) throws Exception {
                String status = "RUNNING";
                if (WebServer.hasAdminRight(request)) {
                    if (WebContext.PAUSE) {
                        status = "PAUSE";
                    }
                    response.write(status);
                } else {
                    request.getSession().close();
                }
            }
        });
        this.otherMethod("ADMIN", "/shutdown", new HttpRouter(){

            @Override
            public void process(HttpRequest request, HttpResponse response) throws Exception {
                if (WebServer.hasAdminRight(request)) {
                    request.getSocketSession().close();
                    innerWebServer.stop();
                    Logger.info("WebServer is stoped");
                } else {
                    request.getSession().close();
                }
            }
        });
        this.otherMethod("ADMIN", "/pause", new HttpRouter(){

            @Override
            public void process(HttpRequest request, HttpResponse response) throws Exception {
                if (WebServer.hasAdminRight(request)) {
                    WebContext.PAUSE = true;
                    response.write("OK");
                    Logger.info("WebServer is paused");
                } else {
                    request.getSession().close();
                }
            }
        });
        this.otherMethod("ADMIN", "/unpause", new HttpRouter(){

            @Override
            public void process(HttpRequest request, HttpResponse response) throws Exception {
                if (WebServer.hasAdminRight(request)) {
                    WebContext.PAUSE = false;
                    response.write("OK");
                    Logger.info("WebServer is running");
                } else {
                    request.getSession().close();
                }
            }
        });
        this.otherMethod("ADMIN", "/pid", new HttpRouter(){

            @Override
            public void process(HttpRequest request, HttpResponse response) throws Exception {
                if (WebServer.hasAdminRight(request)) {
                    response.write(Long.valueOf(TEnv.getCurrentPID()).toString());
                } else {
                    request.getSession().close();
                }
            }
        });
        this.otherMethod("ADMIN", "/reload", new HttpRouter(){

            @Override
            public void process(HttpRequest request, HttpResponse response) throws Exception {
                if (WebServer.hasAdminRight(request)) {
                    WebServer.this.reload(request.body().getBodyString());
                    response.write("OK");
                } else {
                    request.getSession().close();
                }
            }
        });
        this.otherMethod("ADMIN", "/authtoken", new HttpRouter(){

            @Override
            public void process(HttpRequest request, HttpResponse response) throws Exception {
                if (WebServer.hasAdminRight(request)) {
                    if (!request.body().getBodyString().isEmpty()) {
                        WebContext.AUTH_TOKEN = request.body().getBodyString();
                        response.write("OK");
                    } else {
                        response.write("NOTHING");
                    }
                } else {
                    request.getSession().close();
                }
            }
        });
        this.options("/*", new OptionsRouter("ADMIN", "*", "auth-token"));
    }

    public WebServer serve() {
        final WebServer innerWebServer = this;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                innerWebServer.stop();
            }
        });
        try {
            this.commonServe();
            this.serverSocket.start();
        }
        catch (IOException e) {
            Logger.error("Start HTTP server error", e);
            TEnv.sleep(1000);
            System.exit(0);
        }
        return this;
    }

    public WebServer syncServe() {
        try {
            this.commonServe();
            this.serverSocket.syncStart();
        }
        catch (IOException e) {
            Logger.error("Start HTTP server error", e);
        }
        return this;
    }

    public Map<String, Map<String, HttpRouter>> getHttpRouters() {
        return this.httpDispatcher.getRoutes();
    }

    public Map<String, WebSocketRouter> getWebSocketRouters() {
        return this.webSocketDispatcher.getRouters();
    }

    public boolean isServing() {
        return this.serverSocket.isConnected();
    }

    public void pause() {
        WebContext.PAUSE = true;
    }

    public void unPause() {
        WebContext.PAUSE = false;
    }

    public static void main(String[] args) {
        if (TEnv.JDK_VERSION.floatValue() > 8.0f && !"true".equals(System.getProperty("jdk.attach.allowAttachSelf"))) {
            Logger.fremawork("Your are working on: JDK-" + TEnv.JDK_VERSION + ". You should add java command arguments: -Djdk.attach.allowAttachSelf=true --add-exports java.base/java.tcp=ALL-UNNAMED --add-exports java.base/jdk.internal.ref=ALL-UNNAMED");
            System.exit(0);
        }
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("--env") && !args[i].equals("-e")) continue;
            TEnv.setEnvName(args[++i]);
            break;
        }
        WebServerConfig config = WebContext.getWebServerConfig();
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("--config")) {
                    config = WebContext.buildConfigFromFile(args[++i]);
                }
                if (args[i].equals("--remoteConfig")) {
                    config = WebContext.buildConfigFromRemote(args[++i]);
                }
                if (args[i].equals("-h")) {
                    config = config == null ? WebContext.getWebServerConfig() : config;
                    config.setHost(args[++i]);
                }
                if (args[i].equals("-p")) {
                    config = config == null ? WebContext.getWebServerConfig() : config;
                    config.setPort(Integer.parseInt(args[++i]));
                }
                if (args[i].equals("-rto")) {
                    config = config == null ? WebContext.getWebServerConfig() : config;
                    config.setReadTimeout(Integer.parseInt(args[++i]));
                }
                if (args[i].equals("-sto")) {
                    config = config == null ? WebContext.getWebServerConfig() : config;
                    config.setReadTimeout(Integer.parseInt(args[++i]));
                }
                if (args[i].equals("-r")) {
                    config = config == null ? WebContext.getWebServerConfig() : config;
                    config.setContextPath(args[++i]);
                }
                if (args[i].equals("-i")) {
                    config = config == null ? WebContext.getWebServerConfig() : config;
                    config.setIndexFiles(args[++i]);
                }
                if (args[i].equals("-mri")) {
                    config = config == null ? WebContext.getWebServerConfig() : config;
                    config.setMatchRouteIgnoreCase(true);
                }
                if (args[i].equals("--charset")) {
                    config = config == null ? WebContext.getWebServerConfig() : config;
                    config.setCharacterSet(args[++i]);
                }
                if (args[i].equals("--noGzip")) {
                    config = config == null ? WebContext.getWebServerConfig() : config;
                    config.setGzip(false);
                }
                if (args[i].equals("--noAccessLog")) {
                    config = config == null ? WebContext.getWebServerConfig() : config;
                    config.setAccessLog(false);
                }
                if (args[i].equals("--https.CertificateFile")) {
                    config = config == null ? WebContext.getWebServerConfig() : config;
                    config.getHttps().setCertificateFile(args[++i]);
                }
                if (args[i].equals("--https.CertificatePassword")) {
                    config = config == null ? WebContext.getWebServerConfig() : config;
                    config.getHttps().setCertificatePassword(args[++i]);
                }
                if (args[i].equals("--https.KeyPassword")) {
                    config = config == null ? WebContext.getWebServerConfig() : config;
                    config.getHttps().setKeyPassword(args[++i]);
                }
                if (args[i].equals("-v")) {
                    Logger.simple("Version:" + WebContext.VERSION);
                    return;
                }
                if (!args[i].equals("--help") && !args[i].equals("-?")) continue;
                Logger.simple("Usage: java -jar voovan-framework.jar [Options]");
                Logger.simple("");
                Logger.simple("Start voovan webserver");
                Logger.simple("");
                Logger.simple("Options:");
                Logger.simple(TString.rightPad("  -h ", 35, ' ') + "Webserver bind host ip address");
                Logger.simple(TString.rightPad("  -p ", 35, ' ') + "Webserver bind port number");
                Logger.simple(TString.rightPad("  --env ", 35, ' ') + "Webserver environment name");
                Logger.simple(TString.rightPad("  -rto ", 35, ' ') + "Socket readFromChannel timeout");
                Logger.simple(TString.rightPad("  -sto ", 35, ' ') + "Socket writeToChannel timeout");
                Logger.simple(TString.rightPad("  -r ", 35, ' ') + "Context root path, contain webserver static file");
                Logger.simple(TString.rightPad("  -i ", 35, ' ') + "index file for client access to webserver");
                Logger.simple(TString.rightPad("  -mri ", 35, ' ') + "Match route ignore case");
                Logger.simple(TString.rightPad("  --config ", 35, ' ') + " Webserver config file");
                Logger.simple(TString.rightPad("  --remoteConfig ", 35, ' ') + " Remote Webserver config with a HTTP URL address");
                Logger.simple(TString.rightPad("  --charset ", 35, ' ') + "set default charset");
                Logger.simple(TString.rightPad("  --noGzip ", 35, ' ') + "Do not use gzip for client");
                Logger.simple(TString.rightPad("  --noAccessLog ", 35, ' ') + "Do not write access log to access.log");
                Logger.simple(TString.rightPad("  --https.CertificateFile ", 35, ' ') + " Certificate file for https");
                Logger.simple(TString.rightPad("  --https.CertificatePassword ", 35, ' ') + " Certificate passwork for https");
                Logger.simple(TString.rightPad("  --https.KeyPassword ", 35, ' ') + "Certificate key for https");
                Logger.simple(TString.rightPad("  --help, -?", 35, ' ') + "how to use this command");
                Logger.simple(TString.rightPad("  -v ", 35, ' ') + "Show the version information");
                Logger.simple("");
                Logger.simple("This WebServer based on VoovanFramework.");
                Logger.simple("WebSite: http://www.voovan.org");
                Logger.simple("Author: helyho");
                Logger.simple("E-mail: helyho@gmail.com");
                Logger.simple("");
                return;
            }
        }
        WebServer webServer = WebServer.newInstance(config);
        webServer.syncServe();
    }

    public void stop() {
        try {
            System.out.println("=============================================================================================");
            System.out.println("[" + TDateTime.now() + "] Try to stop WebServer....");
            this.unInitModule();
            this.runWebDestory(this);
            this.serverSocket.close();
            System.out.println("[" + TDateTime.now() + "] Socket closed");
            Global.getThreadPool().shutdown();
            System.out.println("[" + TDateTime.now() + "] Thread pool is shutdown.");
            System.out.println("[" + TDateTime.now() + "] Now webServer is fully stoped.");
            TEnv.sleep(1000);
        }
        catch (ShutdownChannelGroupException e) {
            return;
        }
    }
}

