/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.server;

import org.voovan.http.message.packet.Cookie;
import org.voovan.http.server.HttpRequest;
import org.voovan.http.server.HttpSession;
import org.voovan.http.server.context.WebServerConfig;
import org.voovan.tools.collection.CacheMap;
import org.voovan.tools.collection.CachedHashMap;
import org.voovan.tools.json.JSON;
import org.voovan.tools.log.Logger;
import org.voovan.tools.reflect.TReflect;

public class SessionManager {
    private CacheMap<String, Object> httpSessions;
    private WebServerConfig webConfig;

    public SessionManager(WebServerConfig webConfig) {
        this.webConfig = webConfig;
        this.httpSessions = this.getSessionContainer();
        if (this.httpSessions instanceof CachedHashMap) {
            ((CachedHashMap)this.httpSessions).create();
        }
        if (this.httpSessions == null) {
            this.httpSessions = new CachedHashMap<String, Object>();
            Logger.warn("Create session container from config file failed,now use CachedHashMap as defaul session container.");
        }
    }

    public CacheMap<String, Object> getSessionContainer() {
        if (this.httpSessions != null) {
            return this.httpSessions;
        }
        try {
            String sessionContainerClassName = this.webConfig.getSessionContainer();
            return (CacheMap)TReflect.newInstance(sessionContainerClassName, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            Logger.error("SessionManager.getSessionContainer Reflective operation error", e);
            return null;
        }
    }

    public void saveSession(HttpSession session) {
        if (this.httpSessions instanceof CachedHashMap) {
            this.httpSessions.put(session.getId(), session, session.getMaxInactiveInterval());
        } else {
            this.httpSessions.put(session.getId(), JSON.toJSON(session), session.getMaxInactiveInterval());
        }
    }

    public HttpSession getSession(String id) {
        if (id != null && this.httpSessions.containsKey(id)) {
            Object sessionObject = this.httpSessions.getAndRefresh(id);
            HttpSession httpSession = null;
            if (sessionObject instanceof HttpSession) {
                httpSession = (HttpSession)sessionObject;
            }
            if (sessionObject instanceof String) {
                httpSession = (HttpSession)JSON.toObject((String)sessionObject, HttpSession.class);
            }
            return httpSession;
        }
        return null;
    }

    public HttpSession getSession(Cookie cookie) {
        if (cookie != null && this.httpSessions.containsKey(cookie.getValue())) {
            return this.getSession(cookie.getValue());
        }
        return null;
    }

    public boolean containsSession(Cookie cookie) {
        if (cookie == null) {
            return false;
        }
        return this.getSession(cookie) != null;
    }

    public void removeSession(String id) {
        if (this.httpSessions.containsKey(id)) {
            this.httpSessions.remove(id);
        }
    }

    public void removeSession(HttpSession session) {
        if (session != null && session.getId() != null) {
            this.removeSession(session.getId());
        }
    }

    public HttpSession newSession(HttpRequest request) {
        HttpSession session = null;
        if (request.header().get("Host") != null) {
            session = new HttpSession(this.webConfig, this, request.getSocketSession());
        } else {
            Logger.warn("Create session cookie error, the request haven't an header of host.");
        }
        return session;
    }

    public static SessionManager newInstance(WebServerConfig config) {
        return new SessionManager(config);
    }
}

