/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.server;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.voovan.http.message.packet.Cookie;
import org.voovan.http.server.HttpRequest;
import org.voovan.http.server.HttpResponse;
import org.voovan.http.server.SessionManager;
import org.voovan.http.server.context.WebContext;
import org.voovan.http.server.context.WebServerConfig;
import org.voovan.network.IoSession;
import org.voovan.tools.TString;
import org.voovan.tools.reflect.annotation.NotSerialization;

public class HttpSession {
    private Map<String, Object> attributes;
    private String id = TString.generateId(this);
    private int maxInactiveInterval;
    @NotSerialization
    private SessionManager sessionManager;
    @NotSerialization
    private IoSession socketSession;
    @NotSerialization
    private boolean needSave;

    public HttpSession(WebServerConfig config, SessionManager sessionManager, IoSession socketSession) {
        this.attributes = new ConcurrentHashMap<String, Object>();
        int sessionTimeout = config.getSessionTimeout();
        if (sessionTimeout <= 0) {
            sessionTimeout = 30;
        }
        this.maxInactiveInterval = sessionTimeout * 60;
        this.sessionManager = sessionManager;
        this.socketSession = socketSession;
        this.needSave = false;
    }

    public void init(SessionManager sessionManager, IoSession socketSession) {
        this.sessionManager = sessionManager;
        this.socketSession = socketSession;
    }

    public IoSession getSocketSession() {
        return this.socketSession;
    }

    public void setSocketSession(IoSession socketSession) {
        this.socketSession = socketSession;
    }

    public HttpSession refresh() {
        this.sessionManager.getSessionContainer().setTTL(this.id, this.maxInactiveInterval);
        return this;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public boolean containAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
        this.needSave = true;
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
        this.needSave = true;
    }

    public Map<String, Object> attribute() {
        return this.attributes;
    }

    protected SessionManager getSessionManager() {
        return this.sessionManager;
    }

    protected void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public String getId() {
        return this.id;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
        this.needSave = true;
    }

    public void save() {
        if (this.sessionManager != null && this.needSave) {
            this.sessionManager.saveSession(this);
            this.needSave = false;
        }
    }

    public void release() {
        if (this.sessionManager != null && this.needSave) {
            this.sessionManager.removeSession(this);
        }
    }

    public void attach(HttpRequest request, HttpResponse response) {
        if (!this.attribute().isEmpty()) {
            Cookie sessionCookie = request.getCookie(WebContext.getSessionName());
            if (sessionCookie == null) {
                sessionCookie = Cookie.newInstance(request, "/", WebContext.getSessionName(), this.getId(), this.maxInactiveInterval * 60, true);
                response.cookies().add(sessionCookie);
            } else if (!sessionCookie.getValue().equals(this.getId())) {
                sessionCookie = Cookie.newInstance(request, "/", WebContext.getSessionName(), this.getId(), this.maxInactiveInterval * 60, true);
                response.cookies().add(sessionCookie);
            }
            this.refresh();
            this.save();
        } else {
            this.sessionManager.removeSession(this);
        }
    }

    public void close() {
        this.socketSession.close();
    }
}

