/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.voovan.http.message.Response;
import org.voovan.network.IoSession;

public class HttpResponse
extends Response {
    private String characterSet;
    private IoSession socketSession;

    protected HttpResponse(Response response, String characterSet, IoSession socketSession) {
        super(response);
        this.characterSet = characterSet;
        this.socketSession = socketSession;
    }

    protected HttpResponse(String characterSet, IoSession socketSession) {
        this.characterSet = characterSet;
        this.socketSession = socketSession;
    }

    public void init(String characterSet, IoSession socketSession) {
        this.characterSet = characterSet;
        this.socketSession = socketSession;
        this.setCompress(false);
    }

    protected IoSession getSocketSession() {
        return this.socketSession;
    }

    protected void setSocketSession(IoSession socketSession) {
        this.socketSession = socketSession;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public void setCharacterSet(String characterSet) {
        this.characterSet = characterSet;
    }

    public void write(byte[] bytes) {
        this.body().write(bytes);
    }

    public void write(byte[] bytes, int offset, int length) {
        this.body().write(bytes, offset, length);
    }

    public void write(String strs) {
        if (strs != null) {
            this.body().write(strs, this.characterSet);
        }
    }

    public void send() throws IOException {
        super.send(this.socketSession);
    }

    public int send(ByteBuffer byteBuffer) throws IOException {
        if (!this.basicSend) {
            this.send();
        }
        return this.socketSession.send(byteBuffer);
    }

    public void flush() {
        this.socketSession.flush();
    }

    public void redirct(String path) {
        this.protocol().setStatus(302);
        this.protocol().setStatusCode("Moved Permanently");
        this.header().put("Location", path);
        this.body().write(" ");
    }
}

