/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.server;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.voovan.http.message.Request;
import org.voovan.http.message.packet.Cookie;
import org.voovan.http.message.packet.Part;
import org.voovan.http.server.HttpSession;
import org.voovan.http.server.SessionManager;
import org.voovan.http.server.context.WebContext;
import org.voovan.network.IoSession;
import org.voovan.tools.TString;
import org.voovan.tools.reflect.TReflect;

public class HttpRequest
extends Request {
    private HttpSession session;
    private String characterSet;
    private Map<String, String> parameters;
    private Map<String, Object> attributes;
    private IoSession socketSession;
    private SessionManager sessionManager;

    public HttpRequest(Request request, String characterSet, IoSession socketSession) {
        super(request);
        this.characterSet = characterSet;
        this.parameters = new LinkedHashMap<String, String>();
        this.attributes = new HashMap<String, Object>();
        this.parseQueryString();
        this.socketSession = socketSession;
    }

    public HttpRequest(String characterSet, IoSession socketSession) {
        this.characterSet = characterSet;
        this.parameters = new LinkedHashMap<String, String>();
        this.attributes = new HashMap<String, Object>();
        this.parseQueryString();
        this.socketSession = socketSession;
    }

    public void init(Request request, String characterSet, IoSession socketSession) {
        super.init(request);
        this.characterSet = characterSet;
        this.parameters.clear();
        this.attributes.clear();
        this.parseQueryString();
        this.socketSession = socketSession;
    }

    protected void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    protected IoSession getSocketSession() {
        return this.socketSession;
    }

    protected void setSocketSession(IoSession socketSession) {
        this.socketSession = socketSession;
    }

    public Cookie getCookie(String name) {
        for (Cookie cookie : this.cookies()) {
            if (cookie == null || name == null || !name.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    public boolean sessionExists() {
        return this.session != null;
    }

    public HttpSession getSession() {
        if (this.session == null) {
            Cookie sessionCookie = this.getCookie(WebContext.getSessionName());
            if (sessionCookie != null) {
                this.session = this.sessionManager.getSession(sessionCookie.getValue());
            }
            if (this.session == null) {
                this.session = this.sessionManager.newSession(this);
            }
            if (this.session != null) {
                this.session.init(this.sessionManager, this.getSocketSession());
                this.setSession(this.session);
            }
        }
        return this.session;
    }

    protected void setSession(HttpSession session) {
        this.session = session;
    }

    public String getRemoteAddres() {
        String xForwardedFor = this.header().get("X-Forwarded-For");
        String xRealIP = this.header().get("X-Real-IP");
        if (xRealIP != null) {
            return xRealIP;
        }
        if (xForwardedFor != null) {
            return xForwardedFor.split(",")[0].trim();
        }
        return this.socketSession.remoteAddress();
    }

    public int getRemotePort() {
        return this.socketSession.remotePort();
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    protected void setCharacterSet(String charset) {
        this.characterSet = charset;
    }

    protected String getQueryString() {
        return this.getQueryString(this.characterSet);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getParameter(String paramName) {
        return this.parameters.get(paramName);
    }

    public int getParameterAsInt(String paramName) {
        try {
            return (Integer)TString.toObject(this.parameters.get(paramName), Integer.TYPE);
        }
        catch (Exception e) {
            throw new RuntimeException("Get parameter [" + paramName + "] as int error.", e);
        }
    }

    public float getParameterAsFloat(String paramName) {
        try {
            return ((Float)TString.toObject(this.parameters.get(paramName), Float.TYPE)).floatValue();
        }
        catch (Exception e) {
            throw new RuntimeException("Get parameter [" + paramName + "] as float error.", e);
        }
    }

    public long getParameterAsLong(String paramName) {
        try {
            return (Long)TString.toObject(this.parameters.get(paramName), Long.TYPE);
        }
        catch (Exception e) {
            throw new RuntimeException("Get parameter [" + paramName + "] as long error.", e);
        }
    }

    public short getParameterAsShort(String paramName) {
        try {
            return (Short)TString.toObject(this.parameters.get(paramName), Short.TYPE);
        }
        catch (Exception e) {
            throw new RuntimeException("Get parameter [" + paramName + "] as short error.", e);
        }
    }

    public double getParameterAsDouble(String paramName) {
        try {
            return (Double)TString.toObject(this.parameters.get(paramName), Double.TYPE);
        }
        catch (Exception e) {
            throw new RuntimeException("Get parameter [" + paramName + "] as double error.", e);
        }
    }

    public boolean getParameterAsBoolean(String paramName) {
        try {
            return (Boolean)TString.toObject(this.parameters.get(paramName), Boolean.TYPE);
        }
        catch (Exception e) {
            throw new RuntimeException("Get parameter [" + paramName + "] as boolean error.", e);
        }
    }

    public byte getParameterAsByte(String paramName) {
        try {
            return (Byte)TString.toObject(this.parameters.get(paramName), Byte.TYPE);
        }
        catch (Exception e) {
            throw new RuntimeException("Get parameter [" + paramName + "] as byte error.", e);
        }
    }

    public char getParameterAsChar(String paramName) {
        try {
            return ((Character)TString.toObject(this.parameters.get(paramName), Character.TYPE)).charValue();
        }
        catch (Exception e) {
            throw new RuntimeException("Get parameter [" + paramName + "] as char error.", e);
        }
    }

    public <T> T getParameterAsObject(String paramName, Class<T> clazz) {
        try {
            return TString.toObject(this.parameters.get(paramName), clazz);
        }
        catch (Exception e) {
            throw new RuntimeException("Conver parameters to " + clazz.getCanonicalName() + " error.", e);
        }
    }

    public <T> T getAllParameterAsObject(Class<T> clazz) {
        try {
            return TReflect.getObjectFromMap(clazz, this.getParameters(), true);
        }
        catch (ReflectiveOperationException | ParseException e) {
            throw new RuntimeException("Conver parameters to " + clazz.getCanonicalName() + " error.", e);
        }
    }

    public List<String> getParameterNames() {
        return Arrays.asList(this.parameters.keySet().toArray(new String[0]));
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Object getAttributes(String attrName) {
        return this.attributes.get(attrName);
    }

    public void setAttributes(String attrName, Object attrValue) {
        this.attributes.put(attrName, attrValue);
    }

    private void parseQueryString() {
        if (this.getQueryString() != null) {
            String[] parameterEquals;
            for (String parameterEqual : parameterEquals = this.getQueryString().split("&")) {
                int equalFlagPos = parameterEqual.indexOf("=");
                if (equalFlagPos > 0) {
                    String name = parameterEqual.substring(0, equalFlagPos);
                    String value = parameterEqual.substring(equalFlagPos + 1, parameterEqual.length());
                    this.parameters.put(name, value);
                    continue;
                }
                this.parameters.put(parameterEqual, null);
            }
        }
    }

    public void send() throws IOException {
        super.send(this.socketSession);
    }

    public int send(ByteBuffer byteBuffer) throws IOException {
        if (!this.basicSend) {
            this.send();
        }
        return this.socketSession.send(byteBuffer);
    }

    public void flush() {
        this.socketSession.flush();
    }

    public void saveUploadedFile(String name, File file) throws IOException {
        for (Part part : this.parts()) {
            if (!part.getName().equals(name)) continue;
            part.saveAsFile(file);
            return;
        }
        throw new IOException("The uploadFile parameter which name is " + name + " not found.");
    }

    public void saveUploadedFile(String name, String file) throws IOException {
        this.saveUploadedFile(name, new File(file));
    }

    public void redirect(String url) {
        String[] parsedURL = url.split("\\?");
        this.protocol().clear();
        this.body().clear();
        this.parts().clear();
        if (parsedURL.length > 0) {
            this.protocol().setPath(parsedURL[0]);
        }
        if (parsedURL.length > 1) {
            this.protocol().setQueryString(parsedURL[1]);
        }
    }
}

