/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.server;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.voovan.http.server.HttpModuleLifeCycle;
import org.voovan.http.server.HttpRouter;
import org.voovan.http.server.WebServer;
import org.voovan.http.server.context.HttpFilterConfig;
import org.voovan.http.server.context.HttpModuleConfig;
import org.voovan.http.websocket.WebSocketRouter;
import org.voovan.tools.collection.Chain;
import org.voovan.tools.log.Logger;
import org.voovan.tools.reflect.TReflect;

public abstract class HttpModule {
    private WebServer webServer;
    private HttpModuleConfig moduleConfig;
    private Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    public WebServer getWebServer() {
        return this.webServer;
    }

    public HttpModuleConfig getModuleConfig() {
        return this.moduleConfig;
    }

    public void init(WebServer webServer, HttpModuleConfig moduleConfig) {
        this.webServer = webServer;
        this.moduleConfig = moduleConfig;
    }

    public Object getParamters(String name) {
        return this.moduleConfig.getParameters().get(name);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public boolean containAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Map<String, Object> attribute() {
        return this.attributes;
    }

    public void get(String routeRegexPath, HttpRouter router) {
        String routePath = this.moduleConfig.getPath() + routeRegexPath;
        this.webServer.get(routePath, router);
    }

    public void post(String routeRegexPath, HttpRouter router) {
        String routePath = this.moduleConfig.getPath() + routeRegexPath;
        this.webServer.post(routePath, router);
    }

    public void head(String routeRegexPath, HttpRouter router) {
        String routePath = this.moduleConfig.getPath() + routeRegexPath;
        this.webServer.head(routePath, router);
    }

    public void put(String routeRegexPath, HttpRouter router) {
        String routePath = this.moduleConfig.getPath() + routeRegexPath;
        this.webServer.put(routePath, router);
    }

    public void delete(String routeRegexPath, HttpRouter router) {
        String routePath = this.moduleConfig.getPath() + routeRegexPath;
        this.webServer.delete(routePath, router);
    }

    public void trace(String routeRegexPath, HttpRouter router) {
        String routePath = this.moduleConfig.getPath() + routeRegexPath;
        this.webServer.trace(routePath, router);
    }

    public void connect(String routeRegexPath, HttpRouter router) {
        String routePath = this.moduleConfig.getPath() + routeRegexPath;
        this.webServer.connect(routePath, router);
    }

    public void options(String routeRegexPath, HttpRouter router) {
        String routePath = this.moduleConfig.getPath() + routeRegexPath;
        this.webServer.options(routePath, router);
    }

    public void otherMethod(String method, String routeRegexPath, HttpRouter router) {
        String routePath = this.moduleConfig.getPath() + routeRegexPath;
        this.webServer.otherMethod(method, routePath, router);
    }

    public Chain<HttpFilterConfig> filterChain() {
        return this.webServer.getWebServerConfig().getFilterConfigs();
    }

    public void socket(String routeRegexPath, WebSocketRouter router) {
        this.webServer.socket(this.moduleConfig.getPath() + routeRegexPath, router);
    }

    protected void runModuleInit() {
        String lifeCycleClass = this.moduleConfig.getLifeCycleClass();
        if (lifeCycleClass == null) {
            Logger.simple("[SYSTEM] Module [" + this.moduleConfig.getName() + "] None HttpMoudule lifeCycle class to load.");
            return;
        }
        if (lifeCycleClass.isEmpty()) {
            Logger.simple("[SYSTEM] Module [" + this.moduleConfig.getName() + "] None HttpMoudule lifeCycle class to load.");
            return;
        }
        try {
            HttpModuleLifeCycle moduleInit = null;
            Class<?> clazz = Class.forName(lifeCycleClass);
            if (TReflect.isImpByInterface(clazz, HttpModuleLifeCycle.class)) {
                moduleInit = (HttpModuleLifeCycle)TReflect.newInstance(clazz, new Object[0]);
                moduleInit.init(this);
            } else {
                Logger.warn("[" + this.moduleConfig.getName() + "] The HttpModule lifeCycle class " + lifeCycleClass + " is not a class implement by " + HttpModuleLifeCycle.class.getName());
            }
        }
        catch (Exception e) {
            Logger.error("[" + this.moduleConfig.getName() + "] Initialize HttpModule lifeCycle class error: " + e);
        }
    }

    protected void runModuleDestory() {
        String moduleInitClass = this.moduleConfig.getLifeCycleClass();
        if (moduleInitClass == null) {
            Logger.simple("[SYSTEM] Module [" + this.moduleConfig.getName() + "] None HttpMoudule lifeCycle class to load.");
            return;
        }
        if (moduleInitClass.isEmpty()) {
            Logger.simple("[SYSTEM] Module [" + this.moduleConfig.getName() + "] None HttpMoudule lifeCycle class to load.");
            return;
        }
        try {
            HttpModuleLifeCycle moduleInit = null;
            Class<?> clazz = Class.forName(moduleInitClass);
            if (TReflect.isImpByInterface(clazz, HttpModuleLifeCycle.class)) {
                moduleInit = (HttpModuleLifeCycle)TReflect.newInstance(clazz, new Object[0]);
                moduleInit.destory(this);
            } else {
                Logger.warn("[" + this.moduleConfig.getName() + "] The HttpModule lifeCycle class " + moduleInitClass + " is not a class implement by " + HttpModuleLifeCycle.class.getName());
            }
        }
        catch (Exception e) {
            Logger.error("[" + this.moduleConfig.getName() + "] Initialize HttpModule lifeCycle class error: " + e);
        }
    }

    public abstract void install();

    public abstract void unInstall();
}

