/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.server;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import org.voovan.http.server.HttpFilter;
import org.voovan.http.server.HttpRequest;
import org.voovan.http.server.HttpResponse;
import org.voovan.http.server.HttpRouter;
import org.voovan.http.server.HttpSession;
import org.voovan.http.server.SessionManager;
import org.voovan.http.server.context.HttpFilterConfig;
import org.voovan.http.server.context.WebContext;
import org.voovan.http.server.context.WebServerConfig;
import org.voovan.http.server.exception.ResourceNotFound;
import org.voovan.http.server.exception.RouterNotFound;
import org.voovan.http.server.router.MimeFileRouter;
import org.voovan.tools.TDateTime;
import org.voovan.tools.TEnv;
import org.voovan.tools.TFile;
import org.voovan.tools.TObject;
import org.voovan.tools.TString;
import org.voovan.tools.collection.Chain;
import org.voovan.tools.log.Logger;
import org.voovan.tools.security.THash;

public class HttpDispatcher {
    private static Map<String, String> REGEXED_ROUTER_CACHE = new ConcurrentHashMap<String, String>();
    private static Map<Integer, List<Object>> ROUTER_INFO_CACHE = new ConcurrentHashMap<Integer, List<Object>>();
    private Map<String, Map<String, HttpRouter>> methodRouters;
    private WebServerConfig webConfig;
    private SessionManager sessionManager;
    private MimeFileRouter mimeFileRouter;
    private String[] indexFiles;

    public HttpDispatcher(WebServerConfig webConfig, SessionManager sessionManager) {
        REGEXED_ROUTER_CACHE.clear();
        ROUTER_INFO_CACHE.clear();
        this.methodRouters = new LinkedHashMap<String, Map<String, HttpRouter>>();
        this.webConfig = webConfig;
        this.sessionManager = sessionManager;
        this.indexFiles = webConfig.getIndexFiles();
        this.addRouteMethod("GET");
        this.addRouteMethod("POST");
        this.addRouteMethod("HEAD");
        this.addRouteMethod("PUT");
        this.addRouteMethod("DELETE");
        this.addRouteMethod("TRACE");
        this.addRouteMethod("CONNECT");
        this.addRouteMethod("OPTIONS");
        this.mimeFileRouter = new MimeFileRouter(webConfig.getContextPath());
    }

    public Map<String, Map<String, HttpRouter>> getRoutes() {
        return this.methodRouters;
    }

    protected void addRouteMethod(String method) {
        if (!this.methodRouters.containsKey(method)) {
            TreeMap routers = new TreeMap(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    if (o1.length() > o2.length() && !o1.equals(o2)) {
                        return -1;
                    }
                    if (o1.length() < o2.length() && !o1.equals(o2)) {
                        return 1;
                    }
                    if (o1.equals(o2)) {
                        return 0;
                    }
                    return 1;
                }
            });
            this.methodRouters.put(method, routers);
        }
    }

    public static String fixRoutePath(String routePath) {
        if (routePath.endsWith("/")) {
            routePath = TString.removeSuffix(routePath);
        }
        if (!routePath.startsWith("/")) {
            routePath = TString.assembly("/", routePath);
        }
        return TString.fastReplaceAll(routePath, "\\/{2,9}", "/");
    }

    public void addRouteHandler(String method, String routeRegexPath, HttpRouter router) {
        if (this.methodRouters.keySet().contains(method)) {
            this.methodRouters.get(method).put(HttpDispatcher.fixRoutePath(routeRegexPath), router);
        }
    }

    public boolean isFrameWorkRequest(HttpRequest request) {
        return (request.protocol().getMethod().equals("ADMIN") || request.protocol().getMethod().equals("MONITOR")) && request.header().contain("AUTH-TOKEN");
    }

    public void process(HttpRequest request, HttpResponse response) {
        Chain<HttpFilterConfig> filterConfigs = this.webConfig.getFilterConfigs();
        Object filterResult = null;
        request.setSessionManager(this.sessionManager);
        if (!this.isFrameWorkRequest(request)) {
            filterResult = this.disposeFilter(filterConfigs, request, response);
        }
        if (response.body().size() == 0L) {
            this.disposeRoute(request, response);
        }
        if (!this.isFrameWorkRequest(request)) {
            filterResult = this.disposeInvertedFilter(filterConfigs, request, response);
        }
        if (request.sessionExists()) {
            HttpSession session = request.getSession();
            session.attach(request, response);
        }
        WebContext.writeAccessLog(this.webConfig, request, response);
    }

    public boolean isStaticFile(HttpRequest request) {
        String extentsion = TFile.getFileExtension(request.protocol().getPath());
        if (extentsion != null && WebContext.getMimeDefine().containsKey(extentsion)) {
            File staticFile = this.mimeFileRouter.getStaticFile(request);
            return staticFile.exists() && staticFile.isFile();
        }
        return false;
    }

    public List<Object> findRouter(HttpRequest request) {
        String requestPath = request.protocol().getPath();
        String requestMethod = request.protocol().getMethod();
        int routerMark = THash.hashTime31(requestPath) << 16 + THash.hashTime31(requestMethod);
        List routerInfo = ROUTER_INFO_CACHE.get(routerMark);
        if (routerInfo == null) {
            Map<String, HttpRouter> routers = this.methodRouters.get(requestMethod);
            for (Map.Entry<String, HttpRouter> routeEntry : routers.entrySet()) {
                String routePath = routeEntry.getKey();
                if (!HttpDispatcher.matchPath(requestPath, routePath, this.webConfig.isMatchRouteIgnoreCase())) continue;
                routerInfo = TObject.asList(routePath, routeEntry.getValue());
                ROUTER_INFO_CACHE.put(routerMark, routerInfo);
                return routerInfo;
            }
        }
        if (routerInfo == null && this.isStaticFile(request)) {
            routerInfo = TObject.asList(request.protocol().getPath(), this.mimeFileRouter);
            ROUTER_INFO_CACHE.put(routerMark, routerInfo);
            return routerInfo;
        }
        return routerInfo;
    }

    public void disposeRoute(HttpRequest request, HttpResponse response) {
        String requestPath = request.protocol().getPath();
        List<Object> routerInfo = this.findRouter(request);
        if (routerInfo != null) {
            try {
                String routePath = (String)routerInfo.get(0);
                HttpRouter router = (HttpRouter)routerInfo.get(1);
                Map<String, String> pathVariables = HttpDispatcher.fetchPathVariables(requestPath, routePath);
                if (pathVariables != null) {
                    request.getParameters().putAll(pathVariables);
                }
                router.process(request, response);
            }
            catch (Exception e) {
                if (e instanceof Throwable) {
                    e = new Exception(e);
                }
                this.exceptionMessage(request, response, e);
            }
        } else if (!this.tryIndex(request, response)) {
            this.exceptionMessage(request, response, new RouterNotFound("Not avaliable router!"));
        }
    }

    public boolean tryIndex(HttpRequest request, HttpResponse response) {
        for (String indexFile : this.indexFiles) {
            String requestPath = request.protocol().getPath();
            String filePath = this.webConfig.getContextPath() + requestPath.replace("/", File.separator) + (requestPath.endsWith("/") ? "" : File.separator) + indexFile;
            if (!TFile.fileExists(filePath)) continue;
            try {
                String newRequestPath = requestPath + (requestPath.endsWith("/") ? "" : "/") + indexFile;
                request.protocol().setPath(newRequestPath);
                this.mimeFileRouter.process(request, response);
            }
            catch (Exception e) {
                this.exceptionMessage(request, response, e);
            }
            return true;
        }
        return false;
    }

    public static String routePath2RegexPath(String routePath) {
        if (!REGEXED_ROUTER_CACHE.containsKey(routePath)) {
            String routeRegexPath = TString.fastReplaceAll(routePath, "\\*", ".*?");
            routeRegexPath = TString.fastReplaceAll(routeRegexPath, "/", "\\/");
            routeRegexPath = TString.fastReplaceAll(routeRegexPath, ":[^:?/]*", "[^:?/]*");
            routeRegexPath = TString.assembly("^\\/?", routeRegexPath, "\\/?$");
            REGEXED_ROUTER_CACHE.put(routePath, routeRegexPath);
            return routeRegexPath;
        }
        return REGEXED_ROUTER_CACHE.get(routePath);
    }

    public static boolean matchPath(String requestPath, String routePath, boolean matchRouteIgnoreCase) {
        String routeRegexPath = HttpDispatcher.routePath2RegexPath(routePath);
        if (matchRouteIgnoreCase) {
            requestPath = requestPath.toLowerCase();
            routeRegexPath = routeRegexPath.toLowerCase();
        }
        return TString.regexMatch(requestPath, routeRegexPath) > 0;
    }

    public static Map<String, String> fetchPathVariables(String requestPath, String routePath) {
        String compareRequestPath;
        String compareRoutePath = routePath.endsWith("*") ? TString.removeSuffix(routePath) : routePath;
        compareRoutePath = compareRoutePath.endsWith("/") ? TString.removeSuffix(compareRoutePath) : compareRoutePath;
        String string = compareRequestPath = requestPath.endsWith("/") ? TString.removeSuffix(requestPath) : requestPath;
        if (compareRequestPath.equals(compareRoutePath)) {
            return null;
        }
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        String routePathMathchRegex = routePath;
        try {
            String[] names = TString.searchByRegex(routePath, ":[^:?/]*");
            if (names.length > 0) {
                for (int i = 0; i < names.length; ++i) {
                    names[i] = TString.removePrefix(names[i]);
                    String name = names[i];
                    routePathMathchRegex = routePathMathchRegex.replace(":" + name, "(?<" + name + ">.*)");
                }
                Matcher matcher = TString.doRegex(requestPath, routePathMathchRegex);
                for (String name : names) {
                    resultMap.put(name, URLDecoder.decode(matcher.group(name), "UTF-8"));
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            Logger.error("RoutePath URLDecoder.decode failed by charset: UTF-8", e);
        }
        return resultMap;
    }

    public Object disposeFilter(Chain<HttpFilterConfig> filterConfigs, HttpRequest request, HttpResponse response) {
        if (filterConfigs.size() > 0) {
            HttpFilterConfig filterConfig;
            HttpFilter httpFilter;
            filterConfigs.rewind();
            Object filterResult = null;
            while (filterConfigs.hasNext() && ((httpFilter = (filterConfig = filterConfigs.next()).getHttpFilterInstance()) == null || (filterResult = httpFilter.onRequest(filterConfig, request, response, filterResult)) != null)) {
            }
            return filterResult;
        }
        return null;
    }

    public Object disposeInvertedFilter(Chain<HttpFilterConfig> filterConfigs, HttpRequest request, HttpResponse response) {
        if (filterConfigs.size() > 0) {
            HttpFilterConfig filterConfig;
            HttpFilter httpFilter;
            filterConfigs.rewind();
            Object filterResult = null;
            while (filterConfigs.hasPrevious() && ((httpFilter = (filterConfig = filterConfigs.previous()).getHttpFilterInstance()) == null || (filterResult = httpFilter.onResponse(filterConfig, request, response, filterResult)) != null)) {
            }
            return filterResult;
        }
        return null;
    }

    public void exceptionMessage(HttpRequest request, HttpResponse response, Exception e) {
        Map<String, Object> errorDefine = WebContext.getErrorDefine();
        String requestMethod = request.protocol().getMethod();
        String requestPath = request.protocol().getPath();
        String className = e.getClass().getName();
        String errorMessage = e.toString().replace(TFile.getLineSeparator(), "<br/>");
        String stackInfo = "";
        if (!errorDefine.containsKey(className)) {
            Throwable throwable = e;
            while (true) {
                stackInfo = TString.assembly(stackInfo, "\n\n", throwable.toString(), "\n", TEnv.getStackElementsMessage(throwable.getStackTrace()));
                if ((throwable = throwable.getCause()) == null) break;
                if (!(throwable instanceof InvocationTargetException)) continue;
                throwable = throwable.getCause();
            }
        }
        stackInfo = TString.indent(stackInfo.trim(), 1).replace("\n", "<br>");
        response.header().put("Content-Type", "text/html");
        HashMap<String, Object> error = new HashMap<String, Object>();
        if (!(e instanceof ResourceNotFound) && !(e instanceof RouterNotFound)) {
            response.protocol().setStatus(500);
            error.put("StatusCode", 500);
            Logger.error(e);
        } else {
            response.protocol().setStatus(404);
            error.put("StatusCode", 404);
        }
        error.put("Page", "Error.html");
        error.put("Description", stackInfo);
        if (errorDefine.containsKey(className)) {
            error.putAll((Map)errorDefine.get(className));
            response.protocol().setStatus((Integer)error.get("StatusCode"));
        } else if (errorDefine.get("Other") != null) {
            error.putAll((Map)errorDefine.get("Other"));
            response.protocol().setStatus((Integer)error.get("StatusCode"));
        }
        String errorPageContent = WebContext.getDefaultErrorPage();
        if (TFile.fileExists(TFile.getSystemPath("/conf/error-page/" + error.get("Page")))) {
            try {
                errorPageContent = new String(TFile.loadFileFromContextPath("/conf/error-page/" + error.get("Page")), "UTF-8");
            }
            catch (UnsupportedEncodingException e1) {
                Logger.error("This charset is unsupported", e);
            }
        }
        if (errorPageContent != null) {
            errorPageContent = TString.oneTokenReplace(errorPageContent, "StatusCode", error.get("StatusCode").toString());
            errorPageContent = TString.oneTokenReplace(errorPageContent, "RequestMethod", requestMethod);
            errorPageContent = TString.oneTokenReplace(errorPageContent, "RequestPath", requestPath);
            errorPageContent = TString.oneTokenReplace(errorPageContent, "ErrorMessage", errorMessage);
            errorPageContent = TString.oneTokenReplace(errorPageContent, "Description", error.get("Description").toString());
            errorPageContent = TString.oneTokenReplace(errorPageContent, "Version", WebContext.FULL_VERSION);
            errorPageContent = TString.oneTokenReplace(errorPageContent, "DateTime", TDateTime.now());
            response.body().clear();
            response.write(errorPageContent);
        }
    }
}

