/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.message.packet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.voovan.http.message.packet.Body;
import org.voovan.http.message.packet.Header;
import org.voovan.network.IoSession;
import org.voovan.tools.TFile;
import org.voovan.tools.TString;
import org.voovan.tools.buffer.TByteBuffer;
import org.voovan.tools.log.Logger;

public class Part {
    private Header header = new Header();
    private Body body = new Body();

    public Part() {
    }

    public Part(String name, String value, String charset) {
        this.header.put("name", name);
        this.body.write(value, charset);
    }

    public Part(String name, String value) {
        this.header.put("name", name);
        try {
            this.body.write(value.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            Logger.error("This charset is unsupported", e);
        }
    }

    public Part(String name, File file) {
        this.header.put("name", name);
        this.header.put("filename", TFile.getFileName(file.getPath()));
        try {
            this.body.changeToFile(file);
        }
        catch (FileNotFoundException e) {
            Logger.error(e);
        }
    }

    public Header header() {
        return this.header;
    }

    public Body body() {
        return this.body;
    }

    public String getName() {
        return this.header.get("name");
    }

    public String getFileName() {
        return this.header.get("filename");
    }

    public PartType getType() {
        if ("binary".equals(this.header.get("Content-Transfer-Encoding"))) {
            return PartType.BINARY;
        }
        return PartType.TEXT;
    }

    public void saveAsFile(File file) throws IOException {
        this.body.saveAsFile(file);
    }

    public void saveAsFile(String fileName) throws IOException {
        this.body.saveAsFile(new File(fileName));
    }

    public void clear() {
        this.header.clear();
        this.body().clear();
    }

    private String readHead() {
        this.header.put("Content-Disposition", "form-data");
        if (this.header.get("name") != null) {
            String value = this.header.get("Content-Disposition") + "; name=\"" + this.header.get("name") + "\"";
            if (this.header.get("filename") != null) {
                value = value + "; filename=\"" + this.header.get("filename") + "\"";
            }
            this.header.put("Content-Disposition", value);
        }
        this.header.remove("name");
        this.header.remove("filename");
        return this.header.toString() + "\r\n";
    }

    public void send(IoSession session, String boundary) {
        int readSize = 0;
        ByteBuffer byteBuffer = TByteBuffer.allocateDirect();
        byteBuffer.put(TString.assembly("--", boundary, "\r\n").getBytes());
        byteBuffer.flip();
        session.send(byteBuffer);
        byteBuffer.clear();
        byteBuffer.put(this.readHead().getBytes());
        byteBuffer.flip();
        session.send(byteBuffer);
        byteBuffer.clear();
        while ((readSize = this.body.read(byteBuffer)) != -1) {
            session.send(byteBuffer);
            byteBuffer.clear();
        }
        byteBuffer.clear();
        byteBuffer.put("\r\n".getBytes());
        byteBuffer.flip();
        session.send(byteBuffer);
        byteBuffer.clear();
        TByteBuffer.release(byteBuffer);
    }

    public String toString() {
        return this.readHead();
    }

    public static enum PartType {
        BINARY,
        TEXT;

    }
}

