/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.message.packet;

import java.util.HashMap;
import java.util.Map;
import org.voovan.tools.FastThreadLocal;

public class Header {
    private Map<String, String> headers = new HashMap<String, String>(32);
    private static FastThreadLocal<StringBuilder> THREAD_STRING_BUILDER = FastThreadLocal.withInitial(() -> new StringBuilder(512));

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String remove(String header) {
        return this.headers.remove(header);
    }

    public boolean contain(String header) {
        return this.headers.containsKey(header);
    }

    public String get(String header) {
        return this.headers.get(header);
    }

    public String put(String header, String value) {
        return this.headers.put(header, value);
    }

    public void putAll(Map<String, String> valueMap) {
        this.headers.putAll(valueMap);
    }

    public int size() {
        return this.headers.size();
    }

    public void clear() {
        this.headers.clear();
    }

    public String toString() {
        StringBuilder headerContent = THREAD_STRING_BUILDER.get();
        headerContent.setLength(0);
        for (Map.Entry<String, String> headerItemEntry : this.headers.entrySet()) {
            String key = headerItemEntry.getKey();
            String value = headerItemEntry.getValue();
            if (key.isEmpty()) continue;
            headerContent.append(key);
            headerContent.append(": ");
            headerContent.append(value);
            headerContent.append("\r\n");
        }
        return headerContent.toString();
    }
}

