/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.message.packet;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import org.voovan.http.message.Request;
import org.voovan.http.server.context.WebContext;
import org.voovan.tools.log.Logger;

public class Cookie {
    private String domain;
    private String path;
    private int maxAge = -999999;
    private String expires;
    private boolean secure;
    private boolean httpOnly;
    private String name;
    private String value;

    private Cookie() {
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public String getExpires() {
        return this.expires;
    }

    public void setExpires(String expires) {
        this.expires = expires;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        try {
            return URLDecoder.decode(this.value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Logger.error(e);
            return this.value;
        }
    }

    public void setValue(String value) {
        try {
            this.value = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Logger.error(e);
        }
    }

    public String toString() {
        return (this.name != null || this.value != null ? this.name + "=" + this.value : "") + (this.domain != null ? "; domain=" + this.domain : "") + (this.maxAge != -999999 ? "; max-age=" + this.maxAge : "") + (this.path != null ? "; path=" + this.path : " ") + (this.httpOnly ? "; httponly; " : "") + (this.secure ? "; secure" : "");
    }

    public static Cookie buildCookie(Map<String, String> cookieMap) {
        Cookie cookie = new Cookie();
        block16: for (Map.Entry<String, String> cookieMapItem : cookieMap.entrySet()) {
            switch (cookieMapItem.getKey().toLowerCase()) {
                case "domain": {
                    cookie.setDomain(cookieMapItem.getValue());
                    continue block16;
                }
                case "path": {
                    cookie.setPath(cookieMapItem.getValue());
                    continue block16;
                }
                case "max-age": {
                    cookie.setMaxAge(Integer.parseInt(cookieMapItem.getValue()));
                    continue block16;
                }
                case "secure": {
                    cookie.setSecure(true);
                    continue block16;
                }
                case "httponly": {
                    cookie.setHttpOnly(true);
                    continue block16;
                }
                case "expires": {
                    cookie.setExpires(cookieMapItem.getValue());
                    continue block16;
                }
            }
            cookie.setName(cookieMapItem.getKey());
            cookie.setValue(cookieMapItem.getValue());
        }
        return cookie;
    }

    public static Cookie newInstance(String domain, String path, String name, String value, int maxAge, boolean isHttpOnly) {
        Cookie cookie = new Cookie();
        cookie.setName(name);
        cookie.setValue(value);
        cookie.setPath(path);
        cookie.setDomain(domain);
        cookie.setMaxAge(maxAge);
        cookie.setHttpOnly(isHttpOnly);
        return cookie;
    }

    public static Cookie newInstance(Request request, String path, String name, String value, int maxAge, boolean isHttpOnly) {
        String Host = request.header().get("Host");
        String domain = Host.split(":")[0];
        return Cookie.newInstance(domain, path, name, value, maxAge, isHttpOnly);
    }

    public static Cookie newInstance(Request request, String path, String name, String value) {
        return Cookie.newInstance(request, path, name, value, WebContext.getWebServerConfig().getSessionTimeout() * 60, false);
    }

    public static Cookie newInstance(Request request, String name, String value) {
        return Cookie.newInstance(request, "/", name, value, WebContext.getWebServerConfig().getSessionTimeout() * 60, false);
    }
}

