/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.message.packet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.voovan.tools.TFile;
import org.voovan.tools.TString;
import org.voovan.tools.TZip;
import org.voovan.tools.buffer.ByteBufferChannel;
import org.voovan.tools.log.Logger;
import org.voovan.tools.security.THash;

public class Body {
    private ByteBufferChannel byteBufferChannel;
    private BodyType type;
    private File bodyFile;
    private long position;
    private int mark = 0;

    public Body() {
        this.type = BodyType.BYTES;
        this.changeToBytes("".getBytes());
        this.bodyFile = null;
    }

    public Body(byte[] content) {
        this.type = BodyType.BYTES;
        this.changeToBytes(content);
        this.bodyFile = null;
    }

    public Body(String filePath) {
        this.type = BodyType.FILE;
        try {
            this.changeToFile(new File(filePath));
        }
        catch (IOException e) {
            Logger.error("Construct Body error", e);
        }
    }

    public BodyType getType() {
        return this.type;
    }

    public boolean isFile() {
        return this.bodyFile != null;
    }

    public void changeToFile(File bodyFile) throws FileNotFoundException {
        if (!bodyFile.exists()) {
            throw new FileNotFoundException("Upload file " + bodyFile.getPath() + " not exists");
        }
        this.bodyFile = bodyFile;
        if (this.byteBufferChannel != null) {
            this.byteBufferChannel = null;
        }
        this.position = 0L;
        this.type = BodyType.FILE;
    }

    public void changeToFile(String file) throws FileNotFoundException {
        this.changeToFile(new File(file));
    }

    public void changeToBytes(byte[] content) {
        if (this.byteBufferChannel == null || this.byteBufferChannel.isReleased()) {
            this.byteBufferChannel = new ByteBufferChannel();
        }
        if (this.bodyFile != null) {
            this.bodyFile = null;
        }
        if (content.length != 0) {
            this.byteBufferChannel.writeEnd(ByteBuffer.wrap(content));
        } else {
            this.byteBufferChannel.clear();
        }
        this.type = BodyType.BYTES;
    }

    public long size() {
        if (this.type == BodyType.FILE) {
            try {
                return TFile.getFileSize(this.bodyFile);
            }
            catch (IOException e) {
                Logger.error(e);
                return -1L;
            }
        }
        return this.byteBufferChannel.size();
    }

    public byte[] getBodyBytes() {
        if (this.type == BodyType.FILE) {
            return TFile.loadFile(this.bodyFile);
        }
        return this.byteBufferChannel.array();
    }

    public String getBodyString() {
        byte[] bodyBytes = this.getBodyBytes();
        try {
            return new String(bodyBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Logger.error("This charset is unsupported", e);
            return null;
        }
    }

    public String getBodyString(String charset) {
        byte[] bodyBytes = this.getBodyBytes();
        try {
            return new String(bodyBytes, charset);
        }
        catch (UnsupportedEncodingException e) {
            Logger.error("This charset is unsupported", e);
            return null;
        }
    }

    public int read(ByteBuffer byteBuffer) {
        int readSize = -1;
        if (this.type == BodyType.BYTES) {
            if (!this.byteBufferChannel.isReleased() && this.byteBufferChannel.size() > 0) {
                readSize = this.byteBufferChannel.readHead(byteBuffer);
                readSize = readSize == 0 ? -1 : readSize;
            }
        } else {
            byte[] fileContent = TFile.loadFile(this.bodyFile, this.position, this.position + (long)byteBuffer.remaining());
            if (fileContent != null) {
                readSize = fileContent.length;
                this.position += (long)readSize;
                byteBuffer.put(fileContent);
                byteBuffer.flip();
                return readSize;
            }
            readSize = -1;
        }
        return readSize;
    }

    public int read(byte[] buffer) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        return this.read(byteBuffer);
    }

    public Integer getMark() {
        return this.mark;
    }

    public void write(byte[] body, int offset, int length) {
        try {
            if (this.type == BodyType.BYTES) {
                int hash = THash.hashTime31(body, offset, length);
                this.mark = this.mark == 0 ? hash : this.mark + hash;
                ByteBuffer bodyTmp = ByteBuffer.wrap(body);
                bodyTmp.position(offset);
                bodyTmp.limit(length);
                if (!this.byteBufferChannel.isReleased()) {
                    this.byteBufferChannel.writeEnd(bodyTmp);
                }
            } else {
                TFile.writeFile(this.bodyFile, true, body, offset, length);
            }
        }
        catch (IOException e) {
            Logger.error("Wirte byte array faild by OutputStream", e);
        }
    }

    public void write(byte[] body) {
        this.write(body, 0, body.length);
    }

    public void write(String content, String charset) {
        try {
            this.write(content.getBytes(charset));
        }
        catch (IOException e) {
            Logger.error("Wirte string faild by OutputStream", e);
        }
    }

    public void write(String content) {
        this.write(content, "UTF-8");
    }

    public void clear() {
        if (this.type == BodyType.BYTES && this.byteBufferChannel != null && !this.byteBufferChannel.isReleased()) {
            this.byteBufferChannel.clear();
        } else if (this.type == BodyType.FILE) {
            if (this.bodyFile != null && this.bodyFile.getPath().startsWith(TFile.getTemporaryPath())) {
                this.bodyFile.delete();
            }
            this.bodyFile = null;
        }
        this.mark = 0;
        this.changeToBytes(new byte[0]);
    }

    public void saveAsFile(File destFile) throws IOException {
        if (this.type == BodyType.BYTES) {
            TFile.writeFile(destFile, this.getBodyBytes());
        }
        if (this.type == BodyType.FILE) {
            TFile.moveFile(this.bodyFile, destFile);
        }
    }

    public String toString() {
        byte[] bodyBytes = this.getBodyBytes();
        try {
            if (this.type == BodyType.FILE) {
                return this.bodyFile.getPath();
            }
            return new String(bodyBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Logger.error(e);
            return null;
        }
    }

    public boolean compress() throws IOException {
        if (this.size() != 0L) {
            if (this.isFile()) {
                String fileName = TFile.getFileName(this.bodyFile.getCanonicalPath());
                fileName = fileName.equals("") ? ".tmp" : fileName;
                String localFileName = TFile.assemblyPath(TFile.getTemporaryPath(), "voovan", "webserver", "body", TString.assembly("VOOVAN_", TString.generateId(this), ".", fileName));
                new File(TFile.getFileDirectory(localFileName)).mkdirs();
                File gzipedFile = new File(localFileName);
                TZip.encodeGZip(this.bodyFile, gzipedFile);
                this.bodyFile = gzipedFile;
                return true;
            }
            byte[] bodyBytes = TZip.encodeGZip(this.getBodyBytes());
            this.byteBufferChannel.clear();
            this.byteBufferChannel.writeEnd(ByteBuffer.wrap(bodyBytes));
            return true;
        }
        return false;
    }

    public void release() {
        this.clear();
    }

    public static enum BodyType {
        BYTES,
        FILE;

    }
}

