/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.message;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.voovan.http.message.HttpStatic;
import org.voovan.http.message.packet.Body;
import org.voovan.http.message.packet.Cookie;
import org.voovan.http.message.packet.Header;
import org.voovan.http.message.packet.ResponseProtocol;
import org.voovan.http.server.context.WebContext;
import org.voovan.network.IoSession;
import org.voovan.tools.FastThreadLocal;
import org.voovan.tools.TString;
import org.voovan.tools.buffer.TByteBuffer;
import org.voovan.tools.exception.MemoryReleasedException;
import org.voovan.tools.log.Logger;

public class Response {
    private static FastThreadLocal<StringBuilder> THREAD_STRING_BUILDER = FastThreadLocal.withInitial(() -> new StringBuilder(512));
    public static FastThreadLocal<ByteBuffer> THREAD_BYTE_BUFFER = FastThreadLocal.withInitial(() -> TByteBuffer.allocateDirect());
    private ResponseProtocol protocol;
    private Header header;
    private List<Cookie> cookies;
    private Body body;
    private boolean isCompress;
    protected boolean basicSend = false;
    private boolean autoSend = true;
    private Long mark;
    public static byte[] EMPTY_BYTES = new byte[0];

    protected Response(Response response) {
        this.init(response);
    }

    public void init(Response response) {
        this.protocol = response.protocol;
        this.header = response.header;
        this.body = response.body;
        this.cookies = response.cookies;
        this.isCompress = response.isCompress;
        this.basicSend = false;
        this.mark = response.mark;
    }

    public Response() {
        this.protocol = new ResponseProtocol();
        this.header = new Header();
        this.cookies = new ArrayList<Cookie>();
        this.body = new Body();
        this.isCompress = false;
        this.basicSend = false;
    }

    public Long getMark() {
        return this.mark;
    }

    public void setMark(Long mark) {
        this.mark = mark;
    }

    public boolean isCompress() {
        return this.isCompress;
    }

    public void setCompress(boolean isCompress) {
        this.isCompress = isCompress;
    }

    public boolean isAutoSend() {
        return this.autoSend;
    }

    public void setAutoSend(boolean autoSend) {
        this.autoSend = autoSend;
    }

    public ResponseProtocol protocol() {
        return this.protocol;
    }

    public Header header() {
        return this.header;
    }

    public List<Cookie> cookies() {
        return this.cookies;
    }

    public Body body() {
        return this.body;
    }

    private void initHeader() {
        if (this.body.size() != 0L && this.isCompress) {
            this.header.put("Transfer-Encoding", "chunked");
            this.header.put("Content-Encoding", "gzip");
        } else {
            this.header.put("Content-Length", Integer.toString((int)this.body.size()));
        }
        if (!this.header.contain("Content-Type")) {
            this.header.put("Content-Type", "text/html" + WebContext.getWebServerConfig().getResponseCharacterSet());
        } else {
            this.header.put("Content-Type", this.header.get("Content-Type") + WebContext.getWebServerConfig().getResponseCharacterSet());
        }
    }

    private String genCookie() {
        StringBuilder cookieString = new StringBuilder();
        for (Cookie cookie : this.cookies) {
            cookieString.append("Set-Cookie: ");
            cookieString.append(cookie.toString());
            cookieString.append("\r\n");
        }
        return cookieString.toString();
    }

    private byte[] readHead() {
        StringBuilder stringBuilder = THREAD_STRING_BUILDER.get();
        stringBuilder.setLength(0);
        this.initHeader();
        stringBuilder.append(this.protocol.toString());
        stringBuilder.append(this.header.toString());
        stringBuilder.append(this.genCookie());
        return TString.toAsciiBytes(stringBuilder.toString());
    }

    private byte[] readEnd() {
        if (this.isCompress) {
            return TString.toAsciiBytes("0\r\n\r\n");
        }
        return EMPTY_BYTES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(IoSession session) throws IOException {
        try {
            ByteBuffer byteBuffer;
            block13: {
                byteBuffer = THREAD_BYTE_BUFFER.get();
                byteBuffer.clear();
                try {
                    byteBuffer.put(this.readHead());
                    byteBuffer.put(WebContext.RESPONSE_COMMON_HEADER);
                }
                catch (Throwable e) {
                    if (e instanceof MemoryReleasedException) break block13;
                    Logger.error("Response writeToChannel error: ", (Exception)e);
                }
            }
            if (this.isCompress) {
                this.body.compress();
            }
            int readSize = 0;
            try {
                int totalBodySize = (int)this.body.size();
                while (totalBodySize > 0) {
                    byteBuffer.limit(byteBuffer.capacity() - 10);
                    readSize = byteBuffer.remaining() > totalBodySize ? totalBodySize : byteBuffer.remaining();
                    totalBodySize -= readSize;
                    if (this.isCompress() && readSize != 0) {
                        String chunkedLengthLine = Integer.toHexString(readSize) + "\r\n";
                        byteBuffer.put(chunkedLengthLine.getBytes());
                    }
                    this.body.read(byteBuffer);
                    byteBuffer.position(byteBuffer.limit());
                    byteBuffer.limit(byteBuffer.capacity() - 10);
                    if (this.isCompress() && readSize != 0 && byteBuffer.remaining() > 0) {
                        byteBuffer.put(HttpStatic.LINE_MARK.getBytes());
                    }
                    if (byteBuffer.position() != byteBuffer.limit()) continue;
                    byteBuffer.flip();
                    session.send(byteBuffer);
                    byteBuffer.clear();
                }
                byteBuffer.put(this.readEnd());
                byteBuffer.flip();
                session.send(byteBuffer);
            }
            catch (Throwable e) {
                if (!(e instanceof MemoryReleasedException)) {
                    Logger.error("Response writeToChannel error: ", (Exception)e);
                }
                this.clear();
                return;
            }
            this.basicSend = true;
        }
        finally {
            this.clear();
        }
    }

    public void release() {
        this.body.release();
    }

    public void clear() {
        this.header().clear();
        this.cookies().clear();
        this.protocol().clear();
        this.body().clear();
        this.isCompress = false;
        this.basicSend = false;
        this.autoSend = true;
        this.mark = null;
    }

    public String toString() {
        return new String(this.readHead());
    }
}

