/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.message;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Vector;
import org.voovan.http.message.packet.Body;
import org.voovan.http.message.packet.Cookie;
import org.voovan.http.message.packet.Header;
import org.voovan.http.message.packet.Part;
import org.voovan.http.message.packet.RequestProtocol;
import org.voovan.http.server.context.WebContext;
import org.voovan.network.IoSession;
import org.voovan.tools.TString;
import org.voovan.tools.buffer.TByteBuffer;
import org.voovan.tools.exception.MemoryReleasedException;
import org.voovan.tools.log.Logger;
import org.voovan.tools.security.THash;

public class Request {
    private RequestProtocol protocol;
    private Header header;
    private List<Cookie> cookies;
    private Body body;
    private List<Part> parts;
    private String boundary;
    protected boolean basicSend = false;
    private long mark = 0L;
    private static final String CONTENT_TYPE = "Content-Type";

    protected Request(Request request) {
        this.init(request);
    }

    public void init(Request request) {
        this.protocol = request.protocol;
        this.header = request.header;
        this.body = request.body;
        this.cookies = request.cookies;
        this.parts = request.parts;
        this.basicSend = false;
        this.mark = request.mark;
    }

    public Request() {
        this.protocol = new RequestProtocol();
        this.header = new Header();
        this.cookies = new Vector<Cookie>();
        this.body = new Body();
        this.parts = new Vector<Part>();
        this.basicSend = false;
    }

    public RequestProtocol protocol() {
        return this.protocol;
    }

    public long getMark() {
        return this.mark;
    }

    public void setMark(long mark) {
        this.mark = mark;
    }

    public Header header() {
        return this.header;
    }

    public List<Cookie> cookies() {
        return this.cookies;
    }

    public Body body() {
        return this.body;
    }

    public List<Part> parts() {
        return this.parts;
    }

    public RequestType getBodyType() {
        if (this.header.get(CONTENT_TYPE) != null) {
            if (this.header.get(CONTENT_TYPE).contains("application/x-www-form-urlencoded")) {
                return RequestType.BODY_URLENCODED;
            }
            if (this.header.get(CONTENT_TYPE).contains("multipart/form-data")) {
                return RequestType.BODY_MULTIPART;
            }
        }
        return RequestType.NORMAL;
    }

    public String getQueryString(String charset) {
        String queryString = "";
        queryString = this.protocol.getQueryString();
        if (this.getBodyType() == RequestType.BODY_URLENCODED) {
            queryString = queryString + "&" + this.body.getBodyString();
        } else if (this.getBodyType() == RequestType.BODY_MULTIPART) {
            StringBuilder result = new StringBuilder();
            for (Part part : this.parts) {
                if (part.getType() != Part.PartType.TEXT) continue;
                String name = part.header().get("name");
                String value = null;
                value = !part.body().isFile() ? part.body().getBodyString(charset) : part.header().get("filename");
                result.append(name);
                result.append("=");
                result.append(value);
                result.append("&");
            }
            queryString = TString.removeSuffix(queryString + "&" + result.toString());
        }
        if (queryString.startsWith("&")) {
            queryString = TString.removePrefix(queryString);
        }
        try {
            return queryString.isEmpty() ? null : URLDecoder.decode(queryString, WebContext.getWebServerConfig().getCharacterSet());
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private void initHeader() {
        String cookieValue;
        if (!this.header.contain(CONTENT_TYPE)) {
            if (!this.parts.isEmpty()) {
                String contentType = "multipart/form-data;";
                this.header.put(CONTENT_TYPE, contentType);
            } else if (this.body.size() > 0L) {
                this.header.put(CONTENT_TYPE, "application/x-www-form-urlencoded");
            }
        }
        if ("multipart/form-data;".equals(this.header.get(CONTENT_TYPE))) {
            this.boundary = THash.encryptBASE64(TString.generateId(this));
            this.header.put(CONTENT_TYPE, TString.assembly(this.header.get(CONTENT_TYPE), " boundary=", this.boundary));
        }
        if (this.body.size() > 0L) {
            this.header.put("Content-Length", Long.toString(this.body.size()));
        }
        if (!TString.isNullOrEmpty(cookieValue = this.genCookie())) {
            this.header.put("Cookie", this.genCookie());
        }
    }

    private String genCookie() {
        StringBuilder cookieString = new StringBuilder();
        for (Cookie cookie : this.cookies) {
            cookieString.append(cookie.getName());
            cookieString.append("=");
            cookieString.append(cookie.getValue());
            cookieString.append("; ");
        }
        return cookieString.toString();
    }

    private ByteBuffer readHead() {
        StringBuilder stringBuilder = new StringBuilder();
        this.initHeader();
        stringBuilder.append(this.protocol.toString());
        stringBuilder.append(this.header.toString());
        stringBuilder.append("\r\n");
        try {
            return ByteBuffer.wrap(stringBuilder.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            Logger.error("Response.readHead io error", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(IoSession session) throws IOException {
        int readSize = 0;
        ByteBuffer byteBuffer = null;
        try {
            block16: {
                try {
                    byteBuffer = this.readHead();
                }
                catch (Throwable e) {
                    if (e instanceof MemoryReleasedException) break block16;
                    Logger.error("Response writeToChannel error: ", (Exception)e);
                }
            }
            if (byteBuffer == null) {
                return;
            }
            session.send(byteBuffer);
            byteBuffer = TByteBuffer.allocateDirect();
            if (this.body.size() > 0L) {
                while ((readSize = this.body.read(byteBuffer)) != -1) {
                    session.send(byteBuffer);
                    byteBuffer.clear();
                }
            }
            byteBuffer.clear();
            if (!this.parts.isEmpty() && this.parts.size() != 0) {
                if (this.boundary == null) {
                    this.boundary = THash.encryptBASE64(TString.generateId(this));
                }
                for (Part part : this.parts) {
                    part.send(session, this.boundary);
                }
                byteBuffer.put(TString.assembly("--" + this.boundary + "--").getBytes());
                byteBuffer.flip();
                session.send(byteBuffer);
                byteBuffer.clear();
            }
            this.basicSend = true;
        }
        catch (Throwable e) {
            if (!(e instanceof MemoryReleasedException)) {
                Logger.error("Response writeToChannel error: ", (Exception)e);
            }
            return;
        }
        finally {
            if (byteBuffer != null) {
                TByteBuffer.release(byteBuffer);
            }
            this.clear();
        }
    }

    public void release() {
        for (Part part : this.parts) {
            part.body().release();
        }
        this.body.release();
    }

    public void clear() {
        this.header().clear();
        this.cookies().clear();
        this.protocol().clear();
        this.body().clear();
        this.parts().clear();
        this.mark = 0L;
    }

    public String toString() {
        return new String(TByteBuffer.toString(this.readHead()));
    }

    public static enum RequestType {
        BODY_URLENCODED,
        BODY_MULTIPART,
        NORMAL;

    }
}

