/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.message;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import org.voovan.Global;
import org.voovan.http.message.HttpItem;
import org.voovan.http.message.HttpStatic;
import org.voovan.http.message.Request;
import org.voovan.http.message.Response;
import org.voovan.http.message.packet.Cookie;
import org.voovan.http.message.packet.Part;
import org.voovan.http.server.context.WebContext;
import org.voovan.http.server.exception.ParserException;
import org.voovan.http.server.exception.RequestTooLarge;
import org.voovan.network.IoSession;
import org.voovan.tools.FastThreadLocal;
import org.voovan.tools.TEnv;
import org.voovan.tools.TFile;
import org.voovan.tools.TObject;
import org.voovan.tools.TString;
import org.voovan.tools.TZip;
import org.voovan.tools.buffer.ByteBufferChannel;
import org.voovan.tools.buffer.TByteBuffer;
import org.voovan.tools.hashwheeltimer.HashWheelTask;
import org.voovan.tools.log.Logger;
import org.voovan.tools.security.THash;

public class HttpParser {
    private static final String PL_METHOD = "1";
    private static final String PL_PATH = "2";
    private static final String PL_PROTOCOL = "3";
    private static final String PL_VERSION = "4";
    private static final String PL_STATUS = "5";
    private static final String PL_STATUS_CODE = "6";
    private static final String PL_QUERY_STRING = "7";
    private static final String PL_HASH = "8";
    private static final String USE_CACHE = "9";
    private static final String BODY_PARTS = "10";
    private static final String BODY_VALUE = "11";
    private static final String BODY_FILE = "12";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String UPLOAD_PATH = TFile.assemblyPath(TFile.getTemporaryPath(), "voovan", "webserver", "upload");
    public static final String propertyLineRegex = ": ";
    public static final String equalMapRegex = "([^ ;,]+=[^;,]+)";
    public static FastThreadLocal<Map<String, Object>> THREAD_PACKET_MAP = FastThreadLocal.withInitial(() -> new HashMap());
    public static FastThreadLocal<Request> THREAD_REQUEST = FastThreadLocal.withInitial(() -> new Request());
    public static FastThreadLocal<Response> THREAD_RESPONSE = FastThreadLocal.withInitial(() -> new Response());
    private static FastThreadLocal<byte[]> THREAD_STRING_BUILDER = FastThreadLocal.withInitial(() -> new byte[1024]);
    private static ConcurrentSkipListMap<Long, Map<String, Object>> PACKET_MAP_CACHE = new ConcurrentSkipListMap();

    private HttpParser() {
    }

    private static Map<String, String> parsePropertyLine(String propertyLine) {
        HashMap<String, String> property = new HashMap<String, String>();
        int index = propertyLine.indexOf(propertyLineRegex);
        if (index > 0) {
            String propertyName = propertyLine.substring(0, index);
            String properyValue = propertyLine.substring(index + 2, propertyLine.length());
            property.put(HttpParser.fixHeaderName(propertyName), properyValue.trim());
        }
        return property;
    }

    public static String fixHeaderName(String headerName) {
        if (headerName == null) {
            return null;
        }
        String[] headerNameSplits = headerName.split("-");
        StringBuilder stringBuilder = new StringBuilder();
        for (String headerNameSplit : headerNameSplits) {
            if (Character.isLowerCase(headerNameSplit.codePointAt(0))) {
                stringBuilder.append((char)(headerNameSplit.codePointAt(0) - 32));
                stringBuilder.append(TString.removePrefix(headerNameSplit));
            } else {
                stringBuilder.append(headerNameSplit);
            }
            stringBuilder.append("-");
        }
        return TString.removeSuffix(stringBuilder.toString());
    }

    public static Map<String, String> getEqualMap(String str) {
        String[] searchedStrings;
        HashMap<String, String> equalMap = new HashMap<String, String>();
        for (String groupString : searchedStrings = TString.searchByRegex(str, equalMapRegex)) {
            String[] equalStrings = new String[2];
            int equalCharIndex = groupString.indexOf("=");
            equalStrings[0] = groupString.substring(0, equalCharIndex);
            equalStrings[1] = groupString.substring(equalCharIndex + 1, groupString.length());
            if (equalStrings.length != 2) continue;
            String key = equalStrings[0];
            String value = equalStrings[1];
            if (value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            equalMap.put(key, value);
        }
        return equalMap;
    }

    private static String getPerprotyEqualValue(Map<String, Object> packetMap, String propertyName, String valueName) {
        Object propertyValueObj = packetMap.get(propertyName);
        if (propertyValueObj == null) {
            return null;
        }
        String propertyValue = propertyValueObj.toString();
        Map<String, String> equalMap = HttpParser.getEqualMap(propertyValue);
        return equalMap.get(valueName);
    }

    private static void parseCookie(Map<String, Object> packetMap, String cookieName, String cookieValue) {
        if (!packetMap.containsKey("Cookie")) {
            packetMap.put("Cookie", new ArrayList());
        }
        List cookies = (List)packetMap.get("Cookie");
        Map<String, String> cookieMap = HttpParser.getEqualMap(cookieValue);
        if ("Set-Cookie".equalsIgnoreCase(cookieName)) {
            if (cookieValue.toLowerCase().contains("httponly")) {
                cookieMap.put("httponly", "");
            }
            if (cookieValue.toLowerCase().contains("secure")) {
                cookieMap.put("secure", "");
            }
            cookies.add(cookieMap);
        } else if ("Cookie".equalsIgnoreCase(cookieName)) {
            for (Map.Entry<String, String> cookieMapEntry : cookieMap.entrySet()) {
                HashMap<String, String> cookieOneMap = new HashMap<String, String>();
                cookieOneMap.put(cookieMapEntry.getKey(), cookieMapEntry.getValue());
                cookies.add(cookieOneMap);
            }
        }
    }

    private static byte[] dealBodyContent(Map<String, Object> packetMap, byte[] contentBytes) throws IOException {
        if (contentBytes.length == 0) {
            return contentBytes;
        }
        boolean isGZip = packetMap.get("Content-Encoding") == null ? false : packetMap.get("Content-Encoding").toString().contains("gzip");
        byte[] bytesValue = isGZip && contentBytes.length > 0 ? TZip.decodeGZip(contentBytes) : contentBytes;
        return TObject.nullDefault(bytesValue, new byte[0]);
    }

    public static void parserProtocol(Map<String, Object> packetMap, int type, ByteBuffer byteBuffer) throws ParserException {
        byte[] bytes = THREAD_STRING_BUILDER.get();
        int position = 0;
        int hashCode = 0;
        int segment = 0;
        String segment_1 = "";
        String segment_2 = "";
        String segment_3 = "";
        int questPositiion = -1;
        int prevByte = 0;
        byte currentByte = 0;
        while (byteBuffer.remaining() > 0) {
            HttpItem httpItem;
            currentByte = byteBuffer.get();
            if (currentByte == 32 && segment < 2) {
                if (segment == 0) {
                    httpItem = HttpItem.getHttpItem(bytes, 0, position);
                    hashCode = hashCode + httpItem.getHashCode() << 1;
                    segment_1 = httpItem.getString();
                } else if (segment == 1) {
                    httpItem = HttpItem.getHttpItem(bytes, 0, position);
                    hashCode = hashCode + httpItem.getHashCode() << 2;
                    segment_2 = httpItem.getString();
                }
                position = 0;
                ++segment;
                continue;
            }
            if (currentByte == 63) {
                if (segment == 1) {
                    questPositiion = byteBuffer.position();
                    continue;
                }
            } else if (prevByte == 13 && currentByte == 10 && segment == 2) {
                httpItem = HttpItem.getHttpItem(bytes, 0, position);
                hashCode = hashCode + httpItem.getHashCode() << 3;
                segment_3 = httpItem.getString();
                position = 0;
                break;
            }
            prevByte = currentByte;
            if (currentByte == 13) continue;
            bytes[position] = currentByte;
            ++position;
        }
        if (type == 0) {
            packetMap.put(PL_METHOD, segment_1);
            questPositiion = questPositiion - segment_1.length() - 1;
            packetMap.put(PL_PATH, questPositiion > 0 ? segment_2.substring(0, questPositiion - 1) : segment_2);
            if (questPositiion > 0) {
                packetMap.put(PL_QUERY_STRING, segment_2.substring(questPositiion - 1));
            }
            if (segment_3.charAt(0) != 'H' || segment_3.charAt(1) != 'T' || segment_3.charAt(2) != 'T' || segment_3.charAt(3) != 'P') {
                throw new ParserException("Not a http packet");
            }
            packetMap.put(PL_PROTOCOL, HttpStatic.HTTP.getString());
            switch (segment_3.charAt(7)) {
                case '1': {
                    packetMap.put(PL_VERSION, "1.1");
                    break;
                }
                case '0': {
                    packetMap.put(PL_VERSION, "1.0");
                    break;
                }
                case '9': {
                    packetMap.put(PL_VERSION, "0.9");
                    break;
                }
                default: {
                    packetMap.put(PL_VERSION, "1.1");
                }
            }
        }
        if (type == 1) {
            if (segment_1.charAt(0) != 'H' || segment_1.charAt(1) != 'T' || segment_1.charAt(2) != 'T' || segment_1.charAt(3) != 'P') {
                throw new ParserException("Not a http packet");
            }
            packetMap.put(PL_PROTOCOL, HttpStatic.HTTP.getString());
            switch (segment_1.charAt(7)) {
                case '1': {
                    packetMap.put(PL_VERSION, "1.1");
                    break;
                }
                case '0': {
                    packetMap.put(PL_VERSION, "1.0");
                    break;
                }
                case '9': {
                    packetMap.put(PL_VERSION, "0.9");
                    break;
                }
                default: {
                    packetMap.put(PL_VERSION, "1.1");
                }
            }
            packetMap.put(PL_STATUS, segment_2);
            packetMap.put(PL_STATUS_CODE, segment_3);
        }
        if (WebContext.isCache()) {
            packetMap.put(PL_HASH, hashCode);
        }
    }

    public static boolean parseHeader(Map<String, Object> packetMap, ByteBuffer byteBuffer) throws ParserException {
        byte[] bytes = THREAD_STRING_BUILDER.get();
        int position = 0;
        boolean onHeaderName = true;
        int prevByte = 0;
        byte currentByte = 0;
        String headerName = null;
        String headerValue = null;
        while (byteBuffer.remaining() > 0) {
            currentByte = byteBuffer.get();
            if (onHeaderName && prevByte == 58 && currentByte == 32) {
                headerName = HttpItem.getHttpItem(bytes, 0, position).getString();
                onHeaderName = false;
                position = 0;
                continue;
            }
            if (!onHeaderName && prevByte == 13 && currentByte == 10) {
                headerValue = HttpItem.getHttpItem(bytes, 0, position).getString();
                break;
            }
            if (onHeaderName && prevByte == 13 && currentByte == 10) {
                return true;
            }
            prevByte = currentByte;
            if (onHeaderName && currentByte == 58 || !onHeaderName && currentByte == 13) continue;
            bytes[position] = currentByte;
            ++position;
        }
        packetMap.put(headerName, headerValue);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> parser(IoSession session, Map<String, Object> packetMap, int type, ByteBufferChannel byteBufferChannel, int timeOut, long requestMaxSize) throws IOException {
        int totalLength = 0;
        boolean isBodyConent = false;
        long l = requestMaxSize = requestMaxSize < 0L ? Integer.MAX_VALUE : requestMaxSize;
        while (byteBufferChannel.size() > 0) {
            String transferEncoding;
            ByteBuffer innerByteBuffer = byteBufferChannel.getByteBuffer();
            long mark = 0L;
            int headerMark = 0;
            try {
                HttpParser.parserProtocol(packetMap, type, innerByteBuffer);
                int protocolPosition = innerByteBuffer.position() - 1;
                if (WebContext.isCache()) {
                    mark = ((Integer)packetMap.get(PL_HASH)).longValue();
                    for (Map.Entry<Long, Map<String, Object>> packetMapCacheItem : PACKET_MAP_CACHE.entrySet()) {
                        long cachedMark = packetMapCacheItem.getKey();
                        long position = cachedMark << 32 >> 32;
                        if (position > (long)innerByteBuffer.limit()) continue;
                        headerMark = THash.hashTime31(innerByteBuffer, protocolPosition, (int)(position - (long)protocolPosition));
                        if (mark + (long)headerMark != cachedMark >> 32 || (long)byteBufferChannel.size() < position || byteBufferChannel.get((int)position - 1) != 10 || byteBufferChannel.get((int)position - 2) != 13) continue;
                        innerByteBuffer.position((int)position);
                        Map<String, Object> map = packetMapCacheItem.getValue();
                        return map;
                    }
                }
                if (!packetMap.containsKey(PL_PROTOCOL)) {
                    Iterator<Map.Entry<Long, Map<String, Object>>> iterator = null;
                    return iterator;
                }
                while (!HttpParser.parseHeader(packetMap, innerByteBuffer)) {
                }
                String cookieName = null;
                String cookieValue = null;
                if (packetMap.containsKey("Set-Cookie")) {
                    cookieName = "Set-Cookie";
                    cookieValue = packetMap.get("Set-Cookie").toString();
                    packetMap.remove("Set-Cookie");
                } else if (packetMap.containsKey("Cookie")) {
                    cookieName = "Cookie";
                    cookieValue = packetMap.get("Cookie").toString();
                    packetMap.remove("Cookie");
                }
                if (cookieName != null) {
                    HttpParser.parseCookie(packetMap, cookieName, cookieValue);
                }
                if (WebContext.isCache()) {
                    totalLength = innerByteBuffer.position();
                    headerMark = THash.hashTime31(innerByteBuffer, protocolPosition, totalLength - protocolPosition);
                    mark = mark + (long)headerMark << 32 | (long)totalLength;
                    packetMap.put(PL_HASH, mark);
                }
            }
            finally {
                byteBufferChannel.compact();
            }
            if ("GET".equals(packetMap.get(PL_METHOD)) || !packetMap.containsKey("Content-Type")) {
                if (!WebContext.isCache()) break;
                HashMap<String, Object> cachedPacketMap = new HashMap<String, Object>();
                cachedPacketMap.putAll(packetMap);
                cachedPacketMap.put(USE_CACHE, 1);
                PACKET_MAP_CACHE.put(mark, cachedPacketMap);
                break;
            }
            isBodyConent = true;
            packetMap.put(PL_HASH, null);
            Runnable contiuneRead = () -> {
                if (session != null) {
                    session.getSocketSelector().eventChoose();
                }
            };
            if (!isBodyConent) continue;
            String contentType = packetMap.get("Content-Type") == null ? "" : packetMap.get("Content-Type").toString();
            String string = transferEncoding = packetMap.get("Transfer-Encoding") == null ? "" : packetMap.get("Transfer-Encoding").toString();
            if (contentType.contains(MULTIPART_FORM_DATA)) {
                ArrayList<HashMap<String, Object>> bodyPartList = new ArrayList<HashMap<String, Object>>();
                String boundary = TString.assembly("--", HttpParser.getPerprotyEqualValue(packetMap, "Content-Type", "boundary"));
                ByteBuffer boundaryEnd = ByteBuffer.allocate(2);
                while (true) {
                    if (!byteBufferChannel.waitData(boundary.getBytes(), timeOut, contiuneRead)) {
                        throw new ParserException("Http Parser readFromChannel data error");
                    }
                    int index = byteBufferChannel.indexOf(boundary.getBytes(Global.CS_UTF_8));
                    byteBufferChannel.shrink(index + boundary.length());
                    boundaryEnd.clear();
                    int readSize = byteBufferChannel.readHead(boundaryEnd);
                    if ((long)(totalLength += readSize) > requestMaxSize * 1024L) {
                        throw new RequestTooLarge("Request is too large: {max size: " + requestMaxSize * 1024L + ", expect size: " + totalLength + "}");
                    }
                    if (Arrays.equals(boundaryEnd.array(), "--".getBytes())) {
                        byteBufferChannel.shrink(2);
                        break;
                    }
                    byte[] boundaryMark = HttpStatic.BODY_MARK.getBytes();
                    if (!byteBufferChannel.waitData(boundaryMark, timeOut, contiuneRead)) {
                        throw new ParserException("Http Parser readFromChannel data error");
                    }
                    int partHeadEndIndex = byteBufferChannel.indexOf(boundaryMark);
                    ByteBuffer partHeadBuffer = TByteBuffer.allocateDirect(partHeadEndIndex + 4);
                    byteBufferChannel.readHead(partHeadBuffer);
                    ByteBufferChannel partByteBufferChannel = new ByteBufferChannel(partHeadEndIndex + 4);
                    partByteBufferChannel.writeEnd(partHeadBuffer);
                    HashMap<String, Object> partMap = new HashMap<String, Object>();
                    while (HttpParser.parseHeader(partMap, partByteBufferChannel.getByteBuffer())) {
                    }
                    partByteBufferChannel.compact();
                    TByteBuffer.release(partHeadBuffer);
                    partByteBufferChannel.release();
                    TByteBuffer.release(partHeadBuffer);
                    String fileName = HttpParser.getPerprotyEqualValue(partMap, "Content-Disposition", "filename");
                    if (fileName != null && fileName.isEmpty()) break;
                    index = -1;
                    if (fileName == null) {
                        if (!byteBufferChannel.waitData(boundary.getBytes(), timeOut, contiuneRead)) {
                            throw new ParserException("Http Parser readFromChannel data error");
                        }
                        index = byteBufferChannel.indexOf(boundary.getBytes(Global.CS_UTF_8));
                        ByteBuffer bodyByteBuffer = ByteBuffer.allocate(index - 2);
                        byteBufferChannel.readHead(bodyByteBuffer);
                        partMap.put(BODY_VALUE, bodyByteBuffer.array());
                    } else {
                        String fileExtName = TFile.getFileExtension(fileName);
                        fileExtName = fileExtName == null || fileExtName.equals("") ? "tmp" : fileExtName;
                        String localFileName = TString.assembly(UPLOAD_PATH, Global.NAME, System.currentTimeMillis(), ".", fileExtName);
                        boolean isFileRecvDone = false;
                        while (true) {
                            int length;
                            byteBufferChannel.getByteBuffer();
                            int dataLength = 0;
                            try {
                                dataLength = byteBufferChannel.size();
                                if (byteBufferChannel.waitData(boundary.getBytes(), 1, contiuneRead)) {
                                    isFileRecvDone = true;
                                }
                            }
                            finally {
                                byteBufferChannel.compact();
                            }
                            if (!isFileRecvDone) {
                                if (dataLength == 0) continue;
                                byteBufferChannel.saveToFile(localFileName, dataLength);
                                totalLength += dataLength;
                                continue;
                            }
                            index = byteBufferChannel.indexOf(boundary.getBytes(Global.CS_UTF_8));
                            int n = length = index == -1 ? byteBufferChannel.size() : index - 2;
                            if (index > 0) {
                                byteBufferChannel.saveToFile(localFileName, length);
                                totalLength += dataLength;
                            }
                            if ((long)totalLength > requestMaxSize * 1024L) {
                                TFile.deleteFile(new File(localFileName));
                                throw new RequestTooLarge("Request is too large: {max size: " + requestMaxSize * 1024L + ", expect size: " + totalLength + "}");
                            }
                            if (isFileRecvDone) break;
                            TEnv.sleep(100);
                        }
                        if (index == -1) {
                            new File(localFileName).delete();
                            throw new ParserException("Http Parser not enough data with " + boundary);
                        }
                        partMap.remove(BODY_VALUE);
                        partMap.put(BODY_FILE, localFileName.getBytes());
                    }
                    bodyPartList.add(partMap);
                }
                packetMap.put(BODY_PARTS, bodyPartList);
                break;
            }
            if ("chunked".equals(transferEncoding)) {
                ByteBufferChannel chunkedByteBufferChannel = new ByteBufferChannel(3);
                String chunkedLengthLine = "";
                while (chunkedLengthLine != null) {
                    if (!byteBufferChannel.waitData("\r\n".getBytes(), timeOut, contiuneRead)) {
                        throw new ParserException("Http Parser readFromChannel data error");
                    }
                    chunkedLengthLine = byteBufferChannel.readLine().trim();
                    if ("0".equals(chunkedLengthLine)) break;
                    if (chunkedLengthLine.isEmpty()) continue;
                    int chunkedLength = 0;
                    try {
                        chunkedLength = Integer.parseInt(chunkedLengthLine, 16);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break;
                    }
                    if (!byteBufferChannel.waitData(chunkedLength, timeOut, contiuneRead)) {
                        throw new ParserException("Http Parser readFromChannel data error");
                    }
                    int readSize = 0;
                    if (chunkedLength > 0) {
                        ByteBuffer byteBuffer = TByteBuffer.allocateDirect(chunkedLength);
                        readSize = byteBufferChannel.readHead(byteBuffer);
                        totalLength += readSize;
                        if (readSize != chunkedLength) {
                            throw new ParserException("Http Parser readFromChannel chunked data error");
                        }
                        chunkedByteBufferChannel.writeEnd(byteBuffer);
                        TByteBuffer.release(byteBuffer);
                    }
                    if ((long)totalLength > requestMaxSize * 1024L) {
                        throw new RequestTooLarge("Request is too large: {max size: " + requestMaxSize * 1024L + ", expect size: " + totalLength + "}");
                    }
                    byteBufferChannel.shrink(2);
                }
                byte[] value = HttpParser.dealBodyContent(packetMap, chunkedByteBufferChannel.array());
                chunkedByteBufferChannel.release();
                packetMap.put(BODY_VALUE, value);
                byteBufferChannel.shrink(2);
                break;
            }
            if (!packetMap.containsKey("Content-Length")) break;
            int contentLength = Integer.parseInt(packetMap.get("Content-Length").toString());
            if ((long)(totalLength += contentLength) > requestMaxSize * 1024L) {
                throw new ParserException("Request is too large: {max size: " + requestMaxSize * 1024L + ", expect size: " + totalLength + "}");
            }
            if (!byteBufferChannel.waitData(contentLength, timeOut, contiuneRead)) {
                throw new ParserException("Http Parser readFromChannel data error");
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(contentLength);
            byteBufferChannel.readHead(byteBuffer);
            byte[] contentBytes = byteBuffer.array();
            byte[] value = HttpParser.dealBodyContent(packetMap, contentBytes);
            packetMap.put(BODY_VALUE, value);
            break;
        }
        return packetMap;
    }

    public static Request parseRequest(IoSession session, ByteBufferChannel byteBufferChannel, int timeOut, long requestMaxSize) throws IOException {
        Request request = null;
        Map<String, Object> packetMap = THREAD_PACKET_MAP.get();
        try {
            packetMap = HttpParser.parser(session, packetMap, 0, byteBufferChannel, timeOut, requestMaxSize);
        }
        catch (ParserException e) {
            byteBufferChannel.clear();
            Logger.warn("HttpParser.parser: " + e.getMessage());
            return null;
        }
        if (packetMap == null || packetMap.isEmpty() || byteBufferChannel.isReleased()) {
            return null;
        }
        request = THREAD_REQUEST.get();
        request.clear();
        Set<Map.Entry<String, Object>> parsedItems = packetMap.entrySet();
        block24: for (Map.Entry<String, Object> parsedPacketEntry : parsedItems) {
            String key;
            switch (key = parsedPacketEntry.getKey()) {
                case "1": {
                    request.protocol().setMethod(parsedPacketEntry.getValue().toString());
                    break;
                }
                case "3": {
                    request.protocol().setProtocol(parsedPacketEntry.getValue().toString());
                    break;
                }
                case "7": {
                    request.protocol().setQueryString(parsedPacketEntry.getValue().toString());
                    break;
                }
                case "4": {
                    request.protocol().setVersion(parsedPacketEntry.getValue().toString());
                    break;
                }
                case "2": {
                    request.protocol().setPath(parsedPacketEntry.getValue().toString());
                    break;
                }
                case "8": {
                    request.setMark((Long)parsedPacketEntry.getValue());
                    break;
                }
                case "Cookie": {
                    List cookieMap = (List)packetMap.get("Cookie");
                    for (Map cookieMapItem : cookieMap) {
                        Cookie cookie = Cookie.buildCookie(cookieMapItem);
                        request.cookies().add(cookie);
                    }
                    cookieMap.clear();
                    break;
                }
                case "11": {
                    byte[] value = (byte[])parsedPacketEntry.getValue();
                    request.body().write(value);
                    break;
                }
                case "10": {
                    List parsedParts = (List)parsedPacketEntry.getValue();
                    for (Map parsedPartMap : parsedParts) {
                        Part part = new Part();
                        for (Map.Entry parsedPartMapItem : parsedPartMap.entrySet()) {
                            if (((String)parsedPartMapItem.getKey()).equals(BODY_VALUE)) {
                                part.body().changeToBytes((byte[])parsedPartMapItem.getValue());
                            }
                            if (((String)parsedPartMapItem.getKey()).equals(BODY_FILE)) {
                                String filePath = new String((byte[])parsedPartMapItem.getValue());
                                part.body().changeToFile(new File(filePath));
                                continue;
                            }
                            String partedHeaderKey = (String)parsedPartMapItem.getKey();
                            String partedHeaderValue = parsedPartMapItem.getValue().toString();
                            part.header().put(partedHeaderKey, partedHeaderValue);
                            if (!"Content-Disposition".equals(partedHeaderKey)) continue;
                            Map<String, String> contentDispositionValue = HttpParser.getEqualMap(partedHeaderValue);
                            part.header().putAll(contentDispositionValue);
                        }
                        request.parts().add(part);
                        parsedPartMap.clear();
                    }
                    continue block24;
                }
                default: {
                    request.header().put(parsedPacketEntry.getKey(), parsedPacketEntry.getValue().toString());
                }
            }
        }
        if (!packetMap.containsKey(USE_CACHE)) {
            packetMap.clear();
        }
        return request;
    }

    public static Response parseResponse(IoSession session, ByteBufferChannel byteBufferChannel, int timeOut) throws IOException {
        Map<String, Object> packetMap = THREAD_PACKET_MAP.get();
        try {
            packetMap = HttpParser.parser(session, packetMap, 1, byteBufferChannel, timeOut, -1L);
            packetMap.remove(PL_HASH);
        }
        catch (ParserException e) {
            byteBufferChannel.clear();
            Logger.warn("HttpParser.parser: " + e.getMessage());
            return null;
        }
        if (packetMap == null || packetMap.isEmpty() || byteBufferChannel.isReleased()) {
            return null;
        }
        Response response = THREAD_RESPONSE.get();
        response.clear();
        Set<Map.Entry<String, Object>> parsedItems = packetMap.entrySet();
        block18: for (Map.Entry<String, Object> parsedPacketEntry : parsedItems) {
            String key;
            switch (key = parsedPacketEntry.getKey()) {
                case "3": {
                    response.protocol().setProtocol(parsedPacketEntry.getValue().toString());
                    break;
                }
                case "4": {
                    response.protocol().setVersion(parsedPacketEntry.getValue().toString());
                    break;
                }
                case "5": {
                    response.protocol().setStatus(Integer.parseInt(parsedPacketEntry.getValue().toString()));
                    break;
                }
                case "6": {
                    response.protocol().setStatusCode(parsedPacketEntry.getValue().toString());
                    break;
                }
                case "Cookie": {
                    List cookieMap = (List)parsedPacketEntry.getValue();
                    for (Map cookieMapItem : cookieMap) {
                        Cookie cookie = Cookie.buildCookie(cookieMapItem);
                        response.cookies().add(cookie);
                    }
                    continue block18;
                }
                case "11": {
                    response.body().write((byte[])parsedPacketEntry.getValue());
                    break;
                }
                default: {
                    response.header().put(parsedPacketEntry.getKey(), parsedPacketEntry.getValue().toString());
                }
            }
        }
        packetMap.clear();
        return response;
    }

    public static void resetThreadLocal() {
        THREAD_REQUEST.set(new Request());
        THREAD_RESPONSE.set(new Response());
    }

    static {
        Global.getHashWheelTimer().addTask(new HashWheelTask(){

            @Override
            public void run() {
                PACKET_MAP_CACHE.clear();
            }
        }, 60);
    }
}

